/* Author: Clauirton Siebra <c.siebra@ed.ac.uk>
 * Updated: Wen Mar 23 09:08:58 2002 by Clauirton Siebra
 * Copyright: (c) 2001-2003, AIAI, University of Edinburgh
 */

package ix.ip2.map;

import javax.swing.*;
import java.awt.Component;
import java.awt.event.*; 
import java.awt.BorderLayout; 
import java.awt.FlowLayout; 
import java.awt.GridLayout;
import java.util.*;

import ix.util.*; import ix.util.lisp.*; import ix.ip2.*; import
ix.icore.domain.PatternAssignment; import
ix.iface.util.CatchingActionListener;

/**
 * Class that creates the add frame, enabling the insertion of new property/value to an object.
 */

public class AddPropValFrame extends JFrame implements ActionListener {

    JTextField propTF,valTF;
    StateViewer sv;
    Object objName;

    public AddPropValFrame(StateViewer sv, Object objName) {
        super("Add Property/Value");
        this.sv = sv;
        this.objName = objName;
        
        JPanel addP = new JPanel();
        addP.setLayout(new GridLayout(2,3,5,5));
        JPanel syntaxP = new JPanel();
        JPanel buttonP = new JPanel();
        //buttonP.setLayout(new FlowLayout(FlowLayout.CENTER));
        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(addP,BorderLayout.CENTER);
        //getContentPane().add(syntaxP,BorderLayout.CENTER);
        getContentPane().add(buttonP,BorderLayout.SOUTH);

	addP.add(new JLabel("Property",SwingConstants.CENTER));
	addP.add(new JLabel("Object",SwingConstants.CENTER));
	addP.add(new JLabel("Value",SwingConstants.CENTER));
	addP.validate();

        propTF = new JTextField();
        addP.add(propTF);
        addP.add(new JLabel(objName.toString()+" =",SwingConstants.CENTER));
        //compTF = new JTextField(20);
        //addP.add(compTF);
        valTF = new JTextField();
        //addP.add(new JLabel("="));
        addP.add(valTF);
        
        //JLabel syntaxL = new JLabel("Syntax:  property OBJECT = value");
        //syntaxP.add(syntaxL);
        
        JButton sendB = new JButton("Add");
        sendB.addActionListener(CatchingActionListener.listener(this));
        buttonP.add(sendB);

        JButton clearB = new JButton("Clear");
        clearB.addActionListener(CatchingActionListener.listener(this));
        buttonP.add(clearB);
    
        JButton cancelB = new JButton("Cancel");
        cancelB.addActionListener(CatchingActionListener.listener(this));
        buttonP.add(cancelB);
        
        //setSize(550,100);
        pack();
        setVisible(true);
        
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                dispose();
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Debug.noteln("Map Tool action:", command);
        if (command.equals("Cancel")) {
            dispose();
        }
        else if (command.equals("Add")) {
            LList llist = Lisp.NIL;
            /*if(!compTF.getText().equals("")) {
                String[] pArray = (compTF.getText()).split(" ");
                for(int x=pArray.length-1;x>=0;x--)
                    llist = Lisp.cons(Symbol.intern(pArray[x]),llist);
	    } */
            llist = Lisp.cons(objName,llist);
            llist = Lisp.cons(Symbol.intern(propTF.getText()),llist);
            
            sendConstraint(new PatternAssignment(llist,Symbol.intern(valTF.getText())));
            dispose();
        }
        else if (command.equals("Clear")) {
            propTF.setText("");
            //compTF.setText("");
            valTF.setText("");
            propTF.requestFocusInWindow();
        }
        else
            Debug.noteln("Nothing to do", command);
    }

    protected void sendConstraint(PatternAssignment pa) {
	if(sv instanceof ix.ip2.map.MapWhiteboard)
	    ((MapWhiteboard)sv).sendConstraint(pa);
	else
	   ((StateViewMap)sv).sendConstraint(pa);
    }

}
