/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.iface.util.CatchingActionListener;
import ix.iface.util.IconImage;
import ix.iface.util.ToolFrame;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.TextAreaFrame;
import ix.util.xml.XML;
import ix.util.xml.XMLTreeEditFrame;
import ix.util.xml.event.NamespaceEvent;
import ix.util.xml.event.NamespaceListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdom.Namespace;

public class XMLTreeNamespaceManager {
    protected NamespaceFrame frame;
    protected JTable table;
    protected NamespaceTableModel model;
    protected NamespaceMap namespaces;
    protected List namespaceListeners = new LinkedList();
    protected int niceColorsUsed = 0;
    protected int[] niceColors = new int[]{0x228B22, 0x8B0000, 12092939, 9055202, 35723, 0xFF6666, 10506797, 49151, 65407, 13047173, 0x808000, 128, 52945, 16729344, 0xFFCC33, 10145074};
    protected String[] helpText = new String[]{"Right-press on a row to change the color."};

    public XMLTreeNamespaceManager(String string) {
        this.namespaces = new NamespaceMap();
        this.addInitialNamespaces(this.namespaces);
        this.model = new NamespaceTableModel();
        this.table = new NamespaceJTable(this.model);
        this.frame = new NamespaceFrame(string);
        this.frame.setupFrame();
    }

    protected void addInitialNamespaces(NamespaceMap namespaceMap) {
        namespaceMap.add(Namespace.NO_NAMESPACE, Color.black);
        namespaceMap.add(XML.getHomeNamespace(), Color.blue);
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public List getNamespaces() {
        return this.namespaces.getNamespaces();
    }

    public Namespace parseNamespaceSpec(String string) {
        String[] stringArray = Strings.breakAtFirst("=", string);
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        if (string3.equals("") && !string2.equals("")) {
            string3 = string2;
            string2 = "";
        }
        return Namespace.getNamespace((String)string2, (String)string3);
    }

    public Color getNamespaceColor(Namespace namespace) {
        Color color = this.namespaces.getColor(namespace);
        if (color == null) {
            throw new IllegalArgumentException("Unknown namespace " + namespace);
        }
        return color;
    }

    public void noteNamespace(Namespace namespace) {
        Color color = this.namespaces.getColor(namespace);
        if (color == null) {
            this.namespaces.add(namespace, this.pickNewNamespaceColor(namespace));
            int n = this.namespaces.indexOf(namespace);
            this.model.fireTableRowsInserted(n, n);
        }
    }

    protected Color pickNewNamespaceColor(Namespace namespace) {
        if (this.niceColorsUsed >= this.niceColors.length) {
            Debug.noteln("Out of nice colors");
            return Color.red;
        }
        return new Color(this.niceColors[this.niceColorsUsed++]);
    }

    public void addNamespaceListener(NamespaceListener namespaceListener) {
        this.namespaceListeners.add(namespaceListener);
    }

    public void fireNamespaceEvent(NamespaceEvent namespaceEvent) {
        Iterator iterator = this.namespaceListeners.iterator();
        while (iterator.hasNext()) {
            ((NamespaceListener)iterator.next()).namespaceEvent(namespaceEvent);
        }
    }

    class RowPopupMenu
    extends JPopupMenu
    implements ActionListener {
        int row = -1;

        RowPopupMenu() {
            this.add(this.makeMenuItem("Change Color"));
        }

        JMenuItem makeMenuItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(CatchingActionListener.listener(this));
            return jMenuItem;
        }

        void setRow(int n) {
            this.row = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Row popup command", string);
            Debug.expect(this.row >= 0);
            if (!string.equals("Change Color")) {
                throw new ConsistencyException("Nothing to do for " + string);
            }
            this.changeColor();
        }

        void changeColor() {
            Namespace namespace = XMLTreeNamespaceManager.this.namespaces.getEntryNamespace(this.row);
            Color color = JColorChooser.showDialog(this, "Color for " + namespace, XMLTreeNamespaceManager.this.namespaces.getEntryColor(this.row));
            if (color == null) {
                return;
            }
            XMLTreeNamespaceManager.this.namespaces.setColor(namespace, color);
            XMLTreeNamespaceManager.this.model.fireTableRowsUpdated(this.row, this.row);
            XMLTreeNamespaceManager.this.fireNamespaceEvent(new NamespaceEvent(namespace, color));
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        RowPopupMenu popup;

        TableMouseListener() {
            this.popup = new RowPopupMenu();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                int n = XMLTreeNamespaceManager.this.table.rowAtPoint(mouseEvent.getPoint());
                Debug.noteln("Table right press in row", n);
                this.popup.setRow(n);
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class NamespaceTableModel
    extends AbstractTableModel {
        final String[] columnName = new String[]{"Prefix", "URI"};
        final int PREFIX_COL = 0;
        final int URI_COL = 1;

        NamespaceTableModel() {
        }

        public String getColumnName(int n) {
            return this.columnName[n];
        }

        public int getColumnCount() {
            return this.columnName.length;
        }

        public int getRowCount() {
            return XMLTreeNamespaceManager.this.namespaces.size();
        }

        public Class getColumnClass(int n) {
            return Namespace.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            Namespace namespace = XMLTreeNamespaceManager.this.namespaces.getEntryNamespace(n);
            switch (n2) {
                case 0: {
                    return namespace.getPrefix();
                }
                case 1: {
                    return namespace == Namespace.NO_NAMESPACE ? "No namespace" : namespace.getURI();
                }
            }
            throw new ConsistencyException("Bogus column " + n2);
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }

    class NamespaceJTable
    extends JTable {
        NamespaceJTable(TableModel tableModel) {
            super(tableModel);
            this.setPreferredColumnWidths();
        }

        void setPreferredColumnWidths() {
            for (int i = 0; i < XMLTreeNamespaceManager.this.model.getColumnCount(); ++i) {
                TableColumn tableColumn = this.getColumnModel().getColumn(i);
                if (i == XMLTreeNamespaceManager.this.model.PREFIX_COL) {
                    tableColumn.setPreferredWidth(45);
                    continue;
                }
                if (i == XMLTreeNamespaceManager.this.model.URI_COL) {
                    tableColumn.setPreferredWidth(360);
                    continue;
                }
                throw new ConsistencyException("Bogus column " + i);
            }
        }
    }

    class NamespaceCellRenderer
    extends DefaultTableCellRenderer {
        NamespaceCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setBackground(Color.white);
            this.setForeground(XMLTreeNamespaceManager.this.namespaces.getEntryColor(n));
            return this;
        }
    }

    protected class NamespaceFrame
    extends ToolFrame
    implements ActionListener {
        TextAreaFrame helpFrame;
        Container contentPane;

        NamespaceFrame(String string) {
            super(string);
        }

        void setupFrame() {
            this.setIconImage(IconImage.getIconImage(this));
            this.setJMenuBar(this.makeMenuBar());
            XMLTreeNamespaceManager.this.table.getTableHeader().setReorderingAllowed(false);
            XMLTreeNamespaceManager.this.table.setDefaultRenderer(Namespace.class, new NamespaceCellRenderer());
            XMLTreeNamespaceManager.this.table.setPreferredScrollableViewportSize(XMLTreeNamespaceManager.this.table.getPreferredSize());
            XMLTreeNamespaceManager.this.table.addMouseListener(new TableMouseListener());
            this.contentPane = this.getContentPane();
            JScrollPane jScrollPane = new JScrollPane(XMLTreeNamespaceManager.this.table);
            jScrollPane.setBorder(BorderFactory.createTitledBorder("Namespaces"));
            this.contentPane.add((Component)jScrollPane, "Center");
            this.contentPane.add((Component)this.makeButtonPanel(), "South");
            this.pack();
            Dimension dimension = this.getSize();
            this.setSize(new Dimension((int)Math.round(dimension.getWidth()), 200));
        }

        JMenuBar makeMenuBar() {
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            jMenu.add(this.makeMenuItem("Close"));
            JMenu jMenu2 = new JMenu("Help");
            jMenu2.add(this.makeMenuItem("Help"));
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            return jMenuBar;
        }

        JMenuItem makeMenuItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(CatchingActionListener.listener(this));
            return jMenuItem;
        }

        JPanel makeButtonPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(this.makeButton("Add Namespace"));
            jPanel.add(Box.createHorizontalGlue());
            return jPanel;
        }

        JButton makeButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(CatchingActionListener.listener(this));
            return jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Namespace frame action:", string);
            if (string.equals("Close")) {
                XMLTreeNamespaceManager.this.frame.setVisible(false);
            } else if (string.equals("Help")) {
                this.showHelp();
            } else if (string.equals("Add Namespace")) {
                this.doAddNamespace();
            } else {
                throw new ConsistencyException("Nothing to do for " + string);
            }
        }

        void showHelp() {
            if (this.helpFrame == null) {
                this.helpFrame = new XMLTreeEditFrame.TreeHelpFrame("Namespace Manager Help");
                this.helpFrame.setText(this.makeHelpText());
            }
            this.helpFrame.setVisible(true);
        }

        String makeHelpText() {
            return Strings.joinLines(XMLTreeNamespaceManager.this.helpText);
        }

        void doAddNamespace() {
            String string = JOptionPane.showInputDialog(XMLTreeNamespaceManager.this.table, (Object)"Enter namespace as prefix=URI");
            if (string == null) {
                return;
            }
            Namespace namespace = XMLTreeNamespaceManager.this.parseNamespaceSpec(string);
            if (namespace == Namespace.NO_NAMESPACE) {
                return;
            }
            Debug.noteln("Adding Namespace", namespace);
            XMLTreeNamespaceManager.this.noteNamespace(namespace);
        }
    }

    protected class NamespaceComparator
    implements Comparator {
        protected NamespaceComparator() {
        }

        public int compare(Object object, Object object2) {
            Namespace namespace = (Namespace)object;
            Namespace namespace2 = (Namespace)object2;
            int n = namespace.getURI().compareTo(namespace2.getURI());
            if (n == 0) {
                return namespace.getPrefix().compareTo(namespace2.getPrefix());
            }
            return n;
        }
    }

    protected class NamespaceMap {
        Comparator namespaceComparator;
        Map namespaceToColorMap;
        List namespaceList;

        NamespaceMap() {
            this.namespaceComparator = new NamespaceComparator();
            this.namespaceToColorMap = new TreeMap(this.namespaceComparator);
            this.namespaceList = new ArrayList(10);
        }

        void add(Namespace namespace, Color color) {
            this.namespaceToColorMap.put(namespace, color);
            this.namespaceList.add(namespace);
            Collections.sort(this.namespaceList, this.namespaceComparator);
        }

        List getNamespaces() {
            return Collections.unmodifiableList(this.namespaceList);
        }

        int size() {
            return this.namespaceList.size();
        }

        Color getColor(Namespace namespace) {
            return (Color)this.namespaceToColorMap.get(namespace);
        }

        void setColor(Namespace namespace, Color color) {
            if (this.getColor(namespace) == null) {
                throw new IllegalArgumentException("Can't set color for unknown namespace " + namespace);
            }
            Debug.expect(this.namespaceList.contains(namespace));
            this.namespaceToColorMap.put(namespace, color);
        }

        int indexOf(Namespace namespace) {
            return this.namespaceList.indexOf(namespace);
        }

        Namespace getEntryNamespace(int n) {
            return (Namespace)this.namespaceList.get(n);
        }

        Color getEntryColor(int n) {
            return (Color)this.namespaceToColorMap.get(this.namespaceList.get(n));
        }
    }
}

