/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.icore.IXAgent;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.IconImage;
import ix.iface.util.ToolController;
import ix.iface.util.ToolFrame;
import ix.iface.util.ToolManager;
import ix.ispace.ISpaceTool;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.TextAreaFrame;
import ix.util.Util;
import ix.util.xml.XML;
import ix.util.xml.XMLLoader;
import ix.util.xml.XMLSaver;
import ix.util.xml.XMLTreeEditPanel;
import ix.util.xml.XMLTreeEditor;
import ix.util.xml.XMLTreeNamespaceManager;
import ix.util.xml.XMLTreeSendFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.jdom.Document;

public class XMLTreeEditFrame
extends ToolFrame
implements ActionListener {
    protected IXAgent agent;
    protected Container contentPane = this.getContentPane();
    protected XMLTreeEditPanel editPanel;
    protected FrameGroup frameGroup;
    protected TreeHelpFrame helpFrame = null;
    protected static FindFrame findFrame = null;
    protected static XMLTreeSendFrame sendFrame = null;
    protected static ToolManager toolManager;
    protected static FrameGroup globalFrameGroup;
    static XMLTreeNamespaceManager namespaces;
    protected String[] sharedHelp = new String[]{"The left mouse button can be used to expand and", "contract nodes, and the right button produces a menu", "that can fully expand or contract the subtree rooted", "at the node, as well a performing other operations.", "", "The left button can also be used to select a node.", "When a tree node is selected, its text is displayed", "in a separate area at the bottom.  This makes it easier", "to read and edit long strings.", "", "Select \"Edit\" -> \"Namespaces\" from the menu bar", "to bring up a tool that allows you to define new", "namespaces and change color assignments.", "", "\"Edit\" -> \"Find In Tree\" can be used to find", "specified text, regardless of whether it appears in", "element tags, attributes, or element content."};
    protected String[] editHelp = new String[]{"", "", "Subtrees can be cut or copied using the right button.", "This produces a small frame containing the subtree.", "It can then be pasted into any editor frame by", "selecting a node and then using one of the \"Insert ...\"", "buttons at the bottom of the little frame.", "", "In some editor frames, \"Cut\" and \"Copy\" are also", "provided by buttons at the bottom of the frame.", "", "Templates representing common object types and", "suitable for copying and pasting can be found on the", "right of the vertical divider."};

    public XMLTreeEditFrame(IXAgent iXAgent) {
        this(iXAgent, iXAgent.getAgentDisplayName() + " XML Tree Editor");
    }

    public XMLTreeEditFrame(IXAgent iXAgent, String string) {
        super(string);
        this.agent = iXAgent;
        if (globalFrameGroup == null) {
            globalFrameGroup = new FrameGroup(string);
        }
        globalFrameGroup.add(this);
        this.frameGroup = globalFrameGroup;
        this.ensureNamespaceManager();
        this.setIconImage(IconImage.getIconImage(this));
        this.setJMenuBar(this.makeMenuBar());
        this.editPanel = this.makeEditPanel();
        this.contentPane.add((Component)this.editPanel, "Center");
        this.pack();
        this.setSize(500, 550);
        this.validate();
        this.editPanel.docSplit.setDividerLocation(0.55);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Debug.noteln("Main frame windowClosing event");
                XMLTreeEditFrame.this.closeFrame();
            }
        });
    }

    public IXAgent getAgent() {
        return this.agent;
    }

    public FrameGroup getFrameGroup() {
        return this.frameGroup;
    }

    protected XMLTreeEditPanel makeEditPanel() {
        return new XMLTreeEditPanel();
    }

    protected void ensureNamespaceManager() {
        if (namespaces == null) {
            namespaces = new XMLTreeNamespaceManager(this.agent.getAgentSymbolName() + " XML Tree Editor Namespaces");
        }
    }

    protected boolean isStandalone() {
        return this.agent instanceof XMLTreeEditor;
    }

    public boolean isEditor() {
        return true;
    }

    public boolean isViewer() {
        return !this.isEditor();
    }

    public void editDocument(Document document) {
        this.editPanel.editDocument(document);
    }

    public Document getDocument() {
        return this.editPanel.getDocument();
    }

    public void editObject(Object object) {
        this.editPanel.editObject(object);
    }

    public Object getObject() {
        return this.editPanel.getObject();
    }

    public void expandDocument(int n) {
        this.editPanel.expandDocument(n);
    }

    protected JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.add(this.makeMenuItem("New Editor Window"));
        if (this.isStandalone() || this.isEditor()) {
            jMenu.add(this.makeMenuItem("Close Editor Window"));
            if (!this.isStandalone()) {
                this.addLookAtMenu(jMenu);
            }
            jMenu.addSeparator();
            jMenu.add(this.makeMenuItem("Load From ..."));
            jMenu.add(this.makeMenuItem("Save As ..."));
            if (this.isStandalone()) {
                jMenu.add(this.makeMenuItem("Send To ..."));
            }
            jMenu.addSeparator();
            jMenu.add(this.makeMenuItem("Reset"));
            if (this.isStandalone()) {
                jMenu.add(this.makeMenuItem("Exit"));
            }
        } else {
            jMenu.add(this.makeMenuItem("Reset"));
            jMenu.add(this.makeMenuItem("Close"));
        }
        JMenu jMenu2 = new JMenu("Edit");
        jMenuBar.add(jMenu2);
        jMenu2.add(this.makeMenuItem("Check As Document"));
        jMenu2.add(this.makeMenuItem("Check As Object"));
        jMenu2.add(this.makeMenuItem("To Object And Back"));
        jMenu2.addSeparator();
        jMenu2.add(this.makeMenuItem("Find In Tree"));
        jMenu2.addSeparator();
        jMenu2.add(this.makeMenuItem("Namespaces"));
        JMenu jMenu3 = new JMenu("View");
        jMenuBar.add(jMenu3);
        jMenu3.add(this.makeMenuItem("As XML"));
        if (this.isStandalone()) {
            toolManager = this.makeToolManager();
            jMenuBar.add(toolManager.getToolsMenu());
        }
        JMenu jMenu4 = new JMenu("Help");
        jMenuBar.add(jMenu4);
        jMenu4.add(this.makeMenuItem("Help"));
        return jMenuBar;
    }

    protected void addLookAtMenu(JMenu jMenu) {
        JMenu jMenu2 = XML.config().makeTreeEditorLookAtMenu(this);
        if (jMenu2 != null) {
            jMenu.add(jMenu2);
        }
    }

    ToolManager makeToolManager() {
        ToolManager toolManager = new ToolManager();
        toolManager.addTool(new ToolController("I-Space"){

            public Object createTool() {
                return new ISpaceTool(XMLTreeEditFrame.this.agent);
            }
        });
        return toolManager;
    }

    public void addTool(ToolController toolController) {
        toolManager.addTool(toolController);
    }

    protected JMenuItem makeMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(CatchingActionListener.listener(this));
        return jMenuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("XMLTreeEditFrame action:", string);
        if (string.equals("New Editor Window")) {
            this.newEditorWindow();
        } else if (string.equals("Close Editor Window")) {
            this.closeFrame();
        } else if (string.equals("Load From ...")) {
            this.loadFrom();
        } else if (string.equals("Save As ...")) {
            this.saveAs();
        } else if (string.equals("Send To ...")) {
            this.sendTo();
        } else if (string.equals("Reset")) {
            this.resetIfUserConfirms();
        } else if (string.equals("Close")) {
            this.closeFrame();
        } else if (string.equals("Exit")) {
            this.exitIfUserConfirms();
        } else if (string.equals("Check As Document")) {
            this.editPanel.getDocument();
        } else if (string.equals("Check As Object")) {
            this.editPanel.getObject();
        } else if (string.equals("To Object And Back")) {
            this.editPanel.editObject(this.editPanel.getObject());
        } else if (string.equals("Find In Tree")) {
            this.findInDocument();
        } else if (string.equals("As XML")) {
            new TextViewFrame(this.editPanel.getDocument());
        } else if (string.equals("Namespaces")) {
            namespaces.setVisible(true);
        } else if (string.equals("Help")) {
            this.showHelp();
        } else {
            throw new ConsistencyException("Nothing to do for " + string);
        }
    }

    protected void reset() {
        this.editPanel.reset();
    }

    protected void resetIfUserConfirms() {
        if (Util.dialogConfirms(null, "Are you sure you want to reset?")) {
            this.reset();
        }
    }

    protected void closeFrame() {
        int n;
        if (this.isStandalone() && (n = this.frameGroup.getNumberVisible()) == 1) {
            this.exitIfUserConfirms();
            return;
        }
        XMLTreeEditPanel.EditorTree editorTree = XMLTreeEditPanel.mostRecentlySelectedTree;
        if (editorTree == this.editPanel.docTree || editorTree == this.editPanel.templateTree) {
            this.editPanel.setSelectedTree(null);
        }
        this.setVisible(false);
    }

    public void exitIfUserConfirms() {
        if (Util.dialogConfirms(null, "Are you sure you want to exit?")) {
            System.exit(0);
        }
    }

    protected void newEditorWindow() {
        String string = this.getBaseTitle() + ", Frame " + (1 + this.frameGroup.getCount());
        XMLTreeEditFrame xMLTreeEditFrame = new XMLTreeEditFrame(this.agent, string);
        xMLTreeEditFrame.setVisible(true);
    }

    protected String getBaseTitle() {
        return this.frameGroup.getTitle();
    }

    protected void loadFrom() {
        Document document = new XMLLoader(this).loadDocument();
        if (document != null) {
            this.editPanel.editDocument(document);
        }
    }

    protected void saveAs() {
        Document document = this.editPanel.getDocument();
        new XMLSaver(this).saveDocument(document);
    }

    protected void findInDocument() {
        if (findFrame == null) {
            findFrame = new FindFrame(this.getBaseTitle() + " Find");
        }
        findFrame.setVisible(true);
    }

    protected void sendTo() {
        if (sendFrame == null) {
            sendFrame = new XMLTreeSendFrame(this, this.getBaseTitle() + " Send");
        }
        sendFrame.setEditFrame(this);
        sendFrame.setVisible(true);
    }

    protected void showHelp() {
        if (this.helpFrame == null) {
            this.helpFrame = new TreeHelpFrame("Tree Editor Help");
            this.helpFrame.setText(this.makeHelpText());
        }
        this.helpFrame.setVisible(true);
    }

    protected String makeHelpText() {
        return Strings.joinLines(this.sharedHelp) + Strings.joinLines(this.editHelp);
    }

    protected static class TreeHelpFrame
    extends TextAreaFrame {
        TreeHelpFrame(String string) {
            super(0, 0, string, new String[]{"Cancel"});
            this.setEditable(false);
        }

        protected void finishFrame() {
            TextAreaFrame.TFrame tFrame = this.frame;
            tFrame.pack();
            tFrame.setSize(375, 400);
            tFrame.validate();
        }

        public void setText(String string) {
            super.setText(string);
            this.setCaretPosition(0);
        }
    }

    class TextViewFrame
    extends TextAreaFrame {
        TextViewFrame(Document document) {
            super(XMLTreeEditFrame.this.getBaseTitle() + " XML View", new String[]{"Cancel"});
            this.setText(XML.documentToXMLString(document));
            this.setVisible(true);
        }

        public void setText(String string) {
            super.setText(string);
            this.setCaretPosition(0);
        }

        public void whenClosed() {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
    }

    protected class FindListener
    implements TextAreaFrame.TListener {
        FindFrame frame;

        FindListener(FindFrame findFrame) {
            this.frame = findFrame;
        }

        public void buttonPressed(String string) {
            if (string.equals("Find")) {
                String string2 = this.frame.getText();
                Debug.noteln("Asking edit panel to find " + Strings.quote(string2));
                XMLTreeEditFrame.this.editPanel.findInTree(string2);
            }
        }
    }

    protected class FindFrame
    extends TextAreaFrame {
        FindFrame(String string) {
            super(0, 0, string, new String[]{"Find", "Cancel"});
            this.addListener(new FindListener(this));
        }

        protected void finishFrame() {
            TextAreaFrame.TFrame tFrame = this.frame;
            tFrame.pack();
            tFrame.setSize(400, 100);
            tFrame.validate();
        }

        public void setText(String string) {
            super.setText(string);
            this.setCaretPosition(0);
        }
    }

    protected static class FrameGroup {
        int count = 0;
        String title;
        Map members = new WeakHashMap();

        FrameGroup(String string) {
            this.title = string;
        }

        String getTitle() {
            return this.title;
        }

        int getCount() {
            return this.count;
        }

        int getNumberVisible() {
            int n = 0;
            for (JFrame jFrame : this.memberSet()) {
                if (!jFrame.isVisible()) continue;
                ++n;
            }
            return n;
        }

        void add(XMLTreeEditFrame xMLTreeEditFrame) {
            ++this.count;
            this.members.put(xMLTreeEditFrame, this);
        }

        Set memberSet() {
            return this.members.keySet();
        }

        public String toString() {
            return "FrameGroup[" + this.title + "]";
        }
    }
}

