/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.util.lisp.Lisp;
import ix.util.reflect.ClassFinder;
import ix.util.reflect.ClassSyntax;
import ix.util.reflect.DashSyntaxClassFinder;
import ix.util.xml.FileSyntaxManager;
import ix.util.xml.XMLTranslator;
import ix.util.xml.XMLTreeEditFrame;
import java.util.List;
import javax.swing.JMenu;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLConfig {
    protected ClassFinder defaultClassFinder;
    protected ClassSyntax defaultClassSyntax;
    protected XMLTranslator defaultXMLTranslator;
    protected FileSyntaxManager defaultFileSyntaxManager;
    protected String homeNameSpaceURI = "http://not_a_real_namespace/";
    protected String SAXDriverClass = "org.apache.xerces.parsers.SAXParser";

    public ClassFinder makeClassFinder() {
        return new DashSyntaxClassFinder();
    }

    public ClassSyntax makeClassSyntax(ClassFinder classFinder) {
        return new ClassSyntax(classFinder);
    }

    public XMLTranslator makeXMLTranslator(ClassSyntax classSyntax) {
        XMLTranslator xMLTranslator = new XMLTranslator(classSyntax);
        xMLTranslator.setOmitImplAttributes(true);
        return xMLTranslator;
    }

    public XMLTranslator makeXMLTranslator() {
        return this.makeXMLTranslator(this.defaultClassSyntax());
    }

    public FileSyntaxManager makeFileSyntaxManager() {
        return new FileSyntaxManager();
    }

    protected void makeDefaultInstances() {
        this.defaultClassFinder = this.makeClassFinder();
        this.defaultClassSyntax = this.makeClassSyntax(this.defaultClassFinder);
        this.defaultXMLTranslator = this.makeXMLTranslator(this.defaultClassSyntax);
        this.defaultFileSyntaxManager = this.makeFileSyntaxManager();
    }

    public ClassFinder defaultClassFinder() {
        if (this.defaultClassFinder == null) {
            this.makeDefaultInstances();
        }
        return this.defaultClassFinder;
    }

    public ClassSyntax defaultClassSyntax() {
        if (this.defaultClassSyntax == null) {
            this.makeDefaultInstances();
        }
        return this.defaultClassSyntax;
    }

    public XMLTranslator defaultXMLTranslator() {
        if (this.defaultXMLTranslator == null) {
            this.makeDefaultInstances();
        }
        return this.defaultXMLTranslator;
    }

    public FileSyntaxManager defaultFileSyntaxManager() {
        if (this.defaultFileSyntaxManager == null) {
            this.makeDefaultInstances();
        }
        return this.defaultFileSyntaxManager;
    }

    public void addImport(String string) {
        this.defaultClassFinder().addImport(string);
    }

    public Namespace getHomeNamespace() {
        return Namespace.getNamespace((String)this.homeNameSpaceURI);
    }

    public void setHomeNamespaceURI(String string) {
        this.homeNameSpaceURI = string;
    }

    public String SAXDriverClass() {
        return this.SAXDriverClass;
    }

    public void setSAXDriverClass(String string) {
        this.SAXDriverClass = string;
    }

    public XMLOutputter makePrettyXMLOutputter() {
        Format format = Format.getPrettyFormat();
        format.setIndent(" ");
        format.setLineSeparator(System.getProperty("line.separator"));
        return new XMLOutputter(format);
    }

    public Class[] treeEditorTemplateClassRoots() {
        return new Class[0];
    }

    public JMenu makeTreeEditorLookAtMenu(XMLTreeEditFrame xMLTreeEditFrame) {
        return null;
    }

    public List xmlSyntaxClasses(ClassSyntax classSyntax, Class clazz) {
        return Lisp.NIL;
    }
}

