/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.ip2.Ip2XMLConfig;
import ix.util.Debug;
import ix.util.SimpleStringBuffer;
import ix.util.Strings;
import ix.util.Util;
import ix.util.xml.FileSyntax;
import ix.util.xml.FileSyntaxManager;
import ix.util.xml.XMLConfig;
import ix.util.xml.XMLException;
import ix.util.xml.XMLTranslator;
import java.io.File;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.XMLReader;

public class XML {
    private static XMLConfig config;
    private static XMLTranslator defaultTranslator;
    public static XMLOutputter prettyXMLOutputter;

    private XML() {
    }

    public static XMLConfig config() {
        return config;
    }

    public static void setConfig(XMLConfig xMLConfig) {
        config = xMLConfig;
        defaultTranslator = xMLConfig.defaultXMLTranslator();
    }

    public static XMLTranslator defaultTranslator() {
        return defaultTranslator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withDefaultTranslator(XMLTranslator xMLTranslator, Runnable runnable) {
        XMLTranslator xMLTranslator2 = defaultTranslator;
        try {
            defaultTranslator = xMLTranslator;
            runnable.run();
        }
        finally {
            defaultTranslator = xMLTranslator2;
        }
    }

    public static Namespace getHomeNamespace() {
        return defaultTranslator.getHomeNamespace();
    }

    public static String nameForClass(Class clazz) {
        return XML.config().defaultClassFinder().nameForClass(clazz);
    }

    public static void addImport(String string) {
        XML.config().addImport(string);
    }

    public static FileSyntaxManager fileSyntaxManager() {
        return XML.config().defaultFileSyntaxManager();
    }

    public static Object objectFromXML(String string) {
        return defaultTranslator.objectFromXML(string);
    }

    public static Object objectFromFile(File file) {
        return XML.objectFromDocument(XML.parseXML(file));
    }

    public static Object readObject(String string) {
        return XML.readObject(Object.class, string);
    }

    public static Object readObject(Class clazz, String string) {
        return XML.fileSyntaxManager().readObject(clazz, string);
    }

    public static Object readObject(Class clazz, URL uRL) {
        return XML.fileSyntaxManager().readObject(clazz, uRL);
    }

    public static Document readDocument(String string) {
        FileSyntaxManager fileSyntaxManager = XML.fileSyntaxManager();
        FileSyntax fileSyntax = fileSyntaxManager.getSyntax(string);
        Debug.noteln("Using syntax", fileSyntax);
        if (fileSyntax == fileSyntaxManager.getSyntaxForType("xml")) {
            URL uRL = fileSyntaxManager.toURL(string);
            if (uRL == null) {
                throw new IllegalArgumentException("Can't find a resource named " + Strings.quote(string));
            }
            return XML.parseXML(uRL);
        }
        Object object = XML.readObject(string);
        return defaultTranslator.objectToDocument(object);
    }

    public static Object objectFromDocument(Document document) {
        return defaultTranslator.objectFromDocument(document);
    }

    public static boolean looksLikeAnObjectDocument(Document document) {
        return defaultTranslator.looksLikeAnObjectDocument(document);
    }

    public static boolean looksLikeAnIXDocument(Document document) {
        return defaultTranslator.looksLikeAnObjectDocument(document);
    }

    public static Object objectFromElement(Element element) {
        return defaultTranslator.objectFromElement(element);
    }

    private static String SAXDriverClass() {
        return XML.config().SAXDriverClass();
    }

    public static Document parseXML(String string) {
        StringReader stringReader = new StringReader(string);
        try {
            XSAXBuilder xSAXBuilder = new XSAXBuilder(XML.SAXDriverClass());
            Document document = xSAXBuilder.build(stringReader);
            return document;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            Debug.noteln("Problematic text:", string);
            throw new XMLException("Can't parse string because " + Debug.describeException(exception));
        }
    }

    public static Document parseXML(File file) {
        Debug.noteln("Parsing XML file " + file + " using", XML.SAXDriverClass());
        try {
            XSAXBuilder xSAXBuilder = new XSAXBuilder(XML.SAXDriverClass());
            Document document = xSAXBuilder.build(file);
            return document;
        }
        catch (JDOMException jDOMException) {
            Debug.noteException(jDOMException);
            throw new XMLException(jDOMException);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new XMLException("Can't parse " + file + " because " + Debug.describeException(exception));
        }
    }

    public static Document parseXML(URL uRL) {
        Debug.noteln("Parsing XML URL " + uRL + " using", XML.SAXDriverClass());
        try {
            XSAXBuilder xSAXBuilder = new XSAXBuilder(XML.SAXDriverClass());
            Document document = xSAXBuilder.build(uRL);
            return document;
        }
        catch (JDOMException jDOMException) {
            Debug.noteException(jDOMException);
            throw new XMLException(jDOMException);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new XMLException("Can't parse " + uRL + " because " + Debug.describeException(exception));
        }
    }

    public static URL toURL(String string) {
        return XML.fileSyntaxManager().toURL(string);
    }

    public static String objectToXMLString(Object object) {
        return defaultTranslator.objectToXMLString(object);
    }

    public static String documentToXMLString(Document document) {
        return defaultTranslator.documentToXMLString(document);
    }

    public static Document objectToDocument(Object object) {
        return defaultTranslator.objectToDocument(object);
    }

    public static void writeObject(Object object, String string) {
        XML.fileSyntaxManager().writeObject(object, string);
    }

    public static XMLOutputter makePrettyXMLOutputter() {
        return XML.config().makePrettyXMLOutputter();
    }

    public static void printXMLWithWhitespace(Document document, int n) {
        String string = defaultTranslator.documentToXMLString(document);
        XML.printXMLWithWhitespace(string, n);
    }

    public static void printXMLWithWhitespace(String string, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Can't indent " + n);
        }
        List list = Strings.breakIntoLines(string);
        int n2 = 0;
        for (String string2 : list) {
            int n3 = string2.indexOf("<");
            if (n3 < 0) {
                n3 = 2;
            }
            if (n2 <= 1 && n3 == 1 || n2 == 1 && n3 < 1) {
                System.out.println("");
            }
            int n4 = n3;
            int n5 = n4 * n;
            String string3 = Strings.repeat(n5 - n3, " ");
            System.out.println(string3 + string2);
            n2 = n3;
        }
    }

    public static void setAttributes(Element element, String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i][0];
            String string2 = stringArray[i][1];
            element.setAttribute(string, string2);
        }
    }

    public static String encodeText(String string) {
        return XML.encodeForXML(string, false);
    }

    public static String decodeText(String string) {
        return XML.decodeForXML(string);
    }

    public static String encodeAttribute(String string) {
        return XML.encodeForXML(string, true);
    }

    public static String decodeAttribute(String string) {
        return XML.decodeForXML(string);
    }

    private static String encodeForXML(String string, boolean bl) {
        String string2 = bl ? "&<>\"" : "&<>";
        int n = Strings.indexOfAny(string2, string);
        if (n < 0) {
            return string;
        }
        int n2 = 0;
        while (n >= 0) {
            n2 += XML.charEncoding(string.charAt(n)).length() - 1;
            n = Strings.indexOfAny(string2, n + 1, string);
        }
        int n3 = string.length();
        SimpleStringBuffer simpleStringBuffer = new SimpleStringBuffer(n3 + n2);
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) >= 0) {
                simpleStringBuffer.append(XML.charEncoding(c));
                continue;
            }
            simpleStringBuffer.append(c);
        }
        Debug.expect(simpleStringBuffer.length() == n3 + n2);
        return simpleStringBuffer.toString();
    }

    private static String charEncoding(char c) {
        switch ("&<>\"".indexOf(c)) {
            case 0: {
                return "&amp;";
            }
            case 1: {
                return "&lt;";
            }
            case 2: {
                return "&gt;";
            }
            case 3: {
                return "&quot;";
            }
        }
        throw new RuntimeException("No encoding for " + String.valueOf(c));
    }

    private static String decodeForXML(String string) {
        if (string.indexOf(38) < 0) {
            return string;
        }
        int n = 0;
        int n2 = string.length();
        SimpleStringBuffer simpleStringBuffer = new SimpleStringBuffer(n2);
        while (n < n2) {
            String string2;
            char c;
            char c2 = string.charAt(n);
            if (c2 != '&') {
                simpleStringBuffer.append(c2);
                ++n;
                continue;
            }
            char c3 = string.charAt(n + 1);
            if (c3 == 'a') {
                c = '&';
                string2 = "&amp;";
            } else if (c3 == 'l') {
                c = '<';
                string2 = "&lt;";
            } else if (c3 == 'g') {
                c = '>';
                string2 = "&gt;";
            } else if (c3 == 'q') {
                c = '\"';
                string2 = "&quot;";
            } else {
                throw new RuntimeException("Cannot decode " + string);
            }
            Debug.expect(string.charAt(n + string2.length() - 1) == ';');
            simpleStringBuffer.append(c);
            n += string2.length();
        }
        return simpleStringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string;
        while (!(string = Util.askLine("Text:")).equals("bye")) {
            String string2 = XML.encodeAttribute(string);
            Debug.noteln("Encode:", string2);
            Debug.noteln("Decode:", XML.decodeAttribute(string2));
        }
        return;
    }

    static {
        XML.setConfig(new Ip2XMLConfig());
        prettyXMLOutputter = XML.makePrettyXMLOutputter();
    }

    public static class XSAXBuilder
    extends SAXBuilder {
        public XSAXBuilder() {
        }

        public XSAXBuilder(boolean bl) {
            super(bl);
        }

        public XSAXBuilder(String string) {
            super(string);
        }

        public XSAXBuilder(String string, boolean bl) {
            super(string, bl);
        }

        protected XMLReader createParser() throws JDOMException {
            String string = this.getDriverClass();
            XMLReader xMLReader = super.createParser();
            return xMLReader;
        }
    }
}

