/*
 * Decompiled with CFR 0.152.
 */
package ix.util.owls;

import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.domain.VariableDeclaration;
import ix.iface.domain.LTF_Writer;
import ix.iplan.ServiceSymbols;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.LCNameMapper;
import ix.util.NameMapper;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.StableHashMap;
import ix.util.lisp.Cons;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.owls.ServiceReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.mindswap.owl.OWLResource;
import org.mindswap.owls.process.InputList;
import org.mindswap.owls.process.OutputList;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.ParameterList;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.service.Service;

public class ServiceTranslator
implements ServiceSymbols {
    StableHashMap idToService = new StableHashMap();
    NameMapper nameMap = new LCNameMapper();
    List translatedServices = new LinkedList();
    Symbol S_TO = Symbol.intern("to");
    Symbol S_TYPE = Symbol.intern("type");
    Symbol S_NAME_MAP = Symbol.intern("name-map");
    int VAR = 0;
    int TYPE = 1;

    public NameMapper getNameMapper() {
        return this.nameMap;
    }

    public Collection getTranslatedServices() {
        return this.idToService.values();
    }

    public Service getServiceForRefinement(Refinement refinement) {
        String string = this.nameMap.longName(refinement.getName().toString());
        Service service = (Service)this.idToService.get(string);
        if (service != null) {
            return service;
        }
        throw new IllegalArgumentException("Can't find a service for " + refinement);
    }

    public Domain readServiceDomain(String string) {
        return this.serviceListToDomain(this.readServiceList(string));
    }

    public Domain serviceListToDomain(List list) {
        Domain domain = new Domain();
        for (Service service : list) {
            domain.addRefinement(this.serviceToRefinement(service));
        }
        domain.setAnnotation(this.S_NAME_MAP, this.nameMap.getShortToLongMap());
        return domain;
    }

    public List readServiceList(String string) {
        URI uRI = this.makeURI(string);
        ServiceReader serviceReader = new ServiceReader();
        List list = serviceReader.readAll(uRI);
        return list;
    }

    public URI makeURI(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RethrownException(uRISyntaxException);
        }
    }

    public Refinement serviceToRefinement(Service service) {
        Debug.noteln("- - - Service to translate - - -");
        Debug.noteln("Service", service);
        Debug.noteln("File URI", service.getFileURI());
        Debug.noteln("OWL-S version", service.getOWLSVersion());
        Debug.noteln("Service URI", service.getURI());
        Refinement refinement = new Refinement();
        String string = this.nameMap.mapLongName(service.getURI());
        refinement.setName(string);
        refinement.setPattern(Lisp.list(string));
        Process process = service.getProcess();
        InputList inputList = process.getInputs();
        OutputList outputList = process.getOutputs();
        LList lList = this.makeParameterPairs((ParameterList)inputList);
        LList lList2 = this.makeParameterPairs((ParameterList)outputList);
        Cons cons = new Cons(Symbol.intern(string), lList.mapNth(this.VAR).append(new Cons(this.S_TO, lList2.mapNth(this.VAR))));
        refinement.setPattern(cons);
        refinement.setVariableDeclarations(this.makeVariableDeclarations(lList).append(this.makeVariableDeclarations(lList2)));
        refinement.setAnnotation(S_INPUT_OBJECTS, lList);
        refinement.setAnnotation(S_OUTPUT_OBJECTS, lList2);
        refinement.setAnnotation(S_OWL_S_PROCESS, service.getProcess().getURI().toString());
        refinement.setConstraints(this.makeConstraints("condition", lList).append(this.makeConstraints("effect", lList2)));
        return refinement;
    }

    LList makeParameterPairs(ParameterList parameterList) {
        LListCollector lListCollector = new LListCollector();
        for (Parameter parameter : parameterList) {
            OWLResource oWLResource = parameter.getType();
            String string = this.nameMap.mapLongName(parameter.getURI());
            String string2 = this.nameMap.mapLongName(oWLResource.getURI());
            lListCollector.add(Lisp.list(Symbol.intern("?" + string), Symbol.intern(string2)));
        }
        return lListCollector.contents();
    }

    LList makeVariableDeclarations(LList lList) {
        return lList.mapcar(new Function1(){

            public Object funcall(Object object) {
                LList lList = (LList)object;
                ItemVar itemVar = (ItemVar)lList.get(ServiceTranslator.this.VAR);
                return new VariableDeclaration(itemVar);
            }
        });
    }

    LList makeConstraints(final String string, LList lList) {
        return lList.mapcar(new Function1(){

            public Object funcall(Object object) {
                LList lList = (LList)object;
                ItemVar itemVar = (ItemVar)lList.get(ServiceTranslator.this.VAR);
                Symbol symbol = (Symbol)lList.get(ServiceTranslator.this.TYPE);
                return ServiceTranslator.this.makeConstraint(string, itemVar, symbol);
            }
        });
    }

    Constraint makeConstraint(String string, ItemVar itemVar, Symbol symbol) {
        return new Constraint("world-state", string, (List)Lisp.list(new PatternAssignment(Lisp.list(this.S_TYPE, itemVar), symbol)));
    }

    public static void main(String[] stringArray) throws Exception {
        Parameters.processCommandLineArguments(stringArray);
        ServiceTranslator serviceTranslator = new ServiceTranslator();
        if (Parameters.haveParameter("service")) {
            String string = Parameters.getParameter("service");
            URI uRI = new URI(string);
            ServiceReader serviceReader = new ServiceReader();
            Service service = serviceReader.read(uRI);
            Refinement refinement = serviceTranslator.serviceToRefinement(service);
            LTF_Writer lTF_Writer = new LTF_Writer();
            lTF_Writer.writeRefinement(refinement, new OutputStreamWriter(System.out));
        } else if (Parameters.haveParameter("service-list")) {
            String string = Parameters.getParameter("service-list");
            Domain domain = serviceTranslator.readServiceDomain(string);
            LTF_Writer lTF_Writer = new LTF_Writer();
            lTF_Writer.writeDomain(domain, new OutputStreamWriter(System.out));
        } else {
            throw new UnsupportedOperationException("No recognizable command");
        }
    }
}

