/*
 * Decompiled with CFR 0.152.
 */
package ix.util.owls;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import ix.util.Debug;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mindswap.owl.Util;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.MessageMapList;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.io.impl.OWLSReaderImpl;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.ConditionList;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.DataFlow;
import org.mindswap.owls.process.DataFlowElement;
import org.mindswap.owls.process.Effect;
import org.mindswap.owls.process.EffectList;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.ProcessComponent;
import org.mindswap.owls.process.ProcessComponentList;
import org.mindswap.owls.process.ProcessModel;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.Unordered;
import org.mindswap.owls.process.ValueMap;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.jena.FLAServiceOnt;
import org.mindswap.owls.vocabulary.jena.OWLS_1_0;

public class ServiceReader
extends OWLSReaderImpl {
    public static boolean DEBUG = false;
    private Property OWLS_1_0_Process_theParameter = ResourceFactory.createProperty((String)"http://www.daml.org/services/owl-s/1.0/Process.owl#theParameter");
    private Property OWLS_1_0_Process_atProcess = ResourceFactory.createProperty((String)"http://www.daml.org/services/owl-s/1.0/Process.owl#atProcess");

    public ServiceReader() {
        this.version = "1.0";
    }

    protected List createService(URI uRI, Model model) {
        StmtIterator stmtIterator = model.listStatements(null, RDF.type, (RDFNode)OWLS_1_0.Service.Service);
        ArrayList<Service> arrayList = new ArrayList<Service>();
        while (stmtIterator.hasNext()) {
            Resource resource = stmtIterator.nextStatement().getSubject();
            try {
                this.startService(resource.toString());
                Resource resource2 = resource.getProperty(OWLS_1_0.Service.presents).getResource();
                Resource resource3 = resource.getProperty(OWLS_1_0.Service.describedBy).getResource();
                Service service = OWLSFactory.createService((Resource)resource);
                service.setFileURI(uRI);
                service.setOWLSVersion(this.version);
                this.createProcessModel(service, resource3);
                this.createProfile(service, resource2);
                if (!this.errorOccurred) {
                    arrayList.add(service);
                }
                this.finishService(resource.toString());
            }
            catch (Exception exception) {
                this.error("Invalid service description " + resource);
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    private void createProcessModel(Service service, Resource resource) {
        Resource resource2 = resource.getProperty(OWLS_1_0.Process.hasProcess).getResource();
        ProcessModel processModel = OWLSFactory.createProcessModel((Resource)resource);
        Process process = this.createProcess(service, resource2);
        processModel.setProcess(process);
        processModel.setService(service);
    }

    private boolean isProcess(Resource resource) {
        return resource.hasProperty(RDF.type, (RDFNode)OWLS_1_0.Process.AtomicProcess) || resource.hasProperty(RDF.type, (RDFNode)OWLS_1_0.Process.CompositeProcess) || resource.hasProperty(RDF.type, (RDFNode)OWLS_1_0.Process.SimpleProcess);
    }

    private Process createProcess(Service service, Resource resource) {
        if (!this.isProcess(resource)) {
            throw new RuntimeException("The process is neither atomic nor composite: " + resource.getURI());
        }
        AtomicProcess atomicProcess = null;
        if (resource.hasProperty(RDF.type, (RDFNode)OWLS_1_0.Process.AtomicProcess)) {
            atomicProcess = this.createAtomicProcess(service, resource);
        }
        if (resource.hasProperty(RDF.type, (RDFNode)OWLS_1_0.Process.CompositeProcess)) {
            atomicProcess = this.createCompositeProcess(service, resource);
        }
        if (atomicProcess == null) {
            return null;
        }
        this.createProcessParams((Process)atomicProcess, true, resource);
        this.createProcessParams((Process)atomicProcess, false, resource);
        this.createConditions(atomicProcess.getPreconditions(), resource.listProperties(OWLS_1_0.Profile.hasPrecondition));
        this.createEffects(atomicProcess.getEffects(), resource.listProperties(OWLS_1_0.Profile.hasEffect));
        this.createDefaultValues(atomicProcess.getDefaultValues(), resource);
        this.createDataFlow((Process)atomicProcess, resource);
        atomicProcess.setService(service);
        return atomicProcess;
    }

    private AtomicProcess createAtomicProcess(Service service, Resource resource) {
        AtomicProcess atomicProcess = OWLSFactory.createAtomicProcess((Resource)resource);
        return atomicProcess;
    }

    private CompositeProcess createCompositeProcess(Service service, Resource resource) {
        Statement statement = resource.getProperty(OWLS_1_0.Process.composedOf);
        if (statement == null) {
            this.error("Cannot find the components for composite process \n      process " + resource);
            return null;
        }
        Resource resource2 = statement.getResource();
        ControlConstruct controlConstruct = this.createControlConstruct(service, resource2);
        CompositeProcess compositeProcess = OWLSFactory.createCompositeProcess((Resource)resource);
        compositeProcess.setComposedOf(controlConstruct);
        return compositeProcess;
    }

    private ProcessComponent createProcessComponent(Service service, Resource resource) {
        Object object = null;
        object = this.isProcess(resource) ? this.createProcess(service, resource) : this.createControlConstruct(service, resource);
        return object;
    }

    private ControlConstruct createControlConstruct(Service service, Resource resource) {
        Resource resource2 = resource.getProperty(RDF.type).getResource();
        Resource resource3 = resource.getProperty(OWLS_1_0.Process.components).getResource();
        Sequence sequence = null;
        if (resource2.equals(OWLS_1_0.Process.Sequence)) {
            sequence = this.createSequence(service, resource3);
        } else if (resource2.equals(OWLS_1_0.Process.Choice)) {
            sequence = this.createChoice(service, resource3);
        } else if (resource2.equals(OWLS_1_0.Process.Unordered)) {
            sequence = this.createUnordered(service, resource3);
        } else {
            this.error("Don't know how to read the control construct " + resource2);
        }
        return sequence;
    }

    private Sequence createSequence(Service service, Resource resource) {
        Sequence sequence = OWLSFactory.createSequence((Resource)resource);
        this.createComponents(service, (ControlConstruct)sequence, resource);
        return sequence;
    }

    private Unordered createUnordered(Service service, Resource resource) {
        Unordered unordered = OWLSFactory.createUnordered((Resource)resource);
        this.createComponents(service, (ControlConstruct)unordered, resource);
        return unordered;
    }

    private Choice createChoice(Service service, Resource resource) {
        Choice choice = OWLSFactory.createChoice((Resource)resource);
        this.createComponents(service, (ControlConstruct)choice, resource);
        return choice;
    }

    private void createComponents(Service service, ControlConstruct controlConstruct, Resource resource) {
        List list = Util.createList((Resource)resource);
        for (int i = 0; i < list.size(); ++i) {
            Resource resource2 = (Resource)list.get(i);
            ProcessComponent processComponent = this.createProcessComponent(service, resource2);
            if (processComponent == null) {
                this.error("Invalid ProcessComponent description " + resource2);
                continue;
            }
            controlConstruct.getComponents().add((Object)processComponent);
        }
    }

    private void createDefaultValues(ValueMap valueMap, Resource resource) {
    }

    private void createDataFlow(Process process, Resource resource) {
        try {
            DataFlow dataFlow = process.getDataFlow();
            StmtIterator stmtIterator = resource.listProperties(OWLS_1_0.Process.sameValues);
            while (stmtIterator.hasNext()) {
                Resource resource2 = stmtIterator.nextStatement().getResource();
                Resource resource3 = resource2.getProperty(RDF.first).getResource();
                Resource resource4 = resource2.getProperty(RDF.rest).getResource().getProperty(RDF.first).getResource();
                Statement statement = resource3.getProperty(this.OWLS_1_0_Process_theParameter);
                Resource resource5 = statement.getObject() instanceof Resource ? statement.getResource() : Util.toResource((String)statement.getObject().toString());
                statement = resource3.getProperty(this.OWLS_1_0_Process_atProcess);
                Resource resource6 = statement.getObject() instanceof Resource ? statement.getResource() : Util.toResource((String)statement.getObject().toString());
                statement = resource4.getProperty(this.OWLS_1_0_Process_theParameter);
                Resource resource7 = statement.getObject() instanceof Resource ? statement.getResource() : Util.toResource((String)statement.getObject().toString());
                statement = resource4.getProperty(this.OWLS_1_0_Process_atProcess);
                Resource resource8 = statement.getObject() instanceof Resource ? statement.getResource() : Util.toResource((String)statement.getObject().toString());
                Process process2 = this.findProcess((ProcessComponent)process, Util.toURI((Resource)resource6));
                Process process3 = this.findProcess((ProcessComponent)process, Util.toURI((Resource)resource8));
                Parameter parameter = null;
                Parameter parameter2 = null;
                if (process2 == null) {
                    this.error("Cannot find the process data flow refers to \n      process " + resource6 + "\n    parameter " + resource5 + "\n data flow in " + process.getURI());
                } else {
                    parameter = process2.getParameter(Util.toURI((Resource)resource5));
                    if (parameter == null) {
                        this.error("Cannot find the parameter data flow refers to \n      process " + resource6 + "\n    parameter " + resource5 + "\n data flow in " + process.getURI());
                    }
                }
                if (process3 == null) {
                    this.error("Cannot find the process data flow refers to \n      process " + resource8 + "\n    parameter " + resource7 + "\n data flow in " + process.getURI());
                } else {
                    parameter2 = process3.getParameter(Util.toURI((Resource)resource7));
                    if (parameter2 == null) {
                        this.error("Cannot find the parameter data flow refers to \n      process " + resource8 + "\n    parameter " + resource7 + "\n data flow in " + process.getURI());
                    }
                }
                if (parameter == null || parameter2 == null) continue;
                DataFlowElement dataFlowElement = OWLSFactory.createDataFlowElement();
                dataFlowElement.add((Object)parameter);
                dataFlowElement.add((Object)parameter2);
                dataFlow.add((Object)dataFlowElement);
            }
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            this.error("Invalid data flow specification");
        }
    }

    private void createProcessParams(Process process, boolean bl, Resource resource) {
        Property property = bl ? OWLS_1_0.Process.hasInput : OWLS_1_0.Process.hasOutput;
        StmtIterator stmtIterator = resource.listProperties(property);
        while (stmtIterator.hasNext()) {
            Resource resource2 = stmtIterator.nextStatement().getResource();
            Input input = null;
            if (bl) {
                input = OWLSFactory.createInput((Resource)resource2);
                process.getInputs().add((Object)input);
            } else {
                input = OWLSFactory.createOutput((Resource)resource2);
                process.getOutputs().add((Object)input);
            }
            input.setProcess(process);
            if (resource2.hasProperty(OWLS_1_0.Process.parameterType)) {
                input.setType(OWLSFactory.createOWLResource((Resource)resource2.getProperty(OWLS_1_0.Process.parameterType).getResource()));
            } else {
                this.error("Cannot find the type for the process parameter \n      process " + process + "\n    parameter " + input);
            }
            if (!DEBUG) continue;
            System.out.println("  Process   " + process.getURI() + "\n" + (bl ? "  Input     " : "  Output    ") + input.getLabel() + "\n" + "  Type      " + input.getType() + "\n");
        }
    }

    private void createProfile(Service service, Resource resource) {
        try {
            Profile profile = OWLSFactory.createProfile((Resource)resource);
            Process process = service.getProcess();
            this.createProfileParams(profile, process, true, resource);
            this.createProfileParams(profile, process, false, resource);
            this.createConditions(profile.getPreconditions(), resource.listProperties(OWLS_1_0.Profile.hasPrecondition));
            this.createEffects(profile.getEffects(), resource.listProperties(OWLS_1_0.Profile.hasEffect));
            profile.setType(Util.toURI((Resource)resource.getProperty(RDF.type).getResource()));
            this.copyPropertyValues(resource, OWLS_1_0.Profile.serviceName, RDFS.label);
            profile.setService(service);
        }
        catch (RuntimeException runtimeException) {
            this.error("Invalid profile description");
            runtimeException.printStackTrace();
        }
    }

    private void createProfileParams(Profile profile, Process process, boolean bl, Resource resource) {
        Property property = bl ? OWLS_1_0.Profile.hasInput : OWLS_1_0.Profile.hasOutput;
        StmtIterator stmtIterator = resource.getModel().listStatements(resource, property, (RDFNode)((Resource)null));
        while (stmtIterator.hasNext()) {
            Resource resource2 = (Resource)stmtIterator.nextStatement().getObject();
            String string = resource2.getURI();
            Parameter parameter = process.getParameter(URI.create(string));
            if (parameter == null) {
                this.error("The parameter defined in profile does not exist in the process \n    parameter " + string + "\n   in profile " + profile.getURI() + "\n      process " + process.getURI());
                continue;
            }
            if (bl) {
                profile.getInputs().add((Object)parameter);
            } else {
                profile.getOutputs().add((Object)parameter);
            }
            if (!DEBUG) continue;
            System.out.println("  Profile   " + profile.getURI() + "\n" + (bl ? "  Input     " : "  Output    ") + string + "\n" + "  Refers to " + parameter + "\n");
        }
    }

    private void createConditions(ConditionList conditionList, StmtIterator stmtIterator) {
        while (stmtIterator.hasNext()) {
            Resource resource = (Resource)stmtIterator.nextStatement().getObject();
            conditionList.add((Object)this.createCondition(resource));
        }
    }

    private void createEffects(EffectList effectList, StmtIterator stmtIterator) {
        while (stmtIterator.hasNext()) {
            Resource resource = (Resource)stmtIterator.nextStatement().getObject();
            effectList.add((Object)this.createEffect(resource));
        }
    }

    private Condition createCondition(Resource resource) {
        Condition condition = OWLSFactory.createCondition((Resource)resource);
        return condition;
    }

    private Effect createEffect(Resource resource) {
        Effect effect = OWLSFactory.createEffect((Resource)resource);
        return effect;
    }

    private void createGrounding(Service service, Resource resource) {
        AtomicGrounding atomicGrounding;
        Resource resource2;
        Grounding grounding = OWLSFactory.createGrounding((Resource)resource);
        StmtIterator stmtIterator = resource.listProperties(OWLS_1_0.Grounding.hasAtomicProcessGrounding);
        while (stmtIterator.hasNext()) {
            resource2 = stmtIterator.nextStatement().getResource();
            atomicGrounding = this.createAPGrounding(service, resource2);
            if (atomicGrounding != null) {
                grounding.addGrounding(atomicGrounding);
                continue;
            }
            this.error("Invalid AtomicProcess grounding " + resource2);
        }
        stmtIterator = resource.listProperties(FLAServiceOnt.hasUPnPAtomicProcessGrounding);
        while (stmtIterator.hasNext()) {
            resource2 = stmtIterator.nextStatement().getResource();
            atomicGrounding = this.createAPGrounding(service, resource2);
            if (atomicGrounding != null) {
                grounding.addGrounding(atomicGrounding);
                continue;
            }
            this.error("Invalid AtomicProcess grounding " + resource2);
        }
        grounding.setService(service);
    }

    private AtomicGrounding createAPGrounding(Service service, Resource resource) {
        try {
            if (resource.hasProperty(RDF.type, (RDFNode)OWLS_1_0.Grounding.WsdlAtomicProcessGrounding)) {
                return this.createWSDLGrounding(service, resource);
            }
            if (resource.hasProperty(RDF.type, (RDFNode)FLAServiceOnt.UPnPAtomicProcessGrounding)) {
                return this.createUPnPGrounding(service, resource);
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        return null;
    }

    private AtomicGrounding createWSDLGrounding(Service service, Resource resource) {
        URI uRI = Util.toURI((Resource)resource.getProperty(OWLS_1_0.Grounding.damlsProcess).getResource());
        Resource resource2 = resource.getProperty(OWLS_1_0.Grounding.wsdlOperation).getResource();
        String string = resource.getProperty(OWLS_1_0.Grounding.wsdlDocument).getObject().toString();
        String string2 = resource2.getProperty(OWLS_1_0.Grounding.operation).getObject().toString();
        String string3 = resource2.getProperty(OWLS_1_0.Grounding.portType).getObject().toString();
        AtomicProcess atomicProcess = (AtomicProcess)this.findProcess((ProcessComponent)service.getProcess(), uRI);
        if (atomicProcess == null) {
            this.error("The process specified in the grounding cannot be found \n    grounding " + resource + "\n      process " + uRI);
            return null;
        }
        WSDLAtomicGrounding wSDLAtomicGrounding = OWLSFactory.createWSDLAtomicGrounding((Resource)resource);
        wSDLAtomicGrounding.setProcess(atomicProcess);
        wSDLAtomicGrounding.setWSDL(string);
        wSDLAtomicGrounding.setOperation(string2);
        wSDLAtomicGrounding.setPortType(string3);
        if (resource.hasProperty(OWLS_1_0.Grounding.wsdlInputMessage)) {
            wSDLAtomicGrounding.setInputMessage(resource.getProperty(OWLS_1_0.Grounding.wsdlInputMessage).getObject().toString());
        }
        if (resource.hasProperty(OWLS_1_0.Grounding.wsdlOutputMessage)) {
            wSDLAtomicGrounding.setOutputMessage(resource.getProperty(OWLS_1_0.Grounding.wsdlOutputMessage).getObject().toString());
        }
        this.createMessageMapList((AtomicGrounding)wSDLAtomicGrounding, resource, true);
        this.createMessageMapList((AtomicGrounding)wSDLAtomicGrounding, resource, false);
        if (DEBUG) {
            System.out.println("  Process   " + atomicProcess.getURI() + "\n" + "  WSDL file " + string + "\n" + "  Operation " + string2 + "\n");
        }
        return wSDLAtomicGrounding;
    }

    private AtomicGrounding createUPnPGrounding(Service service, Resource resource) {
        URI uRI = Util.toURI((Resource)resource.getProperty(OWLS_1_0.Grounding.damlsProcess).getResource());
        String string = resource.getProperty(FLAServiceOnt.upnpDeviceURL).getObject().toString();
        String string2 = resource.getProperty(FLAServiceOnt.upnpServiceID).getObject().toString();
        String string3 = resource.getProperty(FLAServiceOnt.upnpCommand).getObject().toString();
        AtomicProcess atomicProcess = (AtomicProcess)this.findProcess((ProcessComponent)service.getProcess(), uRI);
        UPnPAtomicGrounding uPnPAtomicGrounding = OWLSFactory.createUPnPAtomicGrounding((Resource)resource);
        uPnPAtomicGrounding.setProcess(atomicProcess);
        uPnPAtomicGrounding.setUPnPDescription(string);
        uPnPAtomicGrounding.setUPnPService(string2);
        uPnPAtomicGrounding.setUPnPAction(string3);
        this.createMessageMapList((AtomicGrounding)uPnPAtomicGrounding, resource, true);
        this.createMessageMapList((AtomicGrounding)uPnPAtomicGrounding, resource, false);
        if (DEBUG) {
            System.out.println("  Process " + atomicProcess.getURI() + "\n" + "  Device  " + string + "\n" + "  Service " + string2 + "\n" + "  Action  " + string3 + "\n");
        }
        return uPnPAtomicGrounding;
    }

    private void createMessageMapList(AtomicGrounding atomicGrounding, Resource resource, boolean bl) {
        AtomicProcess atomicProcess = atomicGrounding.getProcess();
        Property property = null;
        Property property2 = null;
        if (atomicGrounding instanceof UPnPAtomicGrounding) {
            property = bl ? FLAServiceOnt.UPnPInputMapping : FLAServiceOnt.UPnPOutputMapping;
            property2 = FLAServiceOnt.upnpParameter;
        } else if (atomicGrounding instanceof WSDLAtomicGrounding) {
            property = bl ? OWLS_1_0.Grounding.wsdlInputMessageParts : OWLS_1_0.Grounding.wsdlOutputMessageParts;
            property2 = OWLS_1_0.Grounding.wsdlMessagePart;
        }
        if (!resource.hasProperty(property)) {
            return;
        }
        Resource resource2 = (Resource)resource.getProperty(property).getObject();
        List list = Util.createList((Resource)resource2);
        MessageMapList messageMapList = bl ? atomicGrounding.getInputMap() : atomicGrounding.getOutputMap();
        for (int i = 0; i < list.size(); ++i) {
            Resource resource3 = (Resource)list.get(i);
            MessageMap messageMap = OWLSFactory.createMessageMap((Resource)resource3);
            URI uRI = Util.toURI((Resource)resource3.getProperty(OWLS_1_0.Grounding.damlsParameter).getResource());
            Parameter parameter = bl ? atomicProcess.getInputs().getParameter(uRI) : atomicProcess.getOutputs().getParameter(uRI);
            messageMap.setOWLSParameter(parameter);
            String string = resource3.getProperty(property2).getObject().toString();
            messageMap.setGroundingParameter(string);
            String string2 = null;
            if (resource3.hasProperty(OWLS_1_0.Grounding.xsltTranformation)) {
                string2 = resource3.getProperty(OWLS_1_0.Grounding.xsltTranformation).getString();
                messageMap.setTransformation(string2);
            }
            if (parameter == null) {
                this.error("Cannot find the target of message map for \n   wsdl parameter " + string + "\n       in process " + atomicProcess.getURI() + "\n        mapped to " + uRI);
            }
            if (DEBUG) {
                System.out.println("  Process   " + atomicProcess.getURI() + "\n" + "  Param     " + uRI + "\n" + "  Grounding " + string + "\n" + "  Transform " + string2 + "\n");
            }
            messageMapList.add((Object)messageMap);
        }
    }

    private Process findProcess(ProcessComponent processComponent, URI uRI) {
        if (processComponent == null) {
            return null;
        }
        if (processComponent.getURI() != null && processComponent.getURI().equals(uRI)) {
            if (processComponent instanceof Process) {
                return (Process)processComponent;
            }
        } else {
            if (processComponent instanceof CompositeProcess) {
                return this.findProcess((ProcessComponent)((CompositeProcess)processComponent).getComposedOf(), uRI);
            }
            if (processComponent instanceof ControlConstruct) {
                ProcessComponentList processComponentList = ((ControlConstruct)processComponent).getComponents();
                for (int i = 0; i < processComponentList.size(); ++i) {
                    ProcessComponent processComponent2 = processComponentList.processComponentAt(i);
                    Process process = this.findProcess(processComponent2, uRI);
                    if (process == null) continue;
                    return process;
                }
            }
        }
        return null;
    }

    private void copyPropertyValues(Resource resource, Property property, Property property2) {
        ArrayList<RDFNode> arrayList = new ArrayList<RDFNode>();
        StmtIterator stmtIterator = resource.listProperties(property);
        while (stmtIterator.hasNext()) {
            arrayList.add(stmtIterator.nextStatement().getObject());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            resource.addProperty(property2, (RDFNode)iterator.next());
        }
    }
}

