/*
 * Decompiled with CFR 0.152.
 */
package ix.util.match;

import ix.icore.Variable;
import ix.util.Collect;
import ix.util.Fn;
import ix.util.match.MatchChoice;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Bindings {
    Map map;

    public Bindings(Map map) {
        this.map = map;
    }

    public static List mapsToBindings(List list) {
        LinkedList<Bindings> linkedList = new LinkedList<Bindings>();
        for (Map map : list) {
            if (!Collect.every(map.keySet(), Fn.isInstanceOf(Variable.class))) {
                throw new IllegalArgumentException("Map has a key that isn't a Variable: " + map);
            }
            linkedList.add(new Bindings(map));
        }
        return linkedList;
    }

    public static List bindingsToMaps(List list) {
        LinkedList<Map> linkedList = new LinkedList<Map>();
        for (Bindings bindings : list) {
            linkedList.add(bindings.map);
        }
        return linkedList;
    }

    public Set getVariables() {
        return this.map.keySet();
    }

    public Object valueOf(Variable variable) {
        return this.map.get(variable);
    }

    public boolean isConsistentWith(Bindings bindings) {
        return Collect.areConsistent(this.map, bindings.map);
    }

    public boolean isConsistentWith(MatchChoice matchChoice) {
        List list = matchChoice.getLiveBranches();
        if (list.isEmpty()) {
            return !Collect.haveCommonElements(this.getVariables(), matchChoice.getVariables());
        }
        for (Bindings bindings : list) {
            if (!Collect.areConsistent(this.map, bindings.map)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Bindings" + this.map.toString();
    }
}

