/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.util.Debug;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.LispReadException;
import ix.util.lisp.LispStreamTokenizer;
import ix.util.lisp.LispTokenizer;
import ix.util.lisp.Symbol;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;

public class LispReader {
    private static final Symbol QUOTE = Symbol.intern("quote");
    protected LispTokenizer tk;
    protected InputStream inStream;
    protected Reader inReader;
    protected boolean singleQuoteIsMacro = false;
    private static final Object CLOSE = new Object();

    public LispReader(LispTokenizer lispTokenizer) {
        this.tk = lispTokenizer;
    }

    public LispReader(InputStream inputStream) {
        this.tk = new LispStreamTokenizer(inputStream);
        this.inStream = inputStream;
    }

    public LispReader(Reader reader) {
        this.tk = new LispStreamTokenizer(reader);
        this.inReader = reader;
    }

    public LispReader(String string) {
        this.inStream = new StringBufferInputStream(string);
        this.tk = new LispStreamTokenizer(this.inStream);
    }

    public void close() throws IOException {
        if (this.inStream != null) {
            this.inStream.close();
        }
        if (this.inReader != null) {
            this.inReader.close();
        }
    }

    public void setSingleQuoteIsMacro(boolean bl) {
        this.singleQuoteIsMacro = bl;
    }

    public Object safeRead(Object object) {
        try {
            return this.readObject();
        }
        catch (RuntimeException runtimeException) {
            Debug.noteException(runtimeException);
            return object;
        }
    }

    public Object safeRead() {
        return this.safeRead(Lisp.NIL);
    }

    public Object readObject() {
        Object object = this.reader();
        if (object == CLOSE) {
            throw new LispReadException("Extra close paren");
        }
        return object;
    }

    protected Object reader() {
        int n;
        try {
            n = this.tk.nextToken();
        }
        catch (IOException iOException) {
            Debug.noteException(iOException);
            throw new LispReadException("Tokenizer error");
        }
        Debug.expect(n != 10, "EOL token returned");
        if (n == -1) {
            return Lisp.EOF;
        }
        if (n == -3) {
            String string = this.tk.sval;
            char c = string.charAt(0);
            if (Character.isDigit(c) || c == '-' || c == '+' || c == '.') {
                return this.tryAsNumber(string);
            }
            if (c == 'n' && string.equals("nil")) {
                return Lisp.NIL;
            }
            if (c == '{' && string.endsWith("}")) {
                return Lisp.parseHashName(string);
            }
            return Symbol.quickIntern(string);
        }
        if (n == -2) {
            return new Double(this.tk.nval);
        }
        if (n == 40) {
            return this.listreader();
        }
        if (n == 41) {
            return CLOSE;
        }
        if (n == 34) {
            return this.tk.sval;
        }
        if (n == 124) {
            return Symbol.intern(this.tk.sval);
        }
        if (n == 39 && this.singleQuoteIsMacro) {
            return new Cons(QUOTE, new Cons(this.reader(), Lisp.NIL));
        }
        return Symbol.quickIntern(String.valueOf((char)n));
    }

    protected Object tryAsNumber(String string) {
        String string2 = string.charAt(0) == '+' ? string.substring(1) : string;
        try {
            return Long.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException2) {
                return Symbol.intern(string);
            }
        }
    }

    protected LList listreader() {
        Object object;
        Cons cons;
        Cons cons2 = cons = new Cons(Lisp.NIL, Lisp.NIL);
        while ((object = this.reader()) != CLOSE && object != Lisp.EOF) {
            cons2.cdr = new Cons(object, Lisp.NIL);
            cons2 = (Cons)cons2.cdr;
        }
        if (object == Lisp.EOF) {
            throw new LispReadException("Missing close paren.");
        }
        return cons.cdr;
    }
}

