/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.icore.Variable;
import ix.util.SimpleStringBuffer;
import ix.util.Strings;
import ix.util.UniqueObject;
import ix.util.Util;
import ix.util.lisp.Cons;
import ix.util.lisp.DelimitedSymbol;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.LispReadException;
import ix.util.lisp.LispReader;
import ix.util.lisp.Null;
import ix.util.lisp.ObjectHash;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;

public class Lisp {
    public static final Null NIL = new Null();
    public static final Object EOF = new UniqueObject("EOF");
    private static ObjectHash defaultHash = new ObjectHash();

    private Lisp() {
    }

    public static final Cons cons(Object object, LList lList) {
        return new Cons(object, lList);
    }

    public static final Null list() {
        return NIL;
    }

    public static final Cons list(Object object) {
        return new Cons(object, NIL);
    }

    public static final Cons list(Object object, Object object2) {
        return new Cons(object, new Cons(object2, NIL));
    }

    public static final Cons list(Object object, Object object2, Object object3) {
        return new Cons(object, new Cons(object2, new Cons(object3, NIL)));
    }

    public static final Cons list(Object object, Object object2, Object object3, Object object4) {
        return new Cons(object, new Cons(object2, new Cons(object3, new Cons(object4, NIL))));
    }

    public static final Cons list(Object object, Object object2, Object object3, Object object4, Object object5) {
        return new Cons(object, new Cons(object2, new Cons(object3, new Cons(object4, new Cons(object5, NIL)))));
    }

    public static final Cons list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return new Cons(object, new Cons(object2, new Cons(object3, new Cons(object4, new Cons(object5, new Cons(object6, NIL))))));
    }

    public static final boolean equal(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object instanceof Cons) {
            return object2 instanceof Cons ? Lisp.equal(((Cons)object).car, ((Cons)object2).car) && Lisp.equal(((Cons)object).cdr, ((Cons)object2).cdr) : false;
        }
        if (object instanceof String) {
            return object2 instanceof String ? object.equals(object2) : false;
        }
        if (object instanceof Number) {
            return object2 instanceof Number ? object.equals(object2) : false;
        }
        return false;
    }

    public static LispReader openForInput(URL uRL) throws IOException {
        Reader reader = Util.openURLReader(uRL);
        return new LispReader(new BufferedReader(reader));
    }

    public static LispReader openForInput(String string) throws IOException {
        URL uRL = XML.toURL(string);
        if (uRL == null) {
            throw new IllegalArgumentException("Can't find " + string);
        }
        return Lisp.openForInput(uRL);
    }

    public static Object readFromString(String string) {
        LispReader lispReader = new LispReader(string);
        try {
            Object object = lispReader.readObject();
            if (lispReader.readObject() != EOF) {
                throw new LispReadException(string.trim().startsWith("(") ? "Extra close paren" : "More than one object");
            }
            return object;
        }
        catch (LispReadException lispReadException) {
            throw new LispReadException(lispReadException.getMessage() + " in string " + Strings.quote(string));
        }
    }

    public static LList elementsFromString(String string) {
        LListCollector lListCollector = new LListCollector();
        LispReader lispReader = new LispReader(string);
        try {
            while (true) {
                Object object;
                if ((object = lispReader.readObject()) == EOF) {
                    return lListCollector.contents();
                }
                lListCollector.add(object);
            }
        }
        catch (LispReadException lispReadException) {
            throw new LispReadException(lispReadException.getMessage() + " in string " + Strings.quote(string));
        }
    }

    public static String printToString(Object object) {
        if (object == null) {
            return "#<null>";
        }
        if (object instanceof DelimitedSymbol) {
            return Lisp.quotedAndEscaped('|', object.toString());
        }
        if (object instanceof Symbol) {
            return object.toString();
        }
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof String) {
            return Lisp.quotedAndEscaped('\"', (String)object);
        }
        if (object instanceof Null) {
            return "nil";
        }
        if (object instanceof Cons) {
            LList lList = (Cons)object;
            String string = "(" + Lisp.printToString(((LList)lList).car());
            while (((LList)lList).cdr() instanceof Cons) {
                string = string + " " + Lisp.printToString(((LList)lList).cdr().car());
                lList = ((LList)lList).cdr();
            }
            return string + ")";
        }
        if (object instanceof Variable) {
            return object.toString();
        }
        return Lisp.hashName(object);
    }

    public static boolean isFullyPrintable(Object object) {
        return object instanceof Symbol || object instanceof String || object instanceof Cons && Lisp.isFullyPrintableCons((Cons)object) || object instanceof Null || object instanceof Long || object instanceof Double || object instanceof Integer || object instanceof Float;
    }

    private static boolean isFullyPrintableCons(Cons cons) {
        for (LList lList = cons; lList != NIL; lList = ((LList)lList).cdr()) {
            if (Lisp.isFullyPrintable(((LList)lList).car())) continue;
            return false;
        }
        return true;
    }

    public static String elementsToString(LList lList) {
        if (lList.isEmpty()) {
            return "";
        }
        String string = Lisp.printToString(lList);
        return string.substring(1, string.length() - 1);
    }

    public static String quotedAndEscaped(char c, String string) {
        int n;
        int n2;
        int n3;
        int n4 = string.length();
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            n3 = string.charAt(i);
            if (n3 == c || n3 == 92 || n3 == 10) {
                ++n5;
                continue;
            }
            if (n3 != 13) continue;
            ++n5;
            n2 = i + 1;
            if (n2 >= n4 || (n = string.charAt(n2)) != 10) continue;
            i = n2;
        }
        SimpleStringBuffer simpleStringBuffer = new SimpleStringBuffer(n4 + n5 + 2);
        simpleStringBuffer.append(c);
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = string.charAt(n3);
            if (n2 == c || n2 == 92 || n2 == 10) {
                simpleStringBuffer.append('\\');
            } else if (n2 == 13) {
                int n6;
                simpleStringBuffer.append('\\');
                n = n3 + 1;
                if (n < n4 && (n6 = string.charAt(n)) == 10) {
                    simpleStringBuffer.append((char)n2);
                    n3 = n;
                    n2 = n6;
                }
            }
            simpleStringBuffer.append((char)n2);
        }
        simpleStringBuffer.append(c);
        return simpleStringBuffer.toString();
    }

    public static int hash(Object object) {
        return defaultHash.hash(object);
    }

    public static Object unhash(int n) {
        return defaultHash.unhash(n);
    }

    public static String hashName(Object object) {
        return defaultHash.hashName(object);
    }

    public static Object parseHashName(String string) {
        return defaultHash.parseHashName(string);
    }
}

