/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.util.Function1;
import ix.util.Predicate2;
import ix.util.Seq;
import ix.util.lisp.Cons;
import ix.util.lisp.LListCollector;
import ix.util.lisp.LListIterator;
import ix.util.lisp.LListListIterator;
import ix.util.lisp.Lisp;
import ix.util.lisp.LispObject;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class LList
extends AbstractSequentialList
implements LispObject,
Serializable,
Comparable {
    public static LList newLList(Collection collection) {
        if (collection.isEmpty()) {
            return Lisp.NIL;
        }
        return new Cons(collection);
    }

    public static LList LListify(List list) {
        Cons cons;
        if (list.isEmpty()) {
            return Lisp.NIL;
        }
        for (LList lList = cons = new Cons(list); lList != Lisp.NIL; lList = ((LList)lList).cdr()) {
            Object object = ((LList)lList).car();
            if (!(object instanceof List)) continue;
            lList.setCar(LList.LListify((List)object));
        }
        return cons;
    }

    public ListIterator listIterator(int n) {
        return new LListListIterator(this, n);
    }

    public int size() {
        return this.length();
    }

    public Iterator iterator() {
        return new LListIterator(this);
    }

    public boolean isEmpty() {
        return this == Lisp.NIL;
    }

    public Object get(int n) {
        return this.elementAt(n);
    }

    public int lastIndexOf(Object object) {
        int n = -1;
        int n2 = -1;
        for (LList lList = this; lList != Lisp.NIL; lList = lList.cdr()) {
            ++n;
            Object object2 = lList.car();
            if (object2 != object && !object.equals(object2)) continue;
            n2 = n;
        }
        return n2;
    }

    public abstract boolean isNull();

    public abstract Object car();

    public abstract LList cdr();

    public abstract int length();

    public abstract Object elementAt(int var1);

    public abstract Enumeration elements();

    public abstract boolean equal(LList var1);

    public abstract boolean find(Object var1);

    public abstract LList append(LList var1);

    public Object clone() {
        return Lisp.NIL;
    }

    public LList reverse() {
        LList lList = Lisp.NIL;
        for (LList lList2 = this; lList2 != Lisp.NIL; lList2 = lList2.cdr()) {
            lList = new Cons(lList2.car(), lList);
        }
        return lList;
    }

    public Object get(Object object) {
        LList lList = this;
        while (lList != Lisp.NIL) {
            if (lList.car() == object) {
                return lList.cdr().car();
            }
            lList = lList.cdr().cdr();
        }
        return null;
    }

    public LList put(Object object, Object object2) {
        LList lList = this;
        while (lList != Lisp.NIL) {
            if (lList.car() == object) {
                ((Cons)lList.cdr()).setCar(object2);
                return this;
            }
            lList = lList.cdr().cdr();
        }
        return new Cons(object, new Cons(object2, this));
    }

    public Cons alistEntry(Object object) {
        for (LList lList = this; lList != Lisp.NIL; lList = lList.cdr()) {
            Cons cons;
            Object object2 = lList.car();
            if (!(object2 instanceof Cons) || !(cons = (Cons)object2).car().equals(object)) continue;
            return cons;
        }
        return null;
    }

    public Object alistValue(Object object) {
        Cons cons = this.alistEntry(object);
        return cons == null ? null : cons.cdr().car();
    }

    public LList alistKeys() {
        LListCollector lListCollector = new LListCollector();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            lListCollector.add(((Cons)iterator.next()).car());
        }
        return lListCollector.contents();
    }

    public Map alistToMap(Map map) {
        for (LList lList = this; lList != Lisp.NIL; lList = lList.cdr()) {
            Cons cons;
            Object object = lList.car();
            if (!(object instanceof Cons) || !((cons = (Cons)object).cdr() instanceof Cons)) continue;
            Object object2 = cons.car();
            Object object3 = cons.cdr().car();
            if (map.get(object2) != null) continue;
            map.put(object2, object3);
        }
        return map;
    }

    public static LList mapToAlist(Map map) {
        LListCollector lListCollector = new LListCollector();
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            lListCollector.add(Lisp.list(k, v));
        }
        return lListCollector.contents();
    }

    public Cons lastCons() {
        Cons cons = (Cons)this;
        while (cons.cdr() != Lisp.NIL) {
            cons = (Cons)cons.cdr();
        }
        return cons;
    }

    public LList take(int n) {
        if (n <= 0 || this.isNull()) {
            return Lisp.NIL;
        }
        return new Cons(this.car(), this.cdr().take(n - 1));
    }

    public LList drop(int n) {
        LList lList = this;
        for (int i = 0; i < n; ++i) {
            lList = lList.cdr();
        }
        return lList;
    }

    public LList takeTo(Object object) {
        if (this.isNull() || this.car().equals(object)) {
            return Lisp.NIL;
        }
        return new Cons(this.car(), this.cdr().takeTo(object));
    }

    public LList dropTo(Object object) {
        for (LList lList = this; lList != Lisp.NIL; lList = lList.cdr()) {
            if (!lList.car().equals(object)) continue;
            return lList;
        }
        return Lisp.NIL;
    }

    public LList without(Object object) {
        LList lList;
        if (this.isNull()) {
            return this;
        }
        if (this.car() == object) {
            return this.cdr().without(object);
        }
        LList lList2 = this.cdr();
        if (lList2 == (lList = lList2.without(object))) {
            return this;
        }
        return new Cons(this.car(), lList);
    }

    public LList withoutAll(Collection collection) {
        LList lList;
        if (this.isNull()) {
            return this;
        }
        if (collection.contains(this.car())) {
            return this.cdr().withoutAll(collection);
        }
        LList lList2 = this.cdr();
        if (lList2 == (lList = lList2.withoutAll(collection))) {
            return this;
        }
        return new Cons(this.car(), lList);
    }

    public LList withoutFirst(Object object) {
        LList lList;
        if (this.isNull()) {
            return this;
        }
        if (this.car() == object) {
            return this.cdr();
        }
        LList lList2 = this.cdr();
        if (lList2 == (lList = lList2.withoutFirst(object))) {
            return this;
        }
        return new Cons(this.car(), lList);
    }

    public LList withoutFirstEqual(Object object) {
        LList lList;
        if (this.isNull()) {
            return this;
        }
        if (this.car() == object || this.car().equals(object)) {
            return this.cdr();
        }
        LList lList2 = this.cdr();
        if (lList2 == (lList = lList2.withoutFirst(object))) {
            return this;
        }
        return new Cons(this.car(), lList);
    }

    public LList delete(Object object) {
        if (this.isNull()) {
            return this;
        }
        if (this.car() == object) {
            return this.cdr();
        }
        LList lList = this;
        for (LList lList2 = this.cdr(); lList2 != Lisp.NIL; lList2 = lList2.cdr()) {
            if (lList2.car() == object) {
                ((Cons)lList).setCdr(lList2.cdr());
                break;
            }
            lList = lList2;
        }
        return this;
    }

    public LList insert(Object object, Predicate2 predicate2) {
        if (this.isNull()) {
            return new Cons(object, Lisp.NIL);
        }
        if (predicate2.trueOf(object, this.car())) {
            return new Cons(object, this);
        }
        return new Cons(this.car(), this.cdr().insert(object, predicate2));
    }

    public LList replaceAll(final Object object, final Object object2) {
        return this.mapcar(new Function1(){

            public Object funcall(Object object3) {
                return object3 == object ? object2 : object3;
            }
        });
    }

    public LList mapc(Function1 function1) {
        LList lList = this;
        while (!lList.isNull()) {
            function1.funcall(lList.car());
            lList = lList.cdr();
        }
        return this;
    }

    public LList mapcar(Function1 function1) {
        if (this.isNull()) {
            return Lisp.NIL;
        }
        return new Cons(function1.funcall(this.car()), this.cdr().mapcar(function1));
    }

    public LList flatmap(Function1 function1) {
        if (this.isNull()) {
            return Lisp.NIL;
        }
        return ((LList)function1.funcall(this.car())).append(this.cdr().flatmap(function1));
    }

    public LList mapNth(final int n) {
        return this.mapcar(new Function1(){

            public Object funcall(Object object) {
                return ((LList)object).elementAt(n);
            }
        });
    }

    public void walkTree(Function1 function1) {
        LList lList = this;
        while (!lList.isNull()) {
            Object object = lList.car();
            if (object instanceof LList) {
                ((LList)object).walkTree(function1);
            } else {
                function1.funcall(object);
            }
            lList = lList.cdr();
        }
    }

    public LList mapTree(final Function1 function1) {
        return this.mapcar(new Function1(){

            public Object funcall(Object object) {
                if (object instanceof LList) {
                    return ((LList)object).mapTree(function1);
                }
                return function1.funcall(object);
            }
        });
    }

    public LList intersect(LList lList) {
        LListCollector lListCollector = new LListCollector();
        LList lList2 = this;
        while (!lList2.isNull()) {
            Object object = lList2.car();
            if (lList.find(object)) {
                lListCollector.addElement(object);
            }
            lList2 = lList2.cdr();
        }
        return lListCollector.contents();
    }

    public LList permute() {
        return Seq.toLList(Seq.shuffleVector(Seq.toVector(this.elements())).elements());
    }

    public String toJavaString() {
        return super.toString();
    }
}

