/*
 * Decompiled with CFR 0.152.
 */
package ix.util.http;

import ix.util.Debug;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.http.HttpUtilities;
import ix.util.xml.XML;
import java.io.BufferedReader;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHandler;

public class IXHttpServer {
    HttpUtilities util = new HttpUtilities();
    Server server;
    ServletHandler servlets;
    int listenPort = -1;
    String docRoot = null;

    public IXHttpServer() {
    }

    public IXHttpServer(int n) {
        this.listenPort = n;
    }

    public synchronized int getServerPort() {
        return this.listenPort;
    }

    public synchronized String getDocRoot() {
        return this.docRoot;
    }

    public synchronized void setupServer() {
        Debug.noteln("Setting up IXHttpServer");
        this.server = new Server();
        SocketListener socketListener = new SocketListener();
        int n = this.listenPort;
        if (n < 0) {
            n = Parameters.getInt("http-server-port", n);
        }
        if (n > 0) {
            socketListener.setPort(n);
        }
        try {
            socketListener.open();
            this.listenPort = socketListener.getPort();
            Debug.noteln("Server port:", this.listenPort);
        }
        catch (IOException iOException) {
            throw new RethrownException("Cannot get a port for the HTTP server. ", iOException);
        }
        this.server.addListener((HttpListener)socketListener);
        HttpContext httpContext = new HttpContext();
        httpContext.setContextPath("/files/*");
        this.server.addContext(httpContext);
        ServletHandler servletHandler = new ServletHandler();
        httpContext.addHandler((HttpHandler)servletHandler);
        this.docRoot = Parameters.getParameter("http-root-directory");
        if (this.docRoot != null && !this.docRoot.equals("")) {
            httpContext.setResourceBase(XML.toURL(this.docRoot).toString());
            httpContext.addHandler((HttpHandler)new ResourceHandler());
        }
        try {
            this.server.start();
        }
        catch (Throwable throwable) {
            throw new RethrownException("Couldn't start the HTTP server. ", throwable);
        }
    }

    public class CommServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            Debug.noteln("HTTP request URI:", httpServletRequest.getRequestURI());
            int n = httpServletRequest.getContentLength();
            if (n == -1) {
                httpServletResponse.sendError(411);
                return;
            }
            BufferedReader bufferedReader = httpServletRequest.getReader();
            HttpUtilities cfr_ignored_0 = IXHttpServer.this.util;
            String string = HttpUtilities.readText(bufferedReader, n);
            bufferedReader.close();
            if (string == null) {
                httpServletResponse.sendError(400, "Not enough data.");
                return;
            }
            Debug.noteln("Recieved:", string);
            Object object = IXHttpServer.this.util.decodeReceived(string);
            int n2 = 200;
            String string2 = null;
            try {
                string2 = "OK";
            }
            catch (Throwable throwable) {
                Debug.displayException("Problem handling " + object, throwable);
                string2 = Debug.describeException(throwable);
                n2 = 500;
            }
            byte[] byArray = IXHttpServer.this.util.encodeForSend(string2);
            httpServletResponse.setStatus(n2);
            httpServletResponse.setContentType("application/xml; charset=UTF-8");
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(byArray);
            servletOutputStream.flush();
            servletOutputStream.close();
        }
    }
}

