/*
 * Decompiled with CFR 0.152.
 */
package ix.util.http;

import ix.util.Debug;
import ix.util.RethrownException;
import ix.util.http.HttpUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class IXHttpClient {
    HttpUtilities util = new HttpUtilities();

    public Object requestObject(URL uRL, Object object) {
        try {
            return this.do_requestObject(uRL, object);
        }
        catch (IOException iOException) {
            throw new RethrownException("Trouble requesting from " + uRL + ". ", iOException);
        }
    }

    protected Object do_requestObject(URL uRL, Object object) throws IOException {
        Debug.noteln("Sending to", uRL);
        Debug.noteln("Contents:", object);
        byte[] byArray = this.util.encodeForSend(object);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Length", "" + byArray.length);
        httpURLConnection.setRequestProperty("Content-Type", "application/xml; charset=UTF-8");
        httpURLConnection.setRequestProperty("Host", uRL.getHost() + ":" + uRL.getPort());
        httpURLConnection.connect();
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(byArray);
        outputStream.flush();
        outputStream.close();
        Debug.noteln("");
        Debug.noteln("Response:");
        Debug.noteln(httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
        Debug.noteln("");
        Debug.noteln("Reply Headers:");
        for (Map.Entry<String, List<String>> object22 : httpURLConnection.getHeaderFields().entrySet()) {
            Debug.noteln(object22.getKey() + ": " + object22.getValue());
        }
        InputStream inputStream = httpURLConnection.getInputStream();
        String string = httpURLConnection.getContentEncoding();
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        int n = httpURLConnection.getContentLength();
        String string2 = "";
        if (n < 0) {
            Debug.noteln("No contet length; will read everything.");
            string2 = HttpUtilities.readAllLines(inputStreamReader);
            ((Reader)inputStreamReader).close();
        } else {
            string2 = HttpUtilities.readText(inputStreamReader, n);
            ((Reader)inputStreamReader).close();
            if (string2 == null) {
                throw new RuntimeException("EOF");
            }
        }
        Debug.noteln("");
        Debug.noteln("Reply:");
        Debug.noteln(string2);
        return this.util.decodeReceived(string2);
    }
}

