/*
 * Decompiled with CFR 0.152.
 */
package ix.util.http;

import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.Util;
import ix.util.ipc.ServiceAddress;
import ix.util.xml.XML;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.LinkedList;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class HttpUtilities {
    public String getHostName() {
        try {
            return Util.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RethrownException(unknownHostException);
        }
    }

    public byte[] encodeForSend(Object object) {
        Document document = XML.objectToDocument(object);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            XMLOutputter xMLOutputter = XML.makePrettyXMLOutputter();
            xMLOutputter.output(document, (Writer)outputStreamWriter);
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new RethrownException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Object decodeReceived(String string) {
        return XML.objectFromXML(string);
    }

    public URL makeMessageURL(ServiceAddress serviceAddress, String string) {
        try {
            return new URL("http", serviceAddress.getHost(), serviceAddress.getPort(), string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RethrownException("Can't make a URL from " + serviceAddress + ". ", malformedURLException);
        }
    }

    public static String readText(Reader reader, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = n;
        int n3 = 0;
        while (n2 > 0) {
            int n4 = reader.read(cArray, n3, n2);
            if (n4 == -1) {
                return null;
            }
            n2 -= n4;
            n3 += n4;
        }
        return new String(cArray);
    }

    public static String readAllLines(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            linkedList.add(string);
        }
        return Strings.joinLines(linkedList);
    }
}

