/*
 * Decompiled with CFR 0.152.
 */
package ix.util.context;

import ix.util.Debug;
import ix.util.Strings;
import ix.util.context.ContextHolder;
import ix.util.context.ContextHoldingStrategy;
import ix.util.context.ContextLink;
import ix.util.context.GlobalHoldingStrategy;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public final class Context {
    static long count = 0L;
    static HashMap numberToContextTable = new HashMap();
    public static final Context rootContext = new Context();
    static ContextHoldingStrategy contextHoldingStrategy = new GlobalHoldingStrategy();
    final long number;
    final Context parent;
    final List children = new ArrayList();

    public Context() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context(Context context) {
        Class<Context> clazz = Context.class;
        synchronized (Context.class) {
            this.number = count++;
            this.parent = context == null && rootContext != null ? rootContext : context;
            if (this.parent != null) {
                this.parent.children.add(this);
            }
            numberToContextTable.put(new Long(this.number), new WeakReference<Context>(this));
            Debug.expect(Context.getContext(this.number) == this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public long getNumber() {
        return this.number;
    }

    public Context getParent() {
        return this.parent;
    }

    public List getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard() {
        Class<Context> clazz = Context.class;
        synchronized (Context.class) {
            if (this.parent != null) {
                this.parent.children.remove(this);
            }
            Context.discardSubtree(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void discardSubtree(Context context) {
        Object object2;
        for (Object object2 : context.children) {
            Context.discardSubtree((Context)object2);
        }
        context.children.clear();
        Long l = new Long(context.number);
        object2 = (WeakReference)numberToContextTable.get(l);
        ((Reference)object2).clear();
        numberToContextTable.remove(l);
        Debug.expect(Context.getContext(context.number) == null);
    }

    public String toString() {
        return "#<Context " + this.number + ">";
    }

    public static Context getContext() {
        return contextHoldingStrategy.getContextHolder().getContext();
    }

    public static Context getContext(long l) {
        WeakReference weakReference = (WeakReference)numberToContextTable.get(new Long(l));
        return weakReference == null ? null : (Context)weakReference.get();
    }

    public static void setContext(Context context) {
        contextHoldingStrategy.getContextHolder().setContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearContexts() {
        Class<Context> clazz = Context.class;
        synchronized (Context.class) {
            Context.rootContext.children.clear();
            numberToContextTable.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            contextHoldingStrategy.clearContexts();
            return;
        }
    }

    public static ContextHoldingStrategy getContextHoldingStrategy() {
        return contextHoldingStrategy;
    }

    public static void setContextHoldingStrategy(ContextHoldingStrategy contextHoldingStrategy) {
        Context.contextHoldingStrategy = contextHoldingStrategy;
    }

    public static ContextHolder getContextHolder() {
        return contextHoldingStrategy.getContextHolder();
    }

    public static Object getInContext(ContextLink contextLink, Context context) {
        Context context2 = context;
        while (context2 != null) {
            long l = context2.number;
            while (contextLink != null && contextLink.contextNumber > l) {
                contextLink = contextLink.next;
            }
            if (contextLink == null) {
                return null;
            }
            if (contextLink.contextNumber == l) {
                return contextLink.value;
            }
            context2 = context2.parent;
        }
        return null;
    }

    public static Object getInContext(ContextLink contextLink, Context context, Object object) {
        ContextLink contextLink2 = Context.getValueLinkInContext(contextLink, context);
        if (contextLink2 == null) {
            return object;
        }
        return contextLink2.value;
    }

    public static Object requireInContext(ContextLink contextLink, Context context) {
        ContextLink contextLink2 = Context.getValueLinkInContext(contextLink, context);
        if (contextLink2 == null) {
            throw new IllegalArgumentException("Couldn't find value in " + context);
        }
        return contextLink2.value;
    }

    public static ContextLink getValueLinkInContext(ContextLink contextLink, Context context) {
        Context context2 = context;
        while (context2 != null) {
            long l = context2.number;
            while (contextLink != null && contextLink.contextNumber > l) {
                contextLink = contextLink.next;
            }
            if (contextLink == null) {
                return null;
            }
            if (contextLink.contextNumber == l) {
                return contextLink;
            }
            context2 = context2.parent;
        }
        return null;
    }

    public static void setInContext(ContextLink contextLink, Context context, Object object) {
        Context context2 = context;
        long l = context2.number;
        ContextLink contextLink2 = contextLink;
        while (true) {
            if (contextLink2.contextNumber == l) {
                contextLink2.value = object;
                return;
            }
            if (contextLink2.contextNumber < l) {
                contextLink2.next = new ContextLink(contextLink2.contextNumber, contextLink2.value, contextLink2.next);
                contextLink2.contextNumber = l;
                contextLink2.value = object;
                return;
            }
            if (contextLink2.next == null) {
                contextLink2.next = new ContextLink(context2, object, null);
                return;
            }
            contextLink2 = contextLink2.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inContext(ContextHolder contextHolder, Context context, Runnable runnable) {
        Context context2 = contextHolder.getContext();
        try {
            contextHolder.setContext(context);
            runnable.run();
        }
        finally {
            contextHolder.setContext(context2);
        }
    }

    public static Context pushContext(ContextHolder contextHolder) {
        contextHolder.setContext(new Context(contextHolder.getContext()));
        return contextHolder.getContext();
    }

    public static Context popContext(ContextHolder contextHolder) {
        Context context = contextHolder.getContext();
        if (context == null) {
            throw new Error("Trying to pop null context");
        }
        if (context.parent == null) {
            throw new Error("Trying to pop to null context");
        }
        contextHolder.setContext(context.parent);
        return context;
    }

    public static Context pushContext() {
        return Context.pushContext(contextHoldingStrategy.getContextHolder());
    }

    public static Context popContext() {
        return Context.popContext(contextHoldingStrategy.getContextHolder());
    }

    public static void inContext(Context context, Runnable runnable) {
        Context.inContext(contextHoldingStrategy.getContextHolder(), context, runnable);
    }

    public static void printContextTree() {
        Context.pctLoop(rootContext, 0);
    }

    private static void pctLoop(Context context, int n) {
        Debug.out.print(Strings.repeat(n, "   "));
        Debug.out.println(context);
        for (Context context2 : context.getChildren()) {
            Context.pctLoop(context2, n + 1);
        }
    }
}

