/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.ConsistencyException;
import ix.util.JavaNameWordIterator;
import ix.util.SimpleStringBuffer;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class Strings {
    private Strings() {
    }

    public static String[] toArray(Collection collection) {
        return collection.toArray(new String[collection.size()]);
    }

    public static int indexOfAny(String string, String string2) {
        return Strings.indexOfAny(string, 0, string2);
    }

    public static int indexOfAny(String string, int n, String string2) {
        int n2 = string2.length();
        for (int i = n; i < n2; ++i) {
            int n3 = string.indexOf(string2.charAt(i));
            if (n3 == -1) continue;
            return i;
        }
        return -1;
    }

    public static String[] breakAtFirst(String string, String string2) {
        int n = string2.indexOf(string);
        if (n == -1) {
            return new String[]{string2, ""};
        }
        return new String[]{string2.substring(0, n), string2.substring(n + string.length())};
    }

    public static String[] breakAtLast(String string, String string2) {
        int n = string2.lastIndexOf(string);
        if (n == -1) {
            return new String[]{string2, ""};
        }
        return new String[]{string2.substring(0, n), string2.substring(n + string.length())};
    }

    public static List breakAt(String string, String string2) {
        int n = string2.length();
        if (n == 0) {
            return Lisp.list();
        }
        int n2 = string2.indexOf(string);
        if (n2 < 0) {
            return Lisp.list(string2);
        }
        LListCollector lListCollector = new LListCollector();
        int n3 = string.length();
        int n4 = 0;
        while (n2 >= 0) {
            lListCollector.add(string2.substring(n4, n2));
            n4 = n2 + n3;
            if (n4 == n) break;
            n2 = string2.indexOf(string, n4);
        }
        lListCollector.add(string2.substring(n4));
        return lListCollector.contents();
    }

    public static List breakAtAny(String string, String string2) {
        int n = string2.length();
        if (n == 0) {
            return Lisp.list();
        }
        int n2 = Strings.indexOfAny(string, string2);
        if (n2 < 0) {
            return Lisp.list(string2);
        }
        LListCollector lListCollector = new LListCollector();
        int n3 = 0;
        while (n2 >= 0) {
            lListCollector.add(string2.substring(n3, n2));
            n3 = n2 + 1;
            if (n3 == n) break;
            n2 = Strings.indexOfAny(string, n3, string2);
        }
        lListCollector.add(string2.substring(n3));
        return lListCollector.contents();
    }

    public static String joinWith(String string, List list) {
        Object object;
        int n = string.length();
        int n2 = 0;
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            n2 += ((String)object).length();
            if (!object2.hasNext()) continue;
            n2 += n;
        }
        object2 = new SimpleStringBuffer(n2);
        object = list.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            ((SimpleStringBuffer)object2).append(string2);
            if (!object.hasNext()) continue;
            ((SimpleStringBuffer)object2).append(string);
        }
        return ((SimpleStringBuffer)object2).toString();
    }

    public static String joinWith(String string, String[] stringArray) {
        return Strings.joinWith(string, Arrays.asList(stringArray));
    }

    public static String joinLines(List list) {
        return Strings.joinWith(System.getProperty("line.separator"), list);
    }

    public static String joinLines(String[] stringArray) {
        return Strings.joinLines(Arrays.asList(stringArray));
    }

    public static String beforeFirst(String string, String string2) {
        int n = string2.indexOf(string);
        return n == -1 ? string2 : string2.substring(0, n);
    }

    public static String afterFirst(String string, String string2) {
        int n = string2.indexOf(string);
        return n == -1 ? string2 : string2.substring(n + string.length());
    }

    public static String beforeLast(String string, String string2) {
        int n = string2.lastIndexOf(string);
        return n == -1 ? string2 : string2.substring(0, n);
    }

    public static String afterLast(String string, String string2) {
        int n = string2.lastIndexOf(string);
        return n == -1 ? string2 : string2.substring(n + string.length());
    }

    public static String firstLine(String string) {
        return Strings.beforeFirst("\n", string);
    }

    public static List breakIntoLines(String string) {
        return Strings.breakAt("\n", string);
    }

    public static String foldLongLine(String string) {
        return Strings.foldLongLine(string, 80, null);
    }

    public static String foldLongLine(String string, int n, String string2) {
        String string3 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
        List list = Strings.breakIntoLines(string);
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            List list2 = Strings.breakAt(" ", string4);
            for (String string5 : list2) {
                if (n2 + string5.length() > n) {
                    stringBuffer.append(string3);
                    if (string2 != null) {
                        stringBuffer.append(string2);
                        n2 = string2.length();
                    } else {
                        n2 = 0;
                    }
                }
                stringBuffer.append(string5).append(" ");
                n2 += string5.length() + 1;
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string3);
            if (string2 != null) {
                stringBuffer.append(string2);
                n2 = string2.length();
                continue;
            }
            n2 = 0;
        }
        return stringBuffer.toString();
    }

    public static String[] foldToArray(String string) {
        return Strings.toArray(Strings.breakIntoLines(Strings.foldLongLine(string)));
    }

    public static String replace(String string, String string2, String string3) {
        int n = string3.indexOf(string);
        if (n < 0) {
            return string3;
        }
        int n2 = string2.length() - string.length();
        int n3 = n2 <= 0 ? 0 : 10 * n2;
        StringBuffer stringBuffer = new StringBuffer(string3.length() + n3);
        int n4 = string.length();
        int n5 = 0;
        while (n >= 0) {
            stringBuffer.append(string3.substring(n5, n)).append(string2);
            n5 = n + n4;
            n = string3.indexOf(string, n5);
        }
        stringBuffer.append(string3.substring(n5));
        return stringBuffer.toString();
    }

    public static String replaceChars(String string, String string2, String string3) {
        int n = Strings.indexOfAny(string, string3);
        if (n < 0) {
            return string3;
        }
        SimpleStringBuffer simpleStringBuffer = new SimpleStringBuffer(string3.length());
        int n2 = 1;
        int n3 = 0;
        while (n >= 0) {
            char c = string3.charAt(n);
            int n4 = string.indexOf(c);
            char c2 = string2.charAt(n4);
            simpleStringBuffer.append(string3, n3, n);
            simpleStringBuffer.append(c2);
            n3 = n + n2;
            n = Strings.indexOfAny(string, n3, string3);
        }
        simpleStringBuffer.append(string3.substring(n3));
        return simpleStringBuffer.toString();
    }

    public static String quote(String string) {
        return "\"" + string + "\"";
    }

    public static boolean isVowel(char c) {
        switch (c) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return true;
            }
        }
        return false;
    }

    public static String indefinite(String string) {
        return (Strings.isVowel(string.charAt(0)) ? "an " : "a ") + string;
    }

    public static String disjunction(Collection collection) {
        return Strings.junction(collection, "or");
    }

    public static String conjunction(Collection collection) {
        return Strings.junction(collection, "and");
    }

    private static String junction(Collection collection, String string) {
        List list = collection instanceof List ? (List)collection : new ArrayList(collection);
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            listIterator.set(listIterator.next().toString());
        }
        int n = list.size();
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return (String)list.get(0);
            }
            case 2: {
                return list.get(0) + " " + string + " " + list.get(1);
            }
        }
        String string2 = Strings.joinWith(", ", list.subList(0, n - 1));
        return string2 + ", " + string + " " + list.get(n - 1);
    }

    public static boolean isAllLowerCase(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String capitalize(String string) {
        SimpleStringBuffer simpleStringBuffer = new SimpleStringBuffer(string.length());
        simpleStringBuffer.appendCapitalized(string);
        return simpleStringBuffer.toString();
    }

    public static String uncapitalize(String string) {
        SimpleStringBuffer simpleStringBuffer = new SimpleStringBuffer(string.length());
        simpleStringBuffer.appendUncapitalized(string);
        return simpleStringBuffer.toString();
    }

    public static String repeat(int n, String string) {
        SimpleStringBuffer simpleStringBuffer = new SimpleStringBuffer(n * string.length());
        for (int i = 0; i < n; ++i) {
            simpleStringBuffer.append(string);
        }
        return simpleStringBuffer.toString();
    }

    public static String dashNameToJavaName(String string) {
        List list = Strings.breakAt("-", string);
        SimpleStringBuffer simpleStringBuffer = new SimpleStringBuffer(string.length());
        for (String string2 : list) {
            simpleStringBuffer.appendCapitalized(string2);
        }
        return simpleStringBuffer.toString();
    }

    public static String dashNameToFullJavaName(String string) {
        if (string.indexOf(".") == -1) {
            return Strings.unDash(string);
        }
        String[] stringArray = Strings.breakAtLast(".", string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        return string2 + "." + Strings.unDash(string3);
    }

    private static String unDash(String string) {
        if (string.indexOf("$") == -1) {
            return Strings.dashNameToJavaName(string);
        }
        List list = Strings.breakAt("$", string);
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            listIterator.set(Strings.dashNameToJavaName(string2));
        }
        return Strings.joinWith("$", list);
    }

    public static String javaNameToDashName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        JavaNameWordIterator javaNameWordIterator = new JavaNameWordIterator(string);
        while (javaNameWordIterator.hasNext()) {
            String string2 = (String)javaNameWordIterator.next();
            int n = string2.length();
            if (n < 1) {
                throw new ConsistencyException("Misparsed", string);
            }
            if (!Character.isUpperCase(string2.charAt(0))) {
                stringBuffer.append(string2);
            } else if (n >= 2 && Character.isUpperCase(string2.charAt(1))) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(Strings.uncapitalize(string2));
            }
            if (!javaNameWordIterator.hasNext()) continue;
            stringBuffer.append("-");
        }
        return stringBuffer.toString();
    }

    public static String fullJavaNameToDashName(String string) {
        if (string.indexOf(".") == -1) {
            return Strings.dash(string);
        }
        String[] stringArray = Strings.breakAtLast(".", string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        return string2 + "." + Strings.dash(string3);
    }

    private static String dash(String string) {
        if (string.indexOf("$") == -1) {
            return Strings.javaNameToDashName(string);
        }
        List list = Strings.breakAt("$", string);
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            listIterator.set(Strings.javaNameToDashName(string2));
        }
        return Strings.joinWith("$", list);
    }
}

