/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.icore.AbstractAnnotatedObject;
import ix.icore.Annotated;
import ix.icore.Sendable;
import ix.util.Debug;
import ix.util.Name;
import ix.util.Strings;
import ix.util.TransferThread;
import ix.util.Util;
import ix.util.ipc.IPCListener;
import ix.util.ipc.ParameterizedCommStrategy;
import ix.util.ipc.SerializedCommunicationStrategy;
import ix.util.xml.XML;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class IPC {
    static CommunicationStrategy communicationStrategy = new EmptyCommunicationStrategy(){};
    static Object thisAgentAsDestination = null;
    static List ipcListeners = new LinkedList();

    private IPC() {
    }

    public static synchronized CommunicationStrategy getCommunicationStrategy() {
        return communicationStrategy;
    }

    public static synchronized void setCommunicationStrategy(CommunicationStrategy communicationStrategy) {
        Debug.noteln("Setting global communication strategy to", communicationStrategy);
        IPC.communicationStrategy = communicationStrategy;
    }

    public static synchronized void setCommunicationStrategy(String string) {
        IPC.setCommunicationStrategy(IPC.makeCommunicationStrategy(string));
    }

    public static CommunicationStrategy makeCommunicationStrategy(String string) {
        if (string.indexOf(":") >= 0) {
            return IPC.evalStrategyExpr(string);
        }
        if (string.equals("") || string.equals("simple")) {
            return new SimpleIXCommunicationStrategy();
        }
        if (string.equals("xml")) {
            return new SimpleIXXMLCommunicationStrategy();
        }
        Class clazz = IPC.findClassForName(string);
        if (clazz != null || (clazz = IPC.findClassForName("ix." + string + "." + Strings.capitalize(string) + "CommunicationStrategy")) != null || (clazz = IPC.findClassForName("ix.util.ipc." + Strings.capitalize(string) + "Strategy")) != null) {
            try {
                return (CommunicationStrategy)clazz.newInstance();
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                throw new IllegalArgumentException("Can't make communication strategy from " + string + " because " + exception);
            }
        }
        throw new IllegalArgumentException("Can't find communication strategy class specified by " + Util.quote(string));
    }

    protected static CommunicationStrategy evalStrategyExpr(String string) {
        String[] stringArray = Strings.breakAtFirst(":", string);
        String string2 = stringArray[0];
        List list = Strings.breakAt(",", stringArray[1]);
        CommunicationStrategy communicationStrategy = IPC.makeCommunicationStrategy(string2);
        if (communicationStrategy instanceof ParameterizedCommStrategy) {
            ParameterizedCommStrategy parameterizedCommStrategy = (ParameterizedCommStrategy)communicationStrategy;
            return parameterizedCommStrategy.apply(Strings.toArray(list));
        }
        throw new IllegalArgumentException("Cannot use " + Strings.quote(string2) + " communication strategy with parameters.  " + "Parameters were " + list);
    }

    private static Class findClassForName(String string) {
        Debug.noteln("Looking for class", string);
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static void sendObject(Object object, Object object2) {
        Sendable sendable;
        if (object2 instanceof Sendable && (sendable = (Sendable)object2).getSenderId() == null) {
            Debug.noteln("Filling in sender-id of " + sendable + " to be " + thisAgentAsDestination);
            Sendable sendable2 = (Sendable)Util.clone(sendable);
            sendable2.setSenderId(Name.valueOf(thisAgentAsDestination));
            object2 = sendable2;
        }
        IPC.fireSendingMessage(object, object2);
        IPC.getCommunicationStrategy().sendObject(object, object2);
        IPC.fireMessageSent(object, object2);
    }

    public static void setupServer(Object object, MessageListener messageListener) {
        IPC.getCommunicationStrategy().setupServer(object, messageListener);
        thisAgentAsDestination = object;
    }

    public static void addIPCListener(IPCListener iPCListener) {
        ipcListeners.add(iPCListener);
    }

    public static void fireSendingMessage(Object object, Object object2) {
        for (IPCListener iPCListener : ipcListeners) {
            iPCListener.sendingMessage(object, object2);
        }
    }

    public static void fireMessageSent(Object object, Object object2) {
        for (IPCListener iPCListener : ipcListeners) {
            iPCListener.messageSent(object, object2);
        }
    }

    public static void fireMessageReceived(InputMessage inputMessage) {
        for (IPCListener iPCListener : ipcListeners) {
            iPCListener.messageReceived(inputMessage);
        }
    }

    public static class BrokenConnectionException
    extends IPCException {
        public BrokenConnectionException(String string) {
            super(string);
        }

        public BrokenConnectionException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public BrokenConnectionException(Connection connection, Throwable throwable) {
            super("Broken connection", throwable);
        }
    }

    public static class IPCException
    extends RuntimeException {
        Throwable reason;

        public IPCException() {
        }

        public IPCException(String string) {
            super(string);
        }

        public IPCException(Throwable throwable) {
            super("Caused by " + Debug.describeException(throwable));
            this.reason = throwable;
        }

        public IPCException(String string, Throwable throwable) {
            super(string + " caused by " + Debug.describeException(throwable));
            this.reason = throwable;
        }

        public Throwable getReason() {
            return this.reason;
        }
    }

    public static class XMLObjectStreamCommunicationStrategy
    extends SerializedCommunicationStrategy {
        public Object preEncode(Object object) {
            return XML.objectToXMLString(object);
        }

        public Object postDecode(Object object) {
            return XML.objectFromXML((String)object);
        }
    }

    public static class SimpleIXXMLCommunicationStrategy
    extends XMLObjectStreamCommunicationStrategy {
    }

    public static class SimpleIXCommunicationStrategy
    extends SerializedCommunicationStrategy {
    }

    public static class EmptyCommunicationStrategy
    implements CommunicationStrategy {
        public void sendObject(Object object, Object object2) {
            throw new IPCException("Cannot send to " + object + " because no communication strategy has been specified.");
        }

        public void setupServer(Object object, MessageListener messageListener) {
        }
    }

    public static class BasicDestinationTable
    extends HashMap
    implements DestinationTable {
    }

    public static interface DestinationTable {
        public Object get(Object var1);

        public Object put(Object var1, Object var2);
    }

    public static interface Connection {
        public Object getDestination();

        public void send(Object var1);

        public Object receive();

        public void close();
    }

    public static interface SocketlikeCommunicationStrategy
    extends CommunicationStrategy {
        public Object getDestinationData(Object var1);

        public void setDestinationData(Object var1, Object var2);

        public Connection connectTo(Object var1);

        public Connection getConnection(Object var1);
    }

    public static class BufferedMessageListener
    implements MessageListener {
        protected MessageListener innerListener;
        protected TransferThread thread = new TransferThread(){

            public void handle(Object object) {
                BufferedMessageListener.this.handleMessage((InputMessage)object);
            }
        };

        public BufferedMessageListener(MessageListener messageListener) {
            this.innerListener = messageListener;
            this.thread.start();
        }

        protected BufferedMessageListener() {
            this(null);
        }

        public void messageReceived(InputMessage inputMessage) {
            this.thread.take(inputMessage);
        }

        protected void handleMessage(InputMessage inputMessage) {
            this.innerListener.messageReceived(inputMessage);
        }
    }

    public static interface MessageListener {
        public void messageReceived(InputMessage var1);
    }

    public static class BasicInputMessage
    extends AbstractAnnotatedObject
    implements InputMessage {
        protected Object contents;

        public BasicInputMessage(Object object) {
            this.contents = object;
        }

        public Object getContents() {
            return this.contents;
        }
    }

    public static interface InputMessage
    extends Annotated {
        public Object getContents();
    }

    public static interface CommunicationStrategy {
        public void sendObject(Object var1, Object var2);

        public void setupServer(Object var1, MessageListener var2);
    }
}

