/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.RethrownException;
import ix.util.ThreadCondition;

public abstract class FutureValue {
    private Thread thread;
    private ThreadCondition cond;
    private Object value;
    private Throwable except;

    public FutureValue(String string) {
        this.thread = new FutureValueThread(string);
        this.cond = new ThreadCondition("Future " + string);
    }

    public void start() {
        this.thread.start();
    }

    public Object getValue() {
        this.cond.waitUntilTrue();
        if (this.except == null) {
            return this.value;
        }
        throw new RethrownException(this.except);
    }

    public void waitUntilReady(long l) {
        this.cond.waitUntilTrue(l);
    }

    public boolean isReady() {
        return this.cond.isTrue();
    }

    private void setValue(Object object) {
        this.value = object;
        this.cond.setTrue();
    }

    private void setException(Throwable throwable) {
        this.except = throwable;
        this.cond.setTrue();
    }

    public abstract Object computeValue();

    private class FutureValueThread
    extends Thread {
        FutureValueThread(String string) {
            super(string);
            this.setDaemon(true);
        }

        public void run() {
            try {
                FutureValue.this.setValue(FutureValue.this.computeValue());
            }
            catch (Throwable throwable) {
                FutureValue.this.setException(throwable);
            }
        }
    }
}

