/*
 * Decompiled with CFR 0.152.
 */
package ix.test.xml;

import ix.icore.domain.PatternAssignment;
import ix.util.Debug;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import ix.util.match.SimpleMatcher;
import java.util.LinkedList;
import java.util.List;

public class WorldStateView {
    public static final Symbol TRUE = Symbol.intern("true");
    public static final Symbol EQ = Symbol.intern("=");
    protected String name;
    protected List filterPatterns;
    protected List filters;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List getFilterPatterns() {
        return this.filterPatterns;
    }

    public void setFilterPatterns(List list) {
        this.filterPatterns = list;
        this.filters = this.createFilters(list);
    }

    public List getFilters() {
        return this.filters;
    }

    public boolean isIncluded(PatternAssignment patternAssignment) {
        return this.isIncluded(patternAssignment.getPattern(), patternAssignment.getValue());
    }

    public boolean isIncluded(LList lList, Object object) {
        if (this.filters == null || this.filters.isEmpty()) {
            return true;
        }
        for (Filter filter : this.filters) {
            if (!filter.trueOf(lList, object)) continue;
            return true;
        }
        return false;
    }

    List createFilters(List list) {
        LinkedList<Filter> linkedList = new LinkedList<Filter>();
        LinkedList linkedList2 = new LinkedList();
        for (Object e : list) {
            if (!(e instanceof List)) {
                linkedList2.add(e);
                continue;
            }
            LList lList = LList.LListify((List)e);
            if (!(lList.get(0) instanceof LList)) {
                linkedList2.add(lList);
            }
            if (lList.length() == 1) {
                linkedList.add(new Filter((LList)lList.get(0), TRUE));
                continue;
            }
            if (lList.length() == 3 && lList.get(1) == EQ) {
                linkedList.add(new Filter((LList)lList.get(0), lList.get(2)));
                continue;
            }
            linkedList2.add(lList);
        }
        if (!linkedList2.isEmpty()) {
            Debug.warn("Bad patterns in " + this + ": " + linkedList2);
        }
        return linkedList;
    }

    static class Filter {
        LList patternPattern;
        Object valuePattern;

        Filter(LList lList, Object object) {
            this.patternPattern = lList;
            this.valuePattern = object;
        }

        boolean trueOf(LList lList, Object object) {
            MatchEnv matchEnv = SimpleMatcher.match(this.patternPattern, lList);
            if (matchEnv == null) {
                return false;
            }
            return SimpleMatcher.match(this.valuePattern, object, matchEnv) != null;
        }

        public String toString() {
            return "Filter[" + this.patternPattern + " = " + this.valuePattern + "]";
        }
    }
}

