/*
 * Decompiled with CFR 0.152.
 */
package ix.test.xml;

import ix.icore.Variable;
import ix.icore.domain.End;
import ix.icore.process.PNodeEnd;
import ix.iplan.AutoTester;
import ix.iplan.PlanCheckingSimulator;
import ix.iplan.PlanTest;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.util.List;

public class MissionaryTest
extends PlanTest {
    static final Symbol MOVE = Symbol.intern("move");
    static final Symbol LEFT = Symbol.intern("left");
    static final Symbol RIGHT = Symbol.intern("right");

    public AutoTester.TestRunner makeTestRunner(AutoTester autoTester) {
        return new MissionaryTestRunner(this, autoTester);
    }

    static class MissionaryTestRunner
    extends AutoTester.TestRunner {
        AutoTester auto;
        MissionaryTest test;

        MissionaryTestRunner(MissionaryTest missionaryTest, AutoTester autoTester) {
            AutoTester autoTester2 = autoTester;
            autoTester2.getClass();
            super(missionaryTest);
            this.auto = autoTester;
            this.test = missionaryTest;
        }

        protected void runSimulation(PlanCheckingSimulator planCheckingSimulator) {
            super.runSimulation(planCheckingSimulator);
            this.simulate(planCheckingSimulator.getExecutionOrder());
        }

        void simulate(List list) {
            LList lList = Lisp.elementsFromString("left 3 3 0 0");
            LList lList2 = Lisp.elementsFromString("right 0 0 3 3");
            for (PNodeEnd pNodeEnd : list) {
                LList lList3;
                if (pNodeEnd.getEnd() != End.BEGIN || (lList3 = pNodeEnd.getNode().getPattern()).get(0) != MOVE) continue;
                lList3 = (LList)Variable.removeVars(lList3);
                LList lList4 = (LList)lList3.get(1);
                LList lList5 = (LList)lList3.get(2);
                if (!lList4.equals(lList)) {
                    this.auto.testFailure(this.test, pNodeEnd + " doesn't move from " + lList);
                }
                lList = this.nextState(lList, lList5);
            }
            this.auto.traceln("Reaches state", lList);
            if (!lList.equals(lList2)) {
                this.auto.testFailure(this.test, "Failed to reach goal state.");
            }
        }

        LList nextState(LList lList, LList lList2) {
            Symbol symbol = (Symbol)lList.get(0);
            int n = ((Long)lList.get(1)).intValue();
            int n2 = ((Long)lList.get(2)).intValue();
            int n3 = ((Long)lList.get(3)).intValue();
            int n4 = ((Long)lList.get(4)).intValue();
            int n5 = ((Long)lList2.get(0)).intValue();
            int n6 = ((Long)lList2.get(1)).intValue();
            if (symbol == LEFT) {
                symbol = RIGHT;
                n -= n5;
                n2 -= n6;
                n3 += n5;
                n4 += n6;
            } else if (symbol == RIGHT) {
                symbol = LEFT;
                n += n5;
                n2 += n6;
                n3 -= n5;
                n4 -= n6;
            } else {
                this.auto.testFailure(this.test, "invalid state " + lList);
            }
            return Lisp.list(symbol, new Long(n), new Long(n2), new Long(n3), new Long(n4));
        }
    }
}

