/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.util.Debug;
import ix.util.FutureValue;
import ix.util.RethrownException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;
import java.util.Set;

public class SecureRandomTest {
    public static void main(String[] stringArray) {
        FutureRandom futureRandom = new FutureRandom();
        futureRandom.start();
        Thread.yield();
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            Debug.noteln(providerArray[i].toString());
            Set<Object> set = providerArray[i].keySet();
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                Debug.noteln("  ", iterator.next());
            }
        }
        Debug.noteln("Random long " + futureRandom.getValue());
    }

    public static class FutureRandom
    extends FutureValue {
        public FutureRandom() {
            super("Get secure random");
        }

        public Object computeValue() {
            try {
                Debug.noteln("Started FutureRandom", this);
                SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                Debug.noteln("Have generator", secureRandom);
                Long l = new Long(secureRandom.nextLong());
                Debug.noteln("Have secure random long", l);
                return l;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RethrownException(noSuchAlgorithmException);
            }
        }
    }
}

