/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.Activity;
import ix.icore.domain.Domain;
import ix.icore.plan.Plan;
import ix.icore.plan.build.SimplePlanBuilder;
import ix.iplan.IPlan;
import ix.iplan.PlanCheckingSimulator;
import ix.iplan.Planner;
import ix.util.Parameters;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.xml.XML;

public class PlanningTest {
    Planner planner;
    Domain domain;

    public PlanningTest() {
        this.setup();
    }

    public static void main(String[] stringArray) {
        Parameters.processCommandLineArguments(stringArray);
        PlanningTest planningTest = new PlanningTest();
        planningTest.findPlan();
        while (true) {
            planningTest.checkPlan();
            if (Util.askLine("Replan?").trim().startsWith("y")) {
                planningTest.replan();
                continue;
            }
            System.exit(0);
        }
    }

    protected void setup() {
        String string = Parameters.getParameter("domain");
        String string2 = Parameters.getParameter("plan");
        String string3 = Parameters.getParameter("task");
        this.planner = IPlan.makeDefaultPlanner();
        if (this.domain != null) {
            this.domain = (Domain)XML.readObject(Domain.class, string);
            this.planner.setDomain(this.domain);
        }
        if (string2 != null) {
            this.planner.loadPlan((Plan)XML.readObject(Plan.class, string2));
        }
        if (string3 != null) {
            this.planner.loadPlan(this.initialPlan(string3));
        }
    }

    Plan initialPlan(String string) {
        SimplePlanBuilder simplePlanBuilder = new SimplePlanBuilder();
        LList lList = Lisp.elementsFromString(string);
        simplePlanBuilder.addActivity(new Activity(lList));
        return simplePlanBuilder.getPlan();
    }

    public void findPlan() {
        this.planner.plan();
    }

    public void replan() {
        this.planner.replan();
    }

    public void checkPlan() {
        PlanCheckingSimulator planCheckingSimulator = new PlanCheckingSimulator(this.planner.getPlan(), this.domain);
        planCheckingSimulator.run();
        planCheckingSimulator.report();
        planCheckingSimulator.describeChangedWorldState();
    }
}

