/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.domain.End;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.Ordering;
import ix.icore.plan.AbstractPlanItem;
import ix.icore.plan.Plan;
import ix.icore.plan.PlanNode;
import ix.icore.plan.inspect.OrderingVisitor;
import ix.icore.plan.inspect.PlanInspector;
import ix.icore.plan.inspect.PlanItemVisitor;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class OPlanPSGraph {
    public static void main(String[] stringArray) {
        Debug.off();
        Parameters.processCommandLineArguments(stringArray);
        new OPlanPSGraph().run();
    }

    protected void run() {
        Plan plan = (Plan)XML.readObject(Plan.class, Parameters.getParameter("plan"));
        this.outputPlanForOPlan(plan, Parameters.getParameter("output", "-"));
    }

    public void outputPlanForOPlan(Plan plan, String string) {
        if (string.equals("-")) {
            this.outputPlanForOPlan(plan, System.out);
            return;
        }
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.outputPlanForOPlan(plan, printStream);
        }
        catch (IOException iOException) {
            Debug.noteException(iOException);
            throw new RethrownException(iOException);
        }
    }

    public void outputPlanForOPlan(Plan plan, final PrintStream printStream) {
        PlanInspector planInspector = new PlanInspector(plan);
        printStream.println("(");
        planInspector.walkPlanNodes(new PlanItemVisitor(){

            public void visit(AbstractPlanItem abstractPlanItem, AbstractPlanItem abstractPlanItem2, List list) {
                PlanNode planNode = (PlanNode)abstractPlanItem;
                LList lList = OPlanPSGraph.this.nodeToList(planNode);
                printStream.println(Lisp.printToString(lList));
            }
        });
        printStream.println(")");
        printStream.println("(");
        planInspector.walkOrderings(new OrderingVisitor(){

            public void visit(Ordering ordering) {
                LList lList = OPlanPSGraph.this.orderingToList(ordering);
                printStream.println(Lisp.printToString(lList));
            }
        });
        printStream.println(")");
    }

    LList nodeToList(PlanNode planNode) {
        String string = planNode.getId().toString();
        LList lList = planNode.getActivity().getPattern();
        return Lisp.list(string, lList);
    }

    LList orderingToList(Ordering ordering) {
        NodeEndRef nodeEndRef = ordering.getFrom();
        NodeEndRef nodeEndRef2 = ordering.getTo();
        return Lisp.list(Lisp.list(nodeEndRef.getNode().toString(), this.endKeyword(nodeEndRef.getEnd())), Lisp.list(nodeEndRef2.getNode().toString(), this.endKeyword(nodeEndRef2.getEnd())));
    }

    Symbol endKeyword(End end) {
        return Symbol.intern(":" + end.toString());
    }
}

