/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.Activity;
import ix.icore.IXObject;
import ix.icore.Issue;
import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.icore.plan.Plan;
import ix.icore.plan.build.PlanBuilder;
import ix.icore.plan.build.SimplePlanBuilder;
import ix.util.Debug;
import ix.util.MultiHashMap;
import ix.util.MultiMap;
import ix.util.PatternParser;
import ix.util.Strings;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.xml.XML;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;

public class CompendiumToIX {
    static final int LIST = 1;
    static final int MAP = 2;
    static final int ISSUE = 3;
    static final int POSITION = 4;
    static final int ARGUMENT = 5;
    static final int PRO = 6;
    static final int CON = 7;
    static final int DECISION = 8;
    static final int REFERENCE = 9;
    static final int NOTE = 10;
    static final int LIST_SHORTCUT = 11;
    static final int MAP_SHORTCUT = 12;
    static final int ISSUE_SHORTCUT = 13;
    static final int POSITION_SHORTCUT = 14;
    static final int ARGUMENT_SHORTCUT = 15;
    static final int PRO_SHORTCUT = 16;
    static final int CON_SHORTCUT = 17;
    static final int DECISION_SHORTCUT = 18;
    static final int REFERENCE_SHORTCUT = 19;
    static final int NOTE_SHORTCUT = 20;
    static final String K_ID = "compendium-id";
    static final String K_LABEL = "compendium-label";
    static final String K_LINKS = "compendium-links";
    PlanBuilder builder = new SimplePlanBuilder();
    Map CompendiumIdToIXObjectMap = new HashMap();
    MultiMap linkMap = new MultiHashMap();
    List issues = new LinkedList();
    List activities = new LinkedList();
    List constraints = new LinkedList();

    public Document transform(Document document) {
        this.phaseOne(document);
        this.phaseTwo();
        Plan plan = this.builder.getPlan();
        return XML.objectToDocument(plan);
    }

    void phaseOne(Document document) {
        String string;
        Object object;
        Element element = document.getRootElement();
        List list = element.getChild("nodes").getChildren("node");
        List list2 = element.getChild("links").getChildren("link");
        for (Element element2 : list) {
            object = this.makeIXObject(element2);
            if (object == null) continue;
            string = this.getCompendiumId(element2);
            this.CompendiumIdToIXObjectMap.put(string, object);
        }
        for (Element element2 : list2) {
            object = element2.getAttributeValue("from");
            string = element2.getAttributeValue("to");
            IXObject iXObject = this.IXObjectForId((String)object);
            IXObject iXObject2 = this.IXObjectForId(string);
            if (iXObject == null || iXObject2 == null) continue;
            this.linkMap.addValue(iXObject, new Link(iXObject, iXObject2));
        }
    }

    Object makeIXObject(Element element) {
        switch (this.getCompendiumType(element)) {
            case 3: {
                Issue issue = this.makeIXIssue(element);
                this.issues.add(issue);
                return issue;
            }
            case 8: {
                Activity activity = this.makeIXActivity(element);
                this.activities.add(activity);
                return activity;
            }
            case 5: {
                Constraint constraint = this.makeIXConstraint(element);
                this.constraints.add(constraint);
                return constraint;
            }
        }
        return null;
    }

    Issue makeIXIssue(Element element) {
        Issue issue = new Issue(this.patternFromCompendiumNode(element));
        this.addNodeAnnotations(issue, element);
        return issue;
    }

    Activity makeIXActivity(Element element) {
        Activity activity = new Activity(this.patternFromCompendiumNode(element));
        this.addNodeAnnotations(activity, element);
        return activity;
    }

    Constraint makeIXConstraint(Element element) {
        LList lList = this.patternFromCompendiumNode(element);
        Constraint constraint = new Constraint("world-state", "effect", (List)Lisp.list(new PatternAssignment(lList)));
        this.addNodeAnnotations(constraint, element);
        return constraint;
    }

    LList patternFromCompendiumNode(Element element) {
        String string = element.getAttributeValue("label");
        return this.patternFromText(string == null ? "no pattern" : string);
    }

    LList patternFromText(String string) {
        try {
            return PatternParser.parse(string);
        }
        catch (Exception exception) {
            Debug.noteln("Trouble reading " + Strings.quote(string) + " because " + Debug.describeException(exception));
            return LList.newLList(Strings.breakAt(" ", string));
        }
    }

    void addNodeAnnotations(IXObject iXObject, Element element) {
        iXObject.setAnnotation(K_ID, this.getCompendiumId(element));
    }

    int getCompendiumType(Element element) {
        String string = element.getAttributeValue("type");
        if (string == null) {
            return -1;
        }
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.noteException(numberFormatException, false);
            return -2;
        }
    }

    String getCompendiumId(Element element) {
        String string = element.getAttributeValue("id");
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Can't get id");
        }
        return string;
    }

    void phaseTwo() {
        Iterator iterator = this.issues.iterator();
        while (iterator.hasNext()) {
            this.addIssueToPlan((Issue)iterator.next());
        }
        iterator = this.activities.iterator();
        while (iterator.hasNext()) {
            this.addActivityToPlan((Activity)iterator.next());
        }
        iterator = this.constraints.iterator();
        while (iterator.hasNext()) {
            this.addConstraintToPlan((Constraint)iterator.next());
        }
    }

    void addIssueToPlan(Issue issue) {
        Issue issue2 = (Issue)this.findParent(issue);
        if (issue2 == null) {
            this.builder.addIssue(issue);
        } else {
            this.builder.addSubissue(issue2, issue);
        }
        this.addLinksAnnotation(issue, this.findParent(issue));
    }

    void addActivityToPlan(Activity activity) {
        Activity activity2 = (Activity)this.findParent(activity);
        if (activity2 == null) {
            this.builder.addActivity(activity);
        } else {
            this.builder.addSubactivity(activity2, activity);
        }
        this.addLinksAnnotation(activity, this.findParent(activity));
    }

    void addConstraintToPlan(Constraint constraint) {
        this.builder.addConstraint(constraint);
        this.addLinksAnnotation(constraint, null);
    }

    IXObject findParent(IXObject iXObject) {
        List list = this.objectsLinkedFrom(iXObject, iXObject.getClass());
        if (list.size() > 0) {
            return (IXObject)list.get(0);
        }
        return null;
    }

    void addLinksAnnotation(IXObject iXObject, IXObject iXObject2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Link link : this.getLinks(iXObject)) {
            IXObject iXObject3 = link.getTo();
            if (iXObject3 == iXObject2) continue;
            String string = "related-to " + Strings.afterLast(".", iXObject3.getClass().getName()) + " " + iXObject3.getAnnotation(K_ID);
            linkedList.add(string);
        }
        if (!linkedList.isEmpty()) {
            iXObject.setAnnotation(K_LINKS, linkedList);
        }
    }

    IXObject IXObjectForId(String string) {
        Debug.expect(string != null, "Null id");
        Debug.expect(!string.equals(""), "Empty id");
        return (IXObject)this.CompendiumIdToIXObjectMap.get(string);
    }

    List getLinks(IXObject iXObject) {
        List list = (List)this.linkMap.get(iXObject);
        return list == null ? new LinkedList() : list;
    }

    List objectsLinkedFrom(IXObject iXObject) {
        return this.objectsLinkedFrom(iXObject, Object.class);
    }

    List objectsLinkedFrom(IXObject iXObject, Class clazz) {
        LinkedList<IXObject> linkedList = new LinkedList<IXObject>();
        for (Link link : this.getLinks(iXObject)) {
            IXObject iXObject2 = link.getTo();
            if (!clazz.isInstance(iXObject2)) continue;
            linkedList.add(iXObject2);
        }
        return linkedList;
    }

    public static void main(String[] stringArray) throws Exception {
        Debug.off();
        if (stringArray.length < 1) {
            System.out.println("Args are: file-to-transform");
            return;
        }
        String string = stringArray[0];
        Document document = XML.parseXML(new File(string));
        Document document2 = new CompendiumToIX().transform(document);
        XML.makePrettyXMLOutputter().output(document2, (OutputStream)System.out);
    }

    class Link {
        IXObject from;
        IXObject to;

        Link(IXObject iXObject, IXObject iXObject2) {
            this.from = iXObject;
            this.to = iXObject2;
        }

        IXObject getFrom() {
            return this.from;
        }

        IXObject getTo() {
            return this.to;
        }
    }
}

