/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.table;

import ix.icore.domain.Constraint;
import ix.icore.domain.ObjectProperty;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.iface.domain.SyntaxException;
import ix.iface.ui.NamedRenderer;
import ix.iface.ui.table.AbstractIXTableModel;
import ix.iface.ui.table.IXTable;
import ix.iview.NodeNameRenderer;
import ix.iview.PropertyConstraintsListener;
import ix.iview.domain.UIObjectClass;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.table.TableColumn;

public class PropertyTableModel
extends AbstractIXTableModel
implements FocusListener {
    public static Symbol REL_DEFAULT = Refinement.S_EFFECT;
    String[] columns = new String[]{"Property", "Value", "Syntax", "At Node", "Relation", "Own"};
    Class[] classes = new Class[]{ObjectProperty.class, String.class, ObjectProperty.Syntax.class, Symbol.class, Symbol.class, Boolean.class};
    private HashMap propertyConstraints = new HashMap();
    JComboBox propertyBox;
    UIObjectClass objectClass;
    ItemVar variable;
    int mode;
    public int PROP_COL = 0;
    public int VALUE_COL = 1;
    public int SYNTAX_COL = 2;
    public int NODE_COL = 3;
    public int EFF_COL = 4;
    public int OWN_COL = 5;
    HashSet propConstrsListeners = new HashSet();

    public PropertyTableModel() {
        super(false);
        this.setColumnNames(this.columns);
        this.setColumnClasses(this.classes);
    }

    public JComboBox setupPropertyBox() {
        this.propertyBox = new JComboBox();
        this.propertyBox.addItem(" ");
        this.propertyBox.setRenderer(new NamedRenderer(false));
        this.propertyBox.setEditable(true);
        return this.propertyBox;
    }

    public void adjustTable(IXTable iXTable) {
        iXTable.setPreferredScrollableViewportSize(new Dimension(500, 120));
        iXTable.setWidth(Boolean.class, new Integer(35));
        TableColumn tableColumn = iXTable.getColumnModel().getColumn(this.OWN_COL);
        tableColumn.setResizable(false);
        tableColumn.setPreferredWidth(35);
        tableColumn.setMaxWidth(35);
        tableColumn.setMinWidth(35);
        iXTable.doLayout();
        tableColumn = iXTable.getColumnModel().getColumn(this.NODE_COL);
        tableColumn.setCellRenderer(new NodeNameRenderer(false));
        tableColumn = iXTable.getColumnModel().getColumn(this.EFF_COL);
        JComboBox<Symbol> jComboBox = new JComboBox<Symbol>();
        jComboBox.addItem(Refinement.S_CONDITION);
        jComboBox.addItem(Refinement.S_EFFECT);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        jComboBox.setSelectedItem(REL_DEFAULT);
        tableColumn = iXTable.getColumnModel().getColumn(this.PROP_COL);
        tableColumn.setPreferredWidth(100);
        JComboBox jComboBox2 = this.setupPropertyBox();
        tableColumn.setCellRenderer(new NamedRenderer(false));
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox2);
        tableColumn.setCellEditor(defaultCellEditor);
    }

    public void clear() {
        this.variable = null;
        this.setObjectClass(null);
    }

    public void setConstraints(ItemVar itemVar, UIObjectClass uIObjectClass, HashMap hashMap) {
        if (itemVar != null && !itemVar.equals(this.variable)) {
            this.noteOldConstraints();
            this.variable = itemVar;
        }
        if (uIObjectClass != null) {
            this.objectClass = uIObjectClass;
            this.updatePropertyBox();
        }
        this.propertyConstraints = hashMap != null ? new HashMap(hashMap) : new HashMap();
        this.refreshProperties();
    }

    public void setObjectClass(UIObjectClass uIObjectClass) {
        this.objectClass = uIObjectClass;
        this.updatePropertyBox();
        this.refreshProperties();
    }

    public void setConstraints(HashMap hashMap) {
        this.propertyConstraints = hashMap != null ? new HashMap(hashMap) : new HashMap();
        this.refreshProperties();
    }

    public void setMode(int n) {
        this.mode = n;
        this.refreshProperties();
    }

    private void clearPropertyBox() {
        this.propertyBox.removeAllItems();
    }

    protected List refreshProperties() {
        List list = this.getPropertyConstraints();
        this.setData(list.toArray());
        return list;
    }

    public void updatePropertyBox() {
        HashSet hashSet;
        this.propertyBox.removeAllItems();
        if (this.objectClass != null && (hashSet = this.objectClass.getAllProperties()) != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.propertyBox.addItem(iterator.next());
            }
        }
    }

    private HashMap filterPropertyConstraints(Map map, Collection collection) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap(map);
        if (collection != null) {
            for (Object e : collection) {
                Object v = map.get((ObjectProperty)e);
                if (v == null) continue;
                hashMap.put(e, v);
                hashMap2.remove(e);
            }
        }
        return hashMap;
    }

    public Object getCellValueAt(Object object, int n) {
        Constraint constraint = (Constraint)object;
        if (IVUtil.isEmptyConstraint(constraint)) {
            return null;
        }
        if (n == this.PROP_COL) {
            return IVUtil.propertyFromPattern((List)constraint.getPattern(), this.objectClass);
        }
        if (n == this.SYNTAX_COL) {
            ObjectProperty objectProperty = IVUtil.propertyFromPattern((List)constraint.getPattern(), this.objectClass);
            if (objectProperty == null) {
                return "";
            }
            return objectProperty.getSyntax();
        }
        if (n == this.OWN_COL) {
            if (this.objectClass == null) {
                return new Boolean(true);
            }
            ObjectProperty objectProperty = IVUtil.propertyFromPattern((List)constraint.getPattern(), this.objectClass);
            return new Boolean(this.objectClass.isOwnProperty(objectProperty));
        }
        if (n == this.VALUE_COL) {
            return constraint.getValue();
        }
        if (n == this.NODE_COL) {
            return Symbol.intern("self");
        }
        if (n == this.EFF_COL) {
            if (constraint.getRelation() == null) {
                constraint.setRelation(REL_DEFAULT);
            }
            return constraint.getRelation();
        }
        return "";
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == this.VALUE_COL || n2 == this.EFF_COL || n2 == this.NODE_COL) {
            return true;
        }
        return n == this.getRowCount() - 1 && (n2 == this.PROP_COL || n2 == this.SYNTAX_COL);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == this.OWN_COL || n2 == this.SYNTAX_COL) {
            return;
        }
        Object object2 = this.getRowObject(n);
        try {
            Constraint constraint = (Constraint)((Constraint)object2).clone();
            if (n2 == this.EFF_COL) {
                if (IVUtil.isEmptyConstraint(constraint)) {
                    this.complainEmpty();
                    return;
                }
                constraint.setRelation((Symbol)object);
            } else if (n2 == this.VALUE_COL) {
                if (IVUtil.isEmptyConstraint(constraint)) {
                    this.complainEmpty();
                    return;
                }
                IVUtil.setConstraintValue(constraint, object);
            } else if (n2 == this.PROP_COL) {
                AbstractList abstractList;
                ObjectProperty objectProperty;
                if (object == null || object.equals("") || object.equals(" ")) {
                    return;
                }
                if (this.variable == null) {
                    String[] stringArray = new String[]{"Please specify a variable name first", "(Nothing done)"};
                    JOptionPane.showMessageDialog(null, stringArray);
                    return;
                }
                if (constraint.getRelation() == null) {
                    constraint.setRelation(REL_DEFAULT);
                }
                if (constraint.getType() == null) {
                    constraint.setType(Refinement.S_WORLD_STATE);
                }
                if (object instanceof ObjectProperty) {
                    objectProperty = (ObjectProperty)object;
                } else {
                    abstractList = new ArrayList<Object>();
                    abstractList.add(object);
                    objectProperty = IVUtil.propertyFromPattern(abstractList, this.objectClass);
                }
                if (objectProperty == null) {
                    objectProperty = this.defineNewProperty(object);
                }
                if (objectProperty != null) {
                    abstractList = Lisp.list(objectProperty.getName(), this.variable);
                    PatternAssignment patternAssignment = new PatternAssignment((LList)abstractList, "");
                    constraint.setParameters(Lisp.list(patternAssignment));
                    if (constraint == null) {
                        String string = objectProperty.getName().toString() + " " + this.variable.toString();
                        throw new SyntaxException("Invalid constraint: " + Strings.quote(string));
                    }
                    this.addConstraint(objectProperty, constraint);
                    this.refreshProperties();
                    return;
                }
                return;
            }
            this.replaceConstraint((Constraint)object2, constraint);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
        this.refreshProperties();
    }

    private List getPropertyConstraints() {
        LinkedList linkedList;
        HashSet hashSet;
        HashMap hashMap;
        LinkedList<Constraint> linkedList2 = new LinkedList<Constraint>();
        if (this.objectClass != null && (hashMap = this.filterPropertyConstraints(this.propertyConstraints, hashSet = this.objectClass.getAllProperties())) != null && (linkedList = new LinkedList(hashMap.values())) != null) {
            for (Collection collection : linkedList) {
                linkedList2.addAll(collection);
            }
        }
        linkedList2.add(new Constraint());
        return linkedList2;
    }

    private ObjectProperty defineNewProperty(Object object) {
        if (this.objectClass == null) {
            JOptionPane.showMessageDialog(null, "The current object class is not valid");
            return null;
        }
        List list = ObjectProperty.Syntax.values();
        String[] stringArray = new String[]{"Please set the syntax for the new property", "Cancel if you did not intend to define", "a new property for type" + this.objectClass};
        Object object2 = JOptionPane.showInputDialog(null, stringArray, "Property Syntax Input", 1, null, list.toArray(), ObjectProperty.Syntax.DEFAULT);
        if (object2 == null) {
            return null;
        }
        ObjectProperty objectProperty = new ObjectProperty();
        objectProperty.setName(Symbol.intern(object.toString()));
        objectProperty.setSyntax(ObjectProperty.Syntax.valueOf(object2.toString()));
        this.objectClass.addProperty(objectProperty);
        this.updatePropertyBox();
        objectProperty = IVUtil.propertyFromString(object.toString(), this.objectClass);
        return objectProperty;
    }

    private void complainEmpty() {
        String[] stringArray = new String[]{"Please use column " + (this.PROP_COL + 1), "to enter a property to constrain first.", "(Nothing done)"};
        JOptionPane.showMessageDialog(null, stringArray);
    }

    private void addConstraint(ObjectProperty objectProperty, Constraint constraint) {
        this.propertyConstraints = PropertyTableModel.noteProperty(this.propertyConstraints, this.objectClass, objectProperty, constraint);
    }

    private void replaceConstraintData(Constraint constraint, Constraint constraint2) {
        this.replaceData(constraint, constraint2);
    }

    private void replaceConstraint(Constraint constraint, Constraint constraint2) {
        if (constraint != null && constraint.equals(constraint2)) {
            return;
        }
        ObjectProperty objectProperty = IVUtil.propertyFromPattern((List)constraint.getPattern(), this.objectClass);
        Object v = this.propertyConstraints.get(objectProperty);
        if (v != null && v instanceof Set) {
            Set set = (Set)v;
            Set set2 = IVUtil.removeConstraint(set, constraint);
            set2.add(constraint2);
            this.propertyConstraints.put(objectProperty, set2);
        }
    }

    public static HashMap noteProperty(HashMap hashMap, UIObjectClass uIObjectClass, ObjectProperty objectProperty, Constraint constraint) {
        Object v = hashMap.get(objectProperty);
        if (v == null) {
            HashSet<Constraint> hashSet = new HashSet<Constraint>();
            hashSet.add(constraint);
            hashMap.put(objectProperty, hashSet);
            return hashMap;
        }
        Set set = (Set)v;
        return PropertyTableModel.noteConstraint(hashMap, uIObjectClass, set, objectProperty, constraint);
    }

    private static HashMap noteConstraint(HashMap hashMap, UIObjectClass uIObjectClass, Set hashSet, ObjectProperty objectProperty, Constraint constraint) {
        if (hashSet != null && !hashSet.isEmpty()) {
            HashSet hashSet2 = new HashSet(hashSet);
            for (Constraint constraint2 : hashSet2) {
                String string;
                if (!IVUtil.sameObjectConstraint(constraint, constraint2)) continue;
                String string2 = objectProperty.getName() + " = " + constraint2.getValue();
                if (string2.equals(string = objectProperty.getName() + " = " + constraint.getValue())) {
                    return hashMap;
                }
                Symbol symbol = Refinement.S_CONDITION;
                String string3 = "a";
                if (constraint.getRelation() == Refinement.S_CONDITION) {
                    symbol = Refinement.S_EFFECT;
                } else {
                    string3 = "an";
                }
                Object[] objectArray = new String[]{"overwrite old constraint (" + string2 + ")", "change new constraint (" + string + ") to " + symbol, "change old constraint (" + string2 + ") to " + symbol, "forget new constraint (" + string + ") i.e. Cancel"};
                String[] stringArray = new String[]{"There already is " + string3 + " " + constraint.getRelation() + " for property " + objectProperty.getName() + ":", objectProperty.getName() + " = " + constraint2.getValue(), "Do you want to..."};
                Object object = JOptionPane.showInputDialog(null, stringArray, "Options", 1, null, objectArray, objectArray[0]);
                if (object == null || object.equals(objectArray[3])) {
                    return hashMap;
                }
                if (object.equals(objectArray[0])) {
                    IVUtil.setConstraintValue(constraint2, constraint.getValue());
                    return hashMap;
                }
                if (object.equals(objectArray[1])) {
                    constraint.setRelation(symbol);
                    return PropertyTableModel.noteConstraint(hashMap, uIObjectClass, hashSet, objectProperty, constraint);
                }
                if (!object.equals(objectArray[2])) continue;
                hashSet.remove(constraint2);
                hashSet.add(constraint);
                hashMap.put(objectProperty, hashSet);
                constraint2.setRelation(symbol);
                return PropertyTableModel.noteProperty(hashMap, uIObjectClass, objectProperty, constraint2);
            }
        } else {
            hashSet = new HashSet<Constraint>();
        }
        hashSet.add(constraint);
        hashMap.put(objectProperty, hashSet);
        return hashMap;
    }

    public void noteOldConstraints() {
        if (this.variable != null) {
            this.fireConstraintsChanged(this.variable, this.objectClass, this.propertyConstraints);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.noteOldConstraints();
    }

    public void addPropertyConstraintsListener(PropertyConstraintsListener propertyConstraintsListener) {
        this.propConstrsListeners.add(propertyConstraintsListener);
    }

    private void fireConstraintsChanged(ItemVar itemVar, UIObjectClass uIObjectClass, HashMap hashMap) {
        if (this.propConstrsListeners != null) {
            for (PropertyConstraintsListener propertyConstraintsListener : this.propConstrsListeners) {
                propertyConstraintsListener.variableConstraintsChanged(itemVar, hashMap);
            }
        }
    }
}

