/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.domain;

import ix.icore.AbstractAnnotatedObject;
import ix.icore.Annotations;
import ix.icore.IXObject;
import ix.icore.domain.Domain;
import ix.icore.domain.LinkedListOfObjectClass;
import ix.icore.domain.LinkedListOfRefinement;
import ix.icore.domain.ListOfRefinement;
import ix.icore.domain.Named;
import ix.icore.domain.ObjectClass;
import ix.icore.domain.ObjectProperty;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainEvent;
import ix.icore.domain.event.DomainListener;
import ix.icore.domain.event.RefinementEvent;
import ix.iface.domain.DomainParser;
import ix.iface.domain.DomainWriter;
import ix.iface.domain.SyntaxException;
import ix.iface.ui.event.DataChangeListener;
import ix.iface.ui.util.UIUtil;
import ix.iview.AbstractSetEditor;
import ix.iview.DomainEditor;
import ix.iview.DomainObjectManager;
import ix.iview.UIObjectClassSetEditor;
import ix.iview.UIRefinementSetEditor;
import ix.iview.domain.UIGrammar;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIObjectClass;
import ix.iview.domain.UIRefinement;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.iview.tree.ObjectClassTreeModel;
import ix.iview.tree.ObjectClassTreeNode;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Symbol;
import ix.util.match.SimpleMatcher;
import java.awt.Cursor;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;

public class UIDomain
extends AbstractAnnotatedObject
implements UIObject,
Named,
DomainListener,
DomainObjectManager {
    public UIGrammar grammar;
    public String name = "Undefined";
    public Annotations annotations;
    private Domain currentDomain;
    private Domain draftDomain = new Domain();
    private File domainFile;
    private Domain saving = null;
    private boolean loading = false;
    protected String baseReference = "";
    public HashMap graphs = new HashMap();
    private DomainEditor editor;
    private UIRefinementSetEditor refSetEditor;
    private UIObjectClassSetEditor classSetEditor;
    private HashMap properties = new HashMap();
    private HashSet listeners = new HashSet();
    HashSet dataChangeListeners = new HashSet();

    public UIDomain(Domain domain, DomainEditor domainEditor) {
        this.editor = domainEditor;
        this.setCurrentDomain(domain);
        this.grammar = new UIGrammar();
    }

    public UIDomain(DomainEditor domainEditor) {
        this(new Domain(), domainEditor);
    }

    public UIDomain(String string, DomainEditor domainEditor) {
        this(new Domain(), domainEditor);
        this.name = string;
    }

    public void setCurrentDomain(Domain domain) {
        this.clear();
        this.currentDomain = domain;
        this.draftDomain = this.cloneDomain(this.currentDomain, this.draftDomain);
        this.refSetEditor = new UIRefinementSetEditor(this, (LinkedList)((Object)domain.getRefinements()));
        this.collectProperties(domain);
        this.classSetEditor = new UIObjectClassSetEditor(this, (LinkedList)((Object)domain.getObjectClasses()));
        this.setBaseReference(this.currentDomain.getName());
        this.currentDomain.addDomainListener(this);
        this.loadFromDomain();
    }

    public void noteSetEditor(AbstractSetEditor abstractSetEditor) {
        if (abstractSetEditor instanceof UIRefinementSetEditor) {
            this.refSetEditor = (UIRefinementSetEditor)abstractSetEditor;
        } else if (abstractSetEditor instanceof UIObjectClassSetEditor) {
            this.classSetEditor = (UIObjectClassSetEditor)abstractSetEditor;
        } else {
            Debug.noteln("Cannot note set editor of class", abstractSetEditor.getClass());
        }
    }

    public void ensureConstruct(UIObject uIObject) {
        if (uIObject instanceof UIRefinement) {
            this.refSetEditor.ensureConstruct(uIObject);
        } else if (uIObject instanceof UIObjectClass) {
            this.classSetEditor.ensureConstruct(uIObject);
        } else {
            Debug.noteln("Cannot ensure construct of class", uIObject.getClass());
        }
    }

    public boolean addConstruct(UIObject uIObject) {
        if (uIObject instanceof UIRefinement) {
            return this.refSetEditor.addConstruct(uIObject);
        }
        if (uIObject instanceof UIObjectClass) {
            return this.classSetEditor.addConstruct(uIObject);
        }
        Debug.noteln("Cannot add construct of class", uIObject.getClass());
        return false;
    }

    public void updateConstruct(UIObject uIObject) {
        if (this.equals(uIObject)) {
            this.saveToDomain();
        } else if (uIObject instanceof UIRefinement) {
            this.refSetEditor.updateConstruct(uIObject);
        } else if (uIObject instanceof UIObjectClass) {
            this.classSetEditor.updateConstruct(uIObject);
        } else {
            Debug.noteln("Cannot update construct of class", uIObject.getClass());
        }
    }

    public void removeConstruct(Named named) {
        if (named instanceof UIRefinement) {
            this.refSetEditor.removeConstruct(named);
        } else if (named instanceof UIObjectClass) {
            this.classSetEditor.removeConstruct(named);
        } else {
            Debug.noteln("Cannot remove construct of class", named.getClass());
        }
    }

    public void changeName(Object object, String string) {
        if (string == null || string.trim().equals("")) {
            if (object instanceof UIObjectClass) {
                ((UIObjectClass)object).setLegalName(string);
            } else if (object instanceof UIRefinement) {
                ((UIRefinement)object).setLegalName(string);
            }
        } else if (object instanceof UIRefinement) {
            Object object2 = this.getNamedRefinement(string);
            if (object2 != null && !object2.equals(object) && !object2.equals(((UIObject)object).getBaseObject())) {
                this.refSetEditor.handleNameClash((UIObject)object, string, object2);
            } else {
                ((UIRefinement)object).setLegalName(string);
            }
        } else if (object instanceof UIObjectClass) {
            Object object3 = this.getNamedObjectClass(string);
            if (object3 != null && !object3.equals(object)) {
                this.classSetEditor.handleNameClash((UIObject)object, string, (UIObject)object3);
            } else {
                ((UIObjectClass)object).setLegalName(string);
            }
        } else {
            Debug.noteln("Cannot change name for construct of class", object.getClass());
        }
    }

    public Domain getDomain() {
        return this.currentDomain;
    }

    public UIDomain getUIDomain() {
        return this;
    }

    public boolean hasOriginal() {
        return this.currentDomain != null;
    }

    public IXObject getBaseObject() {
        return this.draftDomain;
    }

    public IXObject makeBaseObject() {
        return new Domain();
    }

    public void setBaseObject(IXObject iXObject) {
        this.currentDomain = (Domain)iXObject;
    }

    public Object getBaseReference() {
        return this.baseReference;
    }

    public void setBaseReference(Object object) {
        this.baseReference = (String)object;
    }

    public Class getBaseClass() {
        return Domain.class;
    }

    public boolean isUndefined() {
        return !(this.name != null && !this.name.equals("") && !this.name.equals("Undefined") && !this.name.equals("undefined") || this.refSetEditor != null && !this.refSetEditor.isEmpty() || this.classSetEditor != null && !this.classSetEditor.isEmpty() || this.getAnnotations() != null && !this.getAnnotations().isEmpty());
    }

    public boolean isEmpty() {
        return this.refSetEditor.isEmpty() && this.refSetEditor.isEmpty() && (this.currentDomain == null || this.currentDomain.isEmpty());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotations annotations) {
        this.annotations = annotations;
    }

    public List collectChanges() {
        return this.collectChanges((Domain)this.getBaseObject(), "draft");
    }

    public List collectChangesFromOriginal() {
        return this.collectChanges(this.currentDomain, "published");
    }

    public List collectChanges(Domain domain) {
        return this.collectChanges(domain, "old");
    }

    public List collectChanges(Domain domain, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!(this.name != "" && this.name != null || this.annotations != null || domain != null && !domain.isEmpty())) {
            return arrayList;
        }
        if (domain == null) {
            arrayList.add("The " + string + "domain is empty, this is panel not:");
            arrayList.add("  " + this.print());
            return arrayList;
        }
        if (this.nameHasChanged(domain.getName())) {
            arrayList.add("Name has changed from " + domain.getName() + " to " + this.getName());
        }
        if (this.annotations == null && domain.getAnnotations() != null || this.annotations != null && !this.annotations.equals(domain.getAnnotations())) {
            arrayList.add("Annotations have changed from " + domain.getAnnotations() + " to " + this.getAnnotations());
        }
        return arrayList;
    }

    public boolean hasChanged(Domain domain) {
        if (!(this.name != "" && this.name != null || this.annotations != null || domain != null && !domain.isEmpty())) {
            return false;
        }
        if (domain == null) {
            Debug.noteln("UID has changed: was empty, not now");
            return true;
        }
        if (!this.nameHasChanged(domain.getName())) {
            if (this.annotations == null && domain.getAnnotations() == null || this.annotations != null && this.annotations.equals(domain.getAnnotations())) {
                return false;
            }
            Debug.noteln("UID has changed annotations from", domain.getAnnotations());
            Debug.noteln(" to", this.getAnnotations());
            return true;
        }
        Debug.note("UID has changed name from " + domain.getName());
        Debug.noteln(" to", this.name + ".");
        return true;
    }

    public boolean hasChanged() {
        return this.hasChanged(this.draftDomain);
    }

    public boolean hasChangedFromOriginal() {
        return this.hasChanged(this.currentDomain);
    }

    public boolean nameHasChanged(Object object) {
        String string = (String)object;
        return (this.name != null && !this.name.equals("") || string != null && !string.equals("")) && (this.name == null || !this.name.equals(string));
    }

    public boolean setValue(String string, Object object) {
        try {
            Field field = UIUtil.stringToField(this.getClass(), string);
            field.set(this, object);
            return true;
        }
        catch (Exception exception) {
            Debug.describeException(exception);
            return false;
        }
    }

    public boolean sameValue(String string, Object object, Object object2) {
        if (string == null) {
            return false;
        }
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public void saveToDomain() {
        if (this.currentDomain == null) {
            this.currentDomain = (Domain)this.makeBaseObject();
        }
        if (this.draftDomain == null) {
            this.draftDomain = this.cloneDomain(this.currentDomain, this.draftDomain);
        }
        this.saveToDomain(this.draftDomain);
    }

    public void saveToDomain(Object object) {
        Domain domain = (Domain)object;
        domain.setName(this.name);
        if (this.annotations == null) {
            domain.setAnnotations(null);
        } else {
            domain.setAnnotations(new Annotations(this.annotations));
        }
    }

    public void loadFromDomain() {
        this.loadFromDomain(this.draftDomain);
    }

    public void loadFromDomain(Object object) {
        if (object == null) {
            this.clearThis();
        } else {
            this.name = ((Domain)object).getName();
            this.annotations = ((Domain)object).getAnnotations();
            if (this.annotations != null) {
                this.annotations = new Annotations(this.annotations);
            }
        }
        this.fireDomainEdited();
    }

    public void loadFromOriginal() {
        this.loadFromDomain(this.currentDomain);
    }

    public void addToDomain(Domain domain) {
    }

    public void updateInDomain(Domain domain) {
    }

    public void removeFromDomain(Domain domain) {
    }

    public void moveToUIDomain(UIDomain uIDomain) {
    }

    public void noteChange() {
    }

    public boolean hasChangedAll() {
        return this.hasChangedAll(this.draftDomain);
    }

    public boolean hasChangedAllFromOriginal() {
        return this.hasChangedAll(this.currentDomain);
    }

    public boolean hasChangedConstructsFromOriginal() {
        return this.refSetEditor.hasChangedConstructs() || this.classSetEditor.hasChangedConstructs();
    }

    private void setSaving(Domain domain) {
        this.saving = domain;
    }

    private void unsetSaving() {
        this.saving = null;
    }

    public boolean isSaving(Domain domain) {
        return domain.equals(this.saving);
    }

    public boolean isSaving() {
        return this.saving != null;
    }

    public boolean hasChangedAll(Domain domain) {
        return this.hasChanged(domain) || this.refSetEditor.hasChangedConstructs() || this.classSetEditor.hasChangedConstructs();
    }

    public List collectAllChanges() {
        return this.collectAllChanges(this.currentDomain);
    }

    public List collectAllChanges(Domain domain) {
        List list;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.hasChanged(domain)) {
            arrayList.add("Changes in the domain's own specifications:");
            arrayList.addAll(this.collectChanges(domain));
        }
        if ((list = this.refSetEditor.collectConstructChanges()) != null && !list.isEmpty()) {
            if (arrayList.size() > 0) {
                arrayList.add(UIUtil.lineSeparator);
            }
            arrayList.addAll(list);
        }
        if ((list = this.classSetEditor.collectConstructChanges()) != null && !list.isEmpty()) {
            if (arrayList.size() > 0) {
                arrayList.add(UIUtil.lineSeparator);
            }
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public UIObject newUIObject(IXObject iXObject) {
        if (iXObject == null) {
            return null;
        }
        if (iXObject instanceof Domain) {
            UIDomain uIDomain = new UIDomain((Domain)iXObject, this.editor);
            this.addedObject(uIDomain, iXObject);
            return uIDomain;
        }
        if (iXObject instanceof Refinement) {
            return (UIObject)this.refSetEditor.newOwnObject(iXObject);
        }
        if (iXObject instanceof ObjectClass) {
            return (UIObject)this.classSetEditor.newOwnObject(iXObject);
        }
        return null;
    }

    public List getAllRefinements() {
        return this.refSetEditor.getAllConstructs();
    }

    public List getAllObjectClasses() {
        return this.classSetEditor.getAllConstructs();
    }

    public boolean hasObjectSystem() {
        List list = this.getAllObjectClasses();
        if (list == null) {
            return false;
        }
        if (list.isEmpty()) {
            return false;
        }
        return list.size() != 1;
    }

    public boolean hasRefinements() {
        List list = this.getAllRefinements();
        if (list == null) {
            return false;
        }
        if (list.isEmpty()) {
            return false;
        }
        return list.size() != 1;
    }

    public List getObjectClassTree() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        ObjectClassTreeNode objectClassTreeNode = new ObjectClassTreeNode(new UIObjectClass(this, "Dummy Root"));
        ObjectClassTreeModel objectClassTreeModel = new ObjectClassTreeModel(this, objectClassTreeNode);
        objectClassTreeModel.reloadData();
        Object object = objectClassTreeModel.getRoot();
        if (object != null && object instanceof ObjectClassTreeNode) {
            ObjectClassTreeNode objectClassTreeNode2 = (ObjectClassTreeNode)object;
            Enumeration<TreeNode> enumeration = objectClassTreeNode2.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = enumeration.nextElement();
                linkedList.add(0, ((ObjectClassTreeNode)treeNode).getUserObject());
            }
        }
        return linkedList;
    }

    public UIObjectClass getObjectClassRoot() {
        LinkedList linkedList = new LinkedList();
        ObjectClassTreeNode objectClassTreeNode = new ObjectClassTreeNode(new UIObjectClass(this, "Dummy Root"));
        ObjectClassTreeModel objectClassTreeModel = new ObjectClassTreeModel(this, objectClassTreeNode);
        objectClassTreeModel.reloadData();
        Object object = objectClassTreeModel.getRoot();
        return this.rootToUIOC(object);
    }

    private UIObjectClass rootToUIOC(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof UIObjectClass) {
            return (UIObjectClass)object;
        }
        if (object instanceof ObjectClassTreeNode) {
            return this.rootToUIOC(((ObjectClassTreeNode)object).getUserObject());
        }
        Debug.noteln("UID: found root of odd class", object.getClass());
        return null;
    }

    public Object getNamedRefinement(String string) {
        return this.refSetEditor.getNamedObject(string);
    }

    public Object getNamedObjectClass(String string) {
        return this.classSetEditor.getNamedObject(string);
    }

    public UIObject getUIObject(IXObject iXObject) {
        if (iXObject == null) {
            return null;
        }
        if (iXObject.equals(this.currentDomain)) {
            return this;
        }
        if (iXObject instanceof Refinement) {
            return (UIObject)this.refSetEditor.getOwnObject(iXObject);
        }
        if (iXObject instanceof ObjectClass) {
            return (UIObject)this.classSetEditor.getOwnObject(iXObject);
        }
        return null;
    }

    public UIObject findUIObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object.equals(this.currentDomain) || object.equals(this.name)) {
            return this;
        }
        if (object instanceof Refinement) {
            return (UIObject)this.refSetEditor.findOwnObject(object);
        }
        if (object instanceof ObjectClass) {
            return (UIObject)this.classSetEditor.findOwnObject(object);
        }
        return null;
    }

    public boolean isCurrentObject(Object object) {
        if (this.refSetEditor.isCurrentOwnObject(object)) {
            return true;
        }
        return this.classSetEditor.isCurrentOwnObject(object);
    }

    public Set getMatchingRefinements(String string) {
        return IVUtil.findNameMatches(string, this.getAllRefinements());
    }

    public Set getMatchingObjectClasses(String string) {
        return IVUtil.findNameMatches(string, this.getAllObjectClasses());
    }

    public Set getMatchingRefinements(LList lList) {
        ListOfRefinement listOfRefinement = this.currentDomain.getRefinements();
        HashSet hashSet = this.refSetEditor.getMatchingUIRefinements(lList, listOfRefinement);
        return hashSet;
    }

    public boolean isMatchingRefinement(LList lList, UIRefinement uIRefinement) {
        if (this.refSetEditor.isCurrentOwnObject(uIRefinement)) {
            return uIRefinement.matchesPattern(lList);
        }
        return false;
    }

    public boolean isMatchingRefinement(LList lList, Refinement refinement) {
        if (lList == null && refinement.getPattern() == null || lList.equal(refinement.getPattern()) || lList.equals(refinement.getPattern())) {
            return true;
        }
        return null != SimpleMatcher.match(lList, refinement.getPattern());
    }

    public void refinementAdded(RefinementEvent refinementEvent) {
        Domain domain = (Domain)refinementEvent.getSource();
        if (!this.isSaving(domain)) {
            this.fireConstructAdded(refinementEvent);
        }
    }

    public void objectClassAdded(DomainEvent domainEvent) {
        Domain domain = (Domain)domainEvent.getSource();
        if (!this.isSaving(domain)) {
            this.fireConstructAdded(domainEvent);
        }
    }

    public void addedObject(UIObject uIObject, IXObject iXObject) {
        if (uIObject == null) {
            return;
        }
        if (uIObject instanceof UIRefinement) {
            this.refSetEditor.addedObject(uIObject, iXObject);
        } else if (uIObject instanceof UIObjectClass) {
            this.classSetEditor.addedObject(uIObject, iXObject);
        }
    }

    private void collectProperties(Domain domain) {
        this.collectProperties(domain.getObjectClasses());
    }

    private void collectProperties(List list) {
        this.properties.clear();
        if (list == null) {
            return;
        }
        for (Object e : list) {
            List list2 = null;
            if (e instanceof ObjectClass) {
                list2 = ((ObjectClass)e).getObjectProperties();
            } else if (e instanceof UIObjectClass) {
                list2 = ((UIObjectClass)e).getObjectProperties();
            }
            if (list2 == null) {
                return;
            }
            for (ObjectProperty objectProperty : list2) {
                this.properties.put(objectProperty.getName(), objectProperty);
            }
        }
    }

    public boolean declareAllVariables() {
        List list = this.getAllRefinements();
        if (list == null) {
            Debug.noteln("UID: declaration - domain has no refinements", "Nothing done.");
            return true;
        }
        String[] stringArray = new String[]{"This will overwrite all declarations of all refinements", "in the domain.", "For each refinement the currently used variables will be", "declared as they are. If you have mis-typed a variable,", "this mistake will appear in the variable declarations.", "Are you sure you want to do this?"};
        int n = JOptionPane.showConfirmDialog(this.editor.deFrame, stringArray, "Warning", 0, 2);
        if (n != 0) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                SequencedCollection sequencedCollection;
                SortedSet sortedSet;
                Object e = iterator.next();
                if (e instanceof Refinement) {
                    sortedSet = ((Refinement)e).getDeclaredVariables();
                    sequencedCollection = ((Refinement)e).getVariablesUsed();
                    if (sortedSet != null && IVUtil.sameSet(sequencedCollection, sortedSet)) continue;
                    UIObject uIObject = this.newUIObject((Refinement)e);
                    List list2 = IVUtil.makeVariableDeclarations(sequencedCollection);
                    ((UIRefinement)uIObject).setVariableDeclarations(list2);
                    continue;
                }
                if (!(e instanceof UIRefinement)) continue;
                sortedSet = ((UIRefinement)e).getVariablesUsed();
                sequencedCollection = IVUtil.makeVariableDeclarations(sortedSet);
                ((UIRefinement)e).setVariableDeclarations((List)sequencedCollection);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
            }
        }
        return true;
    }

    public Collection findVariableUsers(ItemVar itemVar) {
        if (itemVar == null) {
            return null;
        }
        this.fullSaveToDomain(this.draftDomain);
        ListOfRefinement listOfRefinement = this.draftDomain.getRefinements();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = listOfRefinement.iterator();
        while (iterator.hasNext()) {
            try {
                Object e = iterator.next();
                SortedSet sortedSet = ((Refinement)e).getVariablesUsed();
                if (sortedSet == null || !sortedSet.contains(itemVar)) continue;
                arrayList.add(e);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
            }
        }
        return arrayList;
    }

    public Collection findVariableUsers(String string) {
        String string2 = IVUtil.ensureVarName(string);
        if (string2 != "") {
            Symbol symbol = Symbol.intern(string2);
            return this.findVariableUsers((ItemVar)symbol);
        }
        return null;
    }

    public Set findVariablesUsed() {
        this.fullSaveToDomain(this.draftDomain);
        ListOfRefinement listOfRefinement = this.draftDomain.getRefinements();
        HashSet hashSet = new HashSet();
        Iterator iterator = listOfRefinement.iterator();
        while (iterator.hasNext()) {
            try {
                Object e = iterator.next();
                hashSet.addAll(((Refinement)e).getVariablesUsed());
            }
            catch (Exception exception) {
                Debug.noteException(exception);
            }
        }
        return hashSet;
    }

    public void fullSaveToDomain() {
        if (this.currentDomain == null) {
            this.currentDomain = (Domain)this.makeBaseObject();
        }
        if (this.draftDomain == null) {
            this.draftDomain = this.cloneDomain(this.currentDomain, this.draftDomain);
        }
        this.fullSaveToDomain(this.draftDomain);
    }

    public void fullSaveToDomain(Object object) {
        Domain domain = (Domain)object;
        this.setSaving(domain);
        if (domain != this.currentDomain) {
            this.cloneDomain(this.currentDomain, domain);
        }
        domain.setName(this.name);
        Debug.noteln("UID: base domain is", this.currentDomain);
        Debug.noteln("UID: saving to domain", domain);
        Debug.noteln("UID: this domain", this.print());
        this.refSetEditor.saveToDomain(domain);
        this.classSetEditor.saveToDomain(domain);
        this.unsetSaving();
    }

    public void publishToDomain() {
        block3: {
            if (this.currentDomain == null) {
                this.currentDomain = new Domain();
            }
            this.fullSaveToDomain(this.draftDomain);
            try {
                this.draftDomain.checkConsistency();
            }
            catch (SyntaxException syntaxException) {
                String[] stringArray = new String[]{syntaxException.getMessage(), "Listening applications may not be able to handle this.", "Are you sure you want to publish it?"};
                int n = JOptionPane.showConfirmDialog(this.editor.deFrame, stringArray, "Warning", 0, 2);
                if (n == 0) break block3;
                return;
            }
        }
        this.fullSaveToDomain(this.currentDomain);
        this.cloneDomain(this.currentDomain, this.draftDomain);
        this.refSetEditor.resetEdits();
        this.classSetEditor.resetEdits();
    }

    public void revertToOriginal() {
        this.refSetEditor.clear();
        this.classSetEditor.clear();
        this.graphs.clear();
        this.cloneDomain(this.currentDomain, this.draftDomain);
        this.loadFromDomain(this.currentDomain);
        this.fireDomainEdited();
    }

    public void addUIDomainListener(UIDomainListener uIDomainListener) {
        this.listeners.add(uIDomainListener);
    }

    public HashSet getUIDomainListeners() {
        return this.listeners;
    }

    public void setUIDomainListeners(HashSet hashSet) {
        this.listeners = hashSet;
    }

    public void removeUIDomainListener(UIDomainListener uIDomainListener) {
        this.listeners.remove(uIDomainListener);
    }

    public void fireConstructAdded(DomainEvent domainEvent) {
        for (UIDomainListener uIDomainListener : this.listeners) {
            uIDomainListener.constructAdded(domainEvent);
        }
    }

    public void fireConstructAdded(AbstractSetEditor abstractSetEditor, Object object) {
        UIDomainEvent uIDomainEvent = new UIDomainEvent(this, (UIObject)object);
        for (UIDomainListener uIDomainListener : this.listeners) {
            uIDomainListener.constructAdded(uIDomainEvent);
        }
    }

    public void fireConstructEdited(AbstractSetEditor abstractSetEditor, Object object) {
        UIDomainEvent uIDomainEvent = new UIDomainEvent(this, (UIObject)object);
        for (UIDomainListener uIDomainListener : this.listeners) {
            uIDomainListener.constructEdited(uIDomainEvent);
        }
    }

    public void fireConstructRemoved(AbstractSetEditor abstractSetEditor, Object object) {
        UIDomainEvent uIDomainEvent = new UIDomainEvent(this, (UIObject)object);
        for (UIDomainListener uIDomainListener : this.listeners) {
            uIDomainListener.constructRemoved(uIDomainEvent);
        }
    }

    public void fireDomainEdited() {
        UIDomainEvent uIDomainEvent = new UIDomainEvent(this);
        for (UIDomainListener uIDomainListener : this.listeners) {
            uIDomainListener.domainEdited(uIDomainEvent);
        }
    }

    public void fireDomainCleared() {
        UIDomainEvent uIDomainEvent = new UIDomainEvent(this);
        for (UIDomainListener uIDomainListener : this.listeners) {
            uIDomainListener.domainCleared(uIDomainEvent);
        }
    }

    public void fireDomainSet(Domain domain) {
        UIDomainEvent uIDomainEvent = new UIDomainEvent(this);
        for (UIDomainListener uIDomainListener : this.listeners) {
            uIDomainListener.domainSet(uIDomainEvent);
        }
    }

    public void addDataChangeListener(DataChangeListener dataChangeListener) {
        this.dataChangeListeners.add(dataChangeListener);
    }

    public void removeDataChangeListener(DataChangeListener dataChangeListener) {
        this.dataChangeListeners.remove(dataChangeListener);
    }

    private void fireDataChange(String string, Object object, Object object2) {
        if (this.sameValue(string, object, object2)) {
            return;
        }
        for (DataChangeListener dataChangeListener : this.dataChangeListeners) {
            dataChangeListener.dataChanged(this, string, object, object2);
        }
    }

    public void setDomain(Domain domain) {
        if (this.getDomain().equals(domain)) {
            return;
        }
        this.setCurrentDomain(domain);
        this.fireDomainSet(domain);
    }

    public UIDomain OLDsetDomain(Domain domain) {
        if (this.getDomain().equals(domain)) {
            return this;
        }
        return this.OLDsetNewDomain(domain);
    }

    public UIDomain OLDsetNewDomain(Domain domain) {
        UIDomain uIDomain = new UIDomain(domain, this.editor);
        uIDomain.setUIDomainListeners(this.listeners);
        this.editor.setDomain(domain);
        this.fireDomainSet(domain);
        return uIDomain;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void clearThis() {
        this.name = "";
        this.clearAnnotations();
    }

    public void clear() {
        this.clearThis();
        if (this.refSetEditor != null) {
            this.refSetEditor.clear();
        }
        if (this.classSetEditor != null) {
            this.classSetEditor.clear();
        }
        this.graphs.clear();
        this.draftDomain.clear();
        this.domainFile = null;
        this.saveToDomain(this.draftDomain);
        this.fireDomainCleared();
    }

    public void clearBase() {
        this.currentDomain.clear();
        this.clear();
        this.saveToDomain(this.currentDomain);
    }

    public void clearDraft() {
        this.clear();
        this.refSetEditor.rememberClear();
        this.classSetEditor.rememberClear();
    }

    public void setDomainFile(File file) {
        this.domainFile = file;
    }

    public File getDomainFile(File file) {
        return this.domainFile;
    }

    public File saveDomain() {
        return this.saveDomain(this.domainFile);
    }

    public File saveDomainAs() {
        return this.saveDomain(null);
    }

    public File saveDomain(File file) {
        block5: {
            this.fullSaveToDomain(this.draftDomain);
            Debug.noteln("UID: Saving domain:", this.draftDomain);
            Debug.noteln(" published domain:", this.currentDomain);
            try {
                this.draftDomain.checkConsistency();
            }
            catch (SyntaxException syntaxException) {
                String[] stringArray = new String[]{syntaxException.getMessage(), "Are you sure you want to save it?"};
                int n = JOptionPane.showConfirmDialog(this.editor.deFrame, stringArray, "Warning", 2, 2);
                if (n == 0) break block5;
                Debug.noteln("UID: not saving");
                return null;
            }
        }
        if (file != null) {
            file = DomainWriter.saveDomain(this.editor.deFrame, this.draftDomain, file);
        }
        if (file == null) {
            file = DomainWriter.saveDomain(this.editor.deFrame, this.draftDomain);
        }
        if (file != null) {
            this.domainFile = file;
        }
        return file;
    }

    public void analyseDomain() {
    }

    public void checkConsistency() {
        this.fullSaveToDomain(this.draftDomain);
        try {
            this.draftDomain.checkConsistency();
        }
        catch (SyntaxException syntaxException) {
            JOptionPane.showMessageDialog(this.editor.deFrame, syntaxException.getMessage());
        }
    }

    public HashMap collectInconsistencies() {
        this.fullSaveToDomain(this.draftDomain);
        ListOfRefinement listOfRefinement = this.draftDomain.getRefinements();
        HashMap<String, Refinement> hashMap = new HashMap<String, Refinement>();
        for (Refinement refinement : listOfRefinement) {
            try {
                refinement.checkConsistency();
            }
            catch (SyntaxException syntaxException) {
                hashMap.put(syntaxException.getMessage(), refinement);
            }
        }
        return hashMap;
    }

    public boolean checkAndListConsistency() {
        Debug.noteln("Checking collective consistency of", this);
        HashMap hashMap = this.collectInconsistencies();
        if (hashMap.size() == 0) {
            return true;
        }
        Object[] objectArray = hashMap.keySet().toArray();
        String[] stringArray = new String[]{"The domain " + this.getName() + "contains the inconsistencies listed below", "To go straight to editing a refinement with a listed inconsistency,", "select it in the list and click ok.", "To declare variables as they are currently used in all refinements,", "first click 'Cancel' then use the domain's 'declare variables' option", "in the 'Edit' menu of this panel (domain panel)."};
        Object object = JOptionPane.showInputDialog(this.editor.deFrame, stringArray, "Domain Inconsistencies", 1, null, objectArray, objectArray[0]);
        Object v = hashMap.get(object);
        if (v != null) {
            try {
                Refinement refinement = (Refinement)v;
                this.editor.setConstruct(refinement);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
            }
        }
        return false;
    }

    public void checkAndReportConsistency() {
        Debug.noteln("Checking collective consistency of", this);
        this.fullSaveToDomain(this.draftDomain);
        ListOfRefinement listOfRefinement = this.draftDomain.getRefinements();
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        for (String[] stringArray : listOfRefinement) {
            try {
                stringArray.checkConsistency();
            }
            catch (SyntaxException syntaxException) {
                hashMap.put(syntaxException.getMessage(), stringArray);
            }
        }
        if (hashMap.size() == 0) {
            JOptionPane.showMessageDialog(this.editor.deFrame, "No inconsistencies found");
        } else {
            String[] stringArray;
            Object[] objectArray = hashMap.keySet().toArray();
            stringArray = new String[]{"The domain " + this.getName() + "contains the inconsistencies listed below", "To go straight to editing a refinement with a listed inconsistency,", "select it in the list and click ok.", "To declare variables as they are currently used in all refinements,", "first click 'Cancel' then use the domain's 'declare variables' option", "in the 'Edit' menu of this panel (domain panel)."};
            Object object = JOptionPane.showInputDialog(this.editor.deFrame, stringArray, "Domain Inconsistencies", 1, null, objectArray, objectArray[0]);
            Object v = hashMap.get(object);
            if (v != null) {
                try {
                    Refinement refinement = (Refinement)v;
                    this.editor.setConstruct(refinement);
                }
                catch (Exception exception) {
                    Debug.noteException(exception);
                }
            }
        }
    }

    private Domain cloneDomain(Domain domain, Domain domain2) {
        try {
            this.copyDomain(domain, domain2);
            return domain2;
        }
        catch (Exception exception) {
            Debug.noteln("UID: Cloning of the domain failed");
            Debug.noteException(exception, false);
            return null;
        }
    }

    private Domain copyDomain(Domain domain, Domain domain2) {
        if (domain2 == null) {
            domain2 = new Domain();
        }
        try {
            domain2.setName(domain.getName());
            Annotations annotations = domain.getAnnotations();
            if (annotations != null) {
                annotations = new Annotations(annotations);
            }
            domain2.setAnnotations(annotations);
            domain2.setRefinements(UIDomain.copyConstructs(domain.getRefinements(), new LinkedListOfRefinement()));
            domain2.setObjectClasses(UIDomain.copyConstructs(domain.getObjectClasses(), new LinkedListOfObjectClass()));
            return domain2;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            return null;
        }
    }

    private static List copyConstructs(List list, List list2) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    Object object;
                    Object e = iterator.next();
                    if (e instanceof Refinement) {
                        object = ((Refinement)e).clone();
                        list2.add(object);
                        continue;
                    }
                    if (!(e instanceof ObjectClass)) continue;
                    object = ((ObjectClass)e).clone();
                    list2.add(object);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    Debug.noteln("UID: Cloning of a construct failed; skipping it.");
                    Debug.noteException(cloneNotSupportedException, false);
                }
            }
        }
        return list2;
    }

    public String toString() {
        return this.name;
    }

    public String print() {
        List list = this.getAllRefinements();
        List list2 = this.getAllObjectClasses();
        return "UIDomain[" + this.name + ", " + list.size() + " refinements," + list2.size() + " object classes]";
    }

    public String printSets() {
        List list = this.getAllRefinements();
        List list2 = this.getAllObjectClasses();
        return "UIDomain[" + this.name + ", " + " refinements " + this.refSetEditor.printSet() + " object classes " + this.classSetEditor.printSet();
    }

    public void setLoading(boolean bl) {
        this.loading = bl;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setOverwrite(boolean bl) {
        this.refSetEditor.setOverwrite(bl);
        this.classSetEditor.setOverwrite(bl);
    }

    public void insertDomain() {
        this.setOverwrite(true);
        this.setLoading(true);
        Cursor cursor = this.editor.deFrame.getCursor();
        try {
            this.editor.deFrame.setCursor(new Cursor(3));
            Domain domain = new Domain();
            File file = DomainParser.loadDomain(this.editor.deFrame, domain);
            if (file != null) {
                this.domainFile = file;
                ListOfRefinement listOfRefinement = domain.getRefinements();
                ArrayList arrayList = new ArrayList();
                for (IXObject iXObject : listOfRefinement) {
                    this.addConstruct(this.getUIObject(iXObject));
                }
                LinkedList linkedList = (LinkedList)((Object)domain.getObjectClasses());
                Debug.noteln("UID: new classes are", UIUtil.show(linkedList));
                this.classSetEditor.setObjects(linkedList);
            }
            this.editor.deFrame.setCursor(cursor);
            this.setLoading(false);
            this.setOverwrite(false);
            this.fireDomainEdited();
        }
        catch (Exception exception) {
            this.editor.deFrame.setCursor(cursor);
            this.setLoading(false);
            this.setOverwrite(false);
        }
    }

    public void loadDomain() {
        this.clear();
        this.draftDomain = new Domain();
        this.insertDomain();
        String string = this.draftDomain.getName();
        if (string != null && string.startsWith("+")) {
            string = string.substring(1);
            this.draftDomain.setName(string);
            this.setName(string);
        }
    }

    public void addGraph(Named named) {
        this.graphs.put(named.getName(), named);
        this.fireGraphAdded(named);
    }

    public void fireGraphAdded(Object object) {
    }

    public LList getAllGraphs() {
        LListCollector lListCollector = new LListCollector(this.graphs.values());
        return lListCollector.contents();
    }

    public Named getNamedGraph(String string) {
        return (Named)this.graphs.get(string);
    }

    public void removeNamedGraph(String string) {
        this.graphs.remove(string);
    }
}

