/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.iface.ui.EditableObject;
import ix.iface.ui.event.DataChangeListener;
import ix.iface.ui.util.UIUtil;
import ix.iview.ConstructEditing;
import ix.iview.UndoEditing;
import ix.iview.domain.UIObject;
import ix.iview.event.CurrentConstructListener;
import ix.iview.event.UndoChangeListener;
import ix.util.Debug;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class UndoManager
implements DataChangeListener,
CurrentConstructListener {
    protected ArrayList currentUndos = new ArrayList();
    protected EditableObject currentObject;
    protected boolean undoing = false;
    protected int undoIndex = 0;
    protected HashMap undoObjects = new HashMap();
    private HashSet undoListeners = new HashSet();
    private String cannotUndo = "Undo/Redo is only available in form-based views";
    private UndoEditing editor;

    public UndoManager(UndoEditing undoEditing) {
        this.editor = undoEditing;
        Debug.noteln("UndoMan created for", undoEditing);
    }

    public boolean isUndoing() {
        return this.undoing;
    }

    public synchronized void noteUndo(EditableObject editableObject, String string, Object object, Object object2) {
        if (editableObject == null) {
            return;
        }
        this.ensureConstructSet(editableObject);
        while (this.undoIndex > 0) {
            --this.undoIndex;
            this.currentUndos.remove(this.undoIndex);
        }
        UndoNote undoNote = new UndoNote(editableObject, string, object, object2);
        this.currentUndos.add(0, undoNote);
        this.fireUndoChange();
    }

    public synchronized boolean undo() {
        UndoNote undoNote;
        if (!this.canUndo()) {
            this.fireUndoChange();
            return false;
        }
        this.undoing = true;
        if (this.undoIndex < 0) {
            this.undoIndex = 0;
        }
        if ((undoNote = this.findUndoNote()) == null) {
            Debug.noteln("Cannot find anything to undo at step", this.undoIndex);
            Debug.noteln(" in notes of size", this.currentUndos.size());
            this.fireUndoChange();
            return false;
        }
        this.editor.undoSetValue(undoNote.field, undoNote.oldValue);
        undoNote.undone = true;
        undoNote.redone = false;
        ++this.undoIndex;
        this.fireUndoChange();
        this.undoing = false;
        return true;
    }

    public synchronized boolean undo(EditableObject editableObject) {
        if (editableObject == null) {
            return false;
        }
        this.ensureConstructSet(editableObject);
        return this.undo();
    }

    public synchronized boolean redo() {
        UndoNote undoNote;
        if (!this.canRedo()) {
            this.fireUndoChange();
            return false;
        }
        this.undoing = true;
        if (this.undoIndex >= this.currentUndos.size()) {
            this.undoIndex = this.currentUndos.size() - 1;
        }
        if ((undoNote = this.findRedoNote()) == null) {
            Debug.noteln("Cannot find anything to redo");
            this.fireUndoChange();
            return false;
        }
        this.editor.undoSetValue(undoNote.field, undoNote.newValue);
        undoNote.undone = false;
        undoNote.redone = true;
        --this.undoIndex;
        this.fireUndoChange();
        this.undoing = false;
        return true;
    }

    public synchronized boolean redo(EditableObject editableObject) {
        if (editableObject == null) {
            return false;
        }
        this.ensureConstructSet(editableObject);
        return this.redo();
    }

    private synchronized UndoNote findUndoNote() {
        try {
            UndoNote undoNote = (UndoNote)this.currentUndos.get(this.undoIndex);
            if (undoNote == null) {
                Debug.noteln("Found null undo note at index", this.undoIndex);
            }
            if (!undoNote.undone) {
                Object object = this.editor.undoGetValue(undoNote.field);
                if (this.currentObject.sameValue(undoNote.field, undoNote.oldValue, object)) {
                    Debug.noteln(" skipping step that makes no change");
                    undoNote.redone = false;
                    undoNote.undone = true;
                    ++this.undoIndex;
                    this.fireUndoChange();
                    return this.findUndoNote();
                }
                return undoNote;
            }
            Debug.noteln(" note already undone; skipping");
            ++this.undoIndex;
            this.fireUndoChange();
            return this.findUndoNote();
        }
        catch (Exception exception) {
            Debug.noteln("UndoMan: something wrong finding undo note");
            Debug.noteln("Exception class", exception.getClass());
            Debug.noteln("Exception", exception);
            Debug.describeException(exception);
            exception.printStackTrace();
            return null;
        }
    }

    private UndoNote findRedoNote() {
        try {
            UndoNote undoNote = (UndoNote)this.currentUndos.get(this.undoIndex);
            if (!undoNote.redone) {
                Object object = this.editor.undoGetValue(undoNote.field);
                if (this.currentObject.sameValue(undoNote.field, undoNote.newValue, object)) {
                    undoNote.redone = true;
                    undoNote.undone = false;
                    --this.undoIndex;
                    this.fireUndoChange();
                    return this.findRedoNote();
                }
                return undoNote;
            }
            --this.undoIndex;
            this.fireUndoChange();
            return this.findUndoNote();
        }
        catch (Exception exception) {
            Debug.describeException(exception);
            return null;
        }
    }

    public void clearUndos() {
        try {
            this.currentUndos = new ArrayList();
            this.undoIndex = 0;
            this.fireUndoChange();
        }
        catch (Exception exception) {
            Debug.describeException(exception);
        }
    }

    public void ensureConstructSet(EditableObject editableObject) {
        if (this.currentObject != null && this.currentObject.equals(editableObject)) {
            return;
        }
        if (this.currentObject != null) {
            this.fileUndos(this.currentObject);
        }
        this.retrieveUndos(editableObject);
    }

    public void setConstruct(EditableObject editableObject) {
        if (this.currentObject != null && !this.currentObject.equals(editableObject)) {
            this.fileUndos(this.currentObject);
        }
        this.retrieveUndos(editableObject);
    }

    private void fileUndos(EditableObject editableObject) {
        if (this.currentUndos.size() > 0 && editableObject != null) {
            while (this.undoIndex > 0) {
                --this.undoIndex;
                this.currentUndos.remove(this.undoIndex);
            }
            this.undoObjects.remove(editableObject);
            if (this.currentUndos.size() > 0) {
                this.undoObjects.put(editableObject, this.currentUndos);
            }
        }
        this.clearUndos();
    }

    private void retrieveUndos(EditableObject editableObject) {
        ArrayList arrayList = (ArrayList)this.undoObjects.get(editableObject);
        this.currentUndos = arrayList == null ? new ArrayList() : arrayList;
        this.currentObject = editableObject;
        if (editableObject != null) {
            editableObject.addDataChangeListener(this);
        }
        this.fireUndoChange();
    }

    public boolean canUndo() {
        if (this.currentUndos != null && this.currentUndos.size() > 0 && this.undoIndex < this.currentUndos.size()) {
            if (this.undoIndex == this.currentUndos.size() - 1) {
                UndoNote undoNote = (UndoNote)this.currentUndos.get(this.undoIndex);
                return !undoNote.undone;
            }
            return true;
        }
        return false;
    }

    public boolean canRedo() {
        if (this.currentUndos != null && this.currentUndos.size() > 0 && this.undoIndex >= 0) {
            if (this.undoIndex == 0) {
                UndoNote undoNote = (UndoNote)this.currentUndos.get(this.undoIndex);
                return undoNote.undone;
            }
            return true;
        }
        return false;
    }

    public void dataChanged(EditableObject editableObject, String string, Object object, Object object2) {
        if (this.undoing) {
            return;
        }
        if (editableObject != null && editableObject.equals(this.currentObject)) {
            this.noteUndo(editableObject, string, object, object2);
        }
    }

    public void constructChanged(Component component, UIObject uIObject, UIObject uIObject2) {
        try {
            uIObject.removeDataChangeListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setConstruct(uIObject2);
    }

    public void test() {
        Debug.noteln("UM**************", this);
        Debug.noteln("  ***** for", this.editor.getClass());
        if (this.currentObject == null) {
            Debug.noteln(" current Object null");
        } else {
            Debug.noteln(" current Object:", this.currentObject);
            Debug.noteln(" current undos:", UIUtil.show(this.currentUndos));
            UIObject uIObject = ((ConstructEditing)((Object)this.editor)).getUIConstruct();
            if (uIObject == null) {
                Debug.noteln(" Editor''s object: null");
            } else {
                Debug.noteln(" Editor''s object:", uIObject);
                Debug.noteln("  details:", uIObject.print());
            }
        }
    }

    protected void fireUndoChange() {
        try {
            if (this.undoListeners.isEmpty()) {
                return;
            }
            for (UndoChangeListener undoChangeListener : this.undoListeners) {
                undoChangeListener.undoChanged(this, this.currentObject);
            }
        }
        catch (Throwable throwable) {
            Debug.noteln("UndoMan: something went wrong firing undo change");
            Debug.noteException(throwable);
        }
    }

    public void addUndoListener(UndoChangeListener undoChangeListener) {
        this.undoListeners.add(undoChangeListener);
    }

    protected class UndoNote {
        EditableObject o;
        String field;
        Object oldValue;
        Object newValue;
        boolean undone = false;
        boolean redone = false;

        protected UndoNote(EditableObject editableObject, String string, Object object, Object object2) {
            this.o = editableObject;
            this.field = string;
            this.oldValue = object;
            this.newValue = object2;
        }

        public void noteDebug() {
            try {
                Debug.note("Undo note: ");
                Debug.note(this.o.toString());
                Debug.note(" ");
                Debug.note(this.field);
                Debug.note(" ");
                if (this.oldValue == null) {
                    Debug.note("null");
                } else {
                    Debug.note(this.oldValue.toString());
                }
                Debug.note(" -to- ");
                if (this.newValue == null) {
                    Debug.note("null");
                } else {
                    Debug.note(this.newValue.toString());
                }
                Debug.noteln("; undone:", this.undone);
            }
            catch (Exception exception) {
                Debug.describeException(exception);
            }
        }
    }
}

