/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.Issue;
import ix.icore.domain.NodeSpec;
import ix.iface.ui.AbstractEditorPanel;
import ix.iface.ui.ThingEditorPanel;
import ix.iface.ui.util.UIUtil;
import ix.iview.ConstraintEditor;
import ix.iview.domain.UINodeSpec;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import ix.util.Name;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class SpecEditor
extends ConstraintEditor {
    public String type;
    private AbstractEditorPanel specEd;

    public SpecEditor(Frame frame, String string) {
        this(frame, string, "Please enter the pattern of the " + string + ".");
    }

    public SpecEditor(Frame frame, String string, String string2) {
        super(frame, "Specification Editor", string2);
        this.type = string;
        this.setSize(405, 120);
    }

    protected Component makeRels() {
        JTextField jTextField = new JTextField();
        IVUtil.enableVars(this, jTextField);
        this.specEd = new ThingEditorPanel(null, "", jTextField);
        return this.specEd;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setText(String string) {
        this.specEd.setData(string);
    }

    protected JComponent getFocusComponent() {
        return this.specEd.getItemComponent();
    }

    public void start() {
        this.setVisible(true);
        this.initFromObject();
    }

    protected void initFromObject() {
        this.setText("");
        JComponent jComponent = this.specEd.getItemComponent();
        this.getFocusComponent().requestFocus();
    }

    protected void setFromObject(Object object) {
        LList lList = Lisp.NIL;
        if (Issue.class.isInstance(object)) {
            lList = ((Issue)object).getPattern();
        } else if (NodeSpec.class.isInstance(object)) {
            lList = ((NodeSpec)object).getPattern();
        }
        this.setText(UIUtil.listToDisplay(lList));
        this.getFocusComponent().requestFocus();
    }

    protected Object collectConstraint() {
        String string = this.specEd.getData().toString().trim();
        if (string.equals("")) {
            return null;
        }
        LList lList = Lisp.elementsFromString(string);
        if (this.type.equals("issue")) {
            if (this.isEditing()) {
                try {
                    Issue issue = (Issue)((Issue)this.original).clone();
                    issue.setPattern(lList);
                    return issue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    Debug.describeException(cloneNotSupportedException);
                    return new Issue(lList);
                }
            }
            return new Issue(lList);
        }
        if (this.type.equals("sub-activity")) {
            if (this.isEditing()) {
                try {
                    NodeSpec nodeSpec = (NodeSpec)((UINodeSpec)this.original).clone();
                    nodeSpec.setPattern(lList);
                    return nodeSpec;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    NodeSpec nodeSpec = (NodeSpec)this.original;
                    UIObject uIObject = (UIObject)this.currentObject;
                    return new UINodeSpec(uIObject.getUIDomain(), nodeSpec.getId(), lList);
                }
            }
            UIRefinement uIRefinement = (UIRefinement)this.currentObject;
            Name name = uIRefinement.getNewNodeId();
            return new UINodeSpec(uIRefinement.getUIDomain(), name, lList);
        }
        Debug.noteln("SpecEditor: cannot do specs of type", this.type);
        new Throwable().printStackTrace();
        return null;
    }
}

