/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.domain.LinkedListOfObjectProperty;
import ix.icore.domain.ObjectProperty;
import ix.iface.ui.JConstraintEditor;
import ix.iface.ui.ListEditorPanel;
import ix.iface.ui.ThingEditorPanel;
import ix.iview.domain.UIObjectClass;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.awt.Frame;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class PropertyEditor
extends JConstraintEditor {
    public String message;
    private JTextComponent nameField;
    protected JList syntaxList;

    public PropertyEditor(Frame frame) {
        this(frame, "Please enter the property specification.");
    }

    public PropertyEditor(Frame frame, String string) {
        super(frame, "Property Editor", string);
        this.setSize(305, 220);
    }

    protected Component makeBits() {
        return this.makeRels();
    }

    protected Component makeRels() {
        this.nameField = new JTextField();
        this.syntaxList = new JList(new Vector(ObjectProperty.Syntax.values()));
        ListEditorPanel listEditorPanel = new ListEditorPanel((EventListener)this, "Syntax", this.syntaxList);
        ThingEditorPanel thingEditorPanel = new ThingEditorPanel((EventListener)this, "Name", this.nameField);
        this.syntaxList.setAutoscrolls(true);
        this.syntaxList.setVisibleRowCount(6);
        this.syntaxList.setSelectionMode(0);
        this.syntaxList.setSelectedIndex(1);
        Box box = new Box(1);
        box.add(thingEditorPanel);
        box.add(listEditorPanel);
        return box;
    }

    public void setText(String string) {
        this.nameField.setText(string);
    }

    protected JComponent getFocusComponent() {
        return this.nameField;
    }

    public void start() {
        this.setVisible(true);
        this.initFromObject();
    }

    protected List getPreviousList(Object object) {
        List list = ((UIObjectClass)this.currentObject).getObjectProperties();
        return new LinkedListOfObjectProperty((Collection)list);
    }

    protected String getField(Object object) {
        return "objectProperties";
    }

    protected void initFromObject() {
        this.setText("");
        this.nameField.requestFocus();
    }

    protected void setFromObject(Object object) {
        if (object instanceof ObjectProperty) {
            this.setText(((ObjectProperty)object).getName().toString());
            this.syntaxList.clearSelection();
            this.syntaxList.setSelectedValue(((ObjectProperty)object).getSyntax(), true);
            this.nameField.requestFocus();
        }
    }

    protected Object collectConstraint() {
        ObjectProperty objectProperty;
        String string = this.nameField.getText().trim();
        if (string == null || string.equals("")) {
            return null;
        }
        ObjectProperty objectProperty2 = new ObjectProperty();
        if (this.isEditing()) {
            objectProperty = (ObjectProperty)this.original;
            objectProperty2.setValueClassName(objectProperty.getValueClassName());
        }
        objectProperty2.setName(Symbol.intern(string));
        objectProperty = this.syntaxList.getSelectedValue();
        ObjectProperty.Syntax syntax = null;
        syntax = objectProperty == null ? objectProperty2.getSyntax() : (ObjectProperty.Syntax)((Object)objectProperty);
        if (syntax == null) {
            syntax = ObjectProperty.Syntax.DEFAULT;
        }
        objectProperty2.setSyntax(syntax);
        return objectProperty2;
    }

    protected Object noteNewValue(Object object) {
        if (this.isEditing()) {
            return super.noteNewValue(object);
        }
        ((UIObjectClass)this.currentObject).addProperty((ObjectProperty)object);
        return object;
    }
}

