/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.info.AbstractIObject;
import ix.iface.ui.AbstractIFormModel;
import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import ix.util.lisp.LListCollector;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InfoIFormModel
extends AbstractIFormModel {
    public InfoIFormModel(AbstractIObject abstractIObject) {
        super(abstractIObject);
    }

    public void setFields() {
        String[] stringArray = new String[]{"name"};
        this.setNameFields(stringArray);
        ArrayList arrayList = new ArrayList(((AbstractIObject)this.baseObject).getAttributes());
        this.setDisplayFields(arrayList);
    }

    public void setGenericFields() {
        if (this.baseObjectClass == null) {
            Debug.noteln("Cannot set fields for a null base object class.");
            return;
        }
        this.nameFields = this.deriveNameFields();
        this.displayFields = this.deriveDisplayFields();
        LListCollector lListCollector = new LListCollector(this.nameFields);
        lListCollector.addAll(this.displayFields);
        this.deriveNames(lListCollector);
        this.deriveClasses(lListCollector);
    }

    protected void deriveNames(List list) {
        this.fieldNames.clear();
        if (list.isEmpty()) {
            return;
        }
        for (String string : list) {
            this.fieldNames.put(string, this.deriveName(string));
        }
    }

    protected String deriveName(String string) {
        return UIUtil.toCapitalised(string);
    }

    protected void deriveClasses(List list) {
        this.fieldClasses.clear();
        if (list.isEmpty()) {
            return;
        }
        for (String string : list) {
            Class clazz = this.deriveClass(string);
            this.fieldClasses.put(string, clazz);
        }
    }

    protected Class deriveClass(String string) {
        try {
            Field field = this.stringToField(string);
            return field.getType();
        }
        catch (Exception exception) {
            Debug.note("Working on class " + this.getObjectClass().getName());
            Debug.noteln("Fields are: " + UIUtil.fieldsToNames(this.getObjectClass().getFields()));
            Debug.noteln(" Problem deriving class for field " + string);
            Debug.noteException(exception);
            return null;
        }
    }

    protected List deriveNameFields() {
        Class clazz = this.getObjectClass();
        if (clazz == null) {
            Debug.noteln("FormModel: base object class not known.");
            return null;
        }
        List<String> list = new LListCollector();
        list = (List)InfoIFormModel.addIfField(list, clazz, "name");
        if ((list = (List)InfoIFormModel.addIfField(list, clazz, "Name")).isEmpty()) {
            Field[] fieldArray = clazz.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                String string = fieldArray[i].getName().toUpperCase();
                if (string.indexOf("NAME") == -1) continue;
                list.add(fieldArray[i].getName());
            }
        }
        list = (List)InfoIFormModel.addIfField(list, clazz, "id");
        list = (List)InfoIFormModel.addIfField(list, clazz, "Id");
        list = (List)InfoIFormModel.addIfField(list, clazz, "ID");
        return list;
    }

    protected List deriveDisplayFields() {
        Class clazz = this.getObjectClass();
        if (clazz == null) {
            Debug.noteln("FormModel: base object class not known.");
            return null;
        }
        LListCollector lListCollector = new LListCollector(Arrays.asList(clazz.getFields()));
        LListCollector lListCollector2 = new LListCollector();
        for (Field field : lListCollector) {
            if (!this.useField(field)) continue;
            lListCollector2.add(field.getName());
        }
        return lListCollector2;
    }

    protected boolean useField(Field field) {
        int n = field.getModifiers();
        return !Modifier.isStatic(n) && !Modifier.isPrivate(n) && !Modifier.isProtected(n) && !this.nameFields.contains(field.getName());
    }
}

