/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.IXObject;
import ix.icore.TaskItem;
import ix.icore.domain.Named;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainEvent;
import ix.iface.ui.AbstractEditorPanel;
import ix.iface.ui.EditableObject;
import ix.iface.ui.IXLabelRenderer;
import ix.iface.ui.ListEditorPanel;
import ix.iface.ui.ThingEditorPanel;
import ix.iface.ui.util.UIUtil;
import ix.iview.AConstructFramePanel;
import ix.iview.ConstructEditing;
import ix.iview.DomainEditorFrame;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.util.Debug;
import ix.util.lisp.LListCollector;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class GrammarEditorPanel
extends AConstructFramePanel
implements ActionListener,
UIDomainListener {
    private AbstractEditorPanel issuePatternList;
    private AbstractEditorPanel nodePatternList;
    private AbstractEditorPanel constraintPatternList;
    private HashSet issuePatterns = new HashSet();
    private HashSet nodePatterns = new HashSet();
    private List constrPatterns = new ArrayList();
    private MouseListener ml = new MouseAdapter(){};
    private boolean listsAsText = true;

    public GrammarEditorPanel(DomainEditorFrame domainEditorFrame) {
        super(domainEditorFrame);
    }

    protected JPanel setupMainPanel() {
        this.mainPanel = new GrammarFormPanel(this);
        this.scrollPane.getViewport().add(this.mainPanel);
        this.listsAsText = this.parent.listsAsText();
        this.makeLists();
        return this.mainPanel;
    }

    public void refresh() {
        this.updatePatterns();
    }

    public boolean beforeSwitching() {
        return true;
    }

    public void setListsAsText(boolean bl) {
        if (this.listsAsText != bl) {
            this.listsAsText = bl;
            this.removeLists();
            this.makeLists();
            this.updatePatterns();
        }
    }

    private void makeLists() {
        this.issuePatternList = this.makeList(this.ml, "Issue Patterns");
        this.nodePatternList = this.makeList(this.ml, "Node Patterns");
        this.constraintPatternList = this.makeList(this.ml, "Constraint Patterns");
    }

    private void removeLists() {
        this.mainPanel.remove(this.issuePatternList);
        this.mainPanel.remove(this.nodePatternList);
        this.mainPanel.remove(this.constraintPatternList);
        this.issuePatternList.removeData();
        this.nodePatternList.removeData();
        this.constraintPatternList.removeData();
        this.issuePatternList = null;
        this.nodePatternList = null;
        this.constraintPatternList = null;
    }

    private AbstractEditorPanel makeList(MouseListener mouseListener, String string) {
        AbstractEditorPanel abstractEditorPanel;
        String[] stringArray = new String[]{"Add", "Delete", "Clear"};
        if (this.listsAsText) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setRows(5);
            abstractEditorPanel = new ThingEditorPanel((EventListener)mouseListener, string, jTextArea, stringArray);
        } else {
            JList jList = new JList();
            jList.setVisibleRowCount(5);
            jList.setCellRenderer(new IXLabelRenderer(false){

                public void setInfo(Object object) {
                    String string = "";
                    string = object instanceof Collection ? UIUtil.listToDisplay((Collection)object) : object.toString();
                    this.setText(string);
                }
            });
            abstractEditorPanel = new ListEditorPanel((EventListener)mouseListener, string, jList, stringArray);
        }
        ((AbstractEditorPanel)abstractEditorPanel).setEnabled(false);
        this.mainPanel.add(abstractEditorPanel);
        return abstractEditorPanel;
    }

    private void fillConstraintPatternList() {
    }

    protected UIObject cloneConstruct(UIObject uIObject) {
        return null;
    }

    public void newConstruct() {
    }

    public UIObject makeNewConstruct() {
        return null;
    }

    public void saveConstruct() {
        UIUtil.notImplemented(this, "Saving grammars");
    }

    protected UIObject noteConstruct() {
        return null;
    }

    public void setConstruct(IXObject iXObject) {
        if (iXObject == null) {
            this.issuePatternList.removeData();
            this.nodePatternList.removeData();
            this.constraintPatternList.removeData();
        } else {
            UIUtil.notImplemented(this, "Setting grammars");
        }
    }

    public boolean checkConstruct() {
        UIUtil.notImplemented(this, "Checking grammars");
        return true;
    }

    public List getAllConstructs() {
        return new LListCollector();
    }

    public Named getNamedConstruct(String string) {
        return null;
    }

    public void constructAdded(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    public void constructAdded(DomainEvent domainEvent) {
        this.updatePatterns();
    }

    public void constructEdited(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    public void constructRemoved(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    public void domainCleared(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    public void domainEdited(UIDomainEvent uIDomainEvent) {
    }

    public void domainSet(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    private void updatePatterns() {
        this.issuePatterns.clear();
        this.nodePatterns.clear();
        this.constrPatterns.clear();
        UIDomain uIDomain = this.parent.getUIDomain();
        if (uIDomain != null) {
            List list = uIDomain.getAllRefinements();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.addAllPatterns(iterator.next());
            }
            this.constrPatterns = new ArrayList(uIDomain.grammar.getConstraintPatterns());
        }
        this.updateListPatterns(this.issuePatternList, this.issuePatterns);
        this.updateListPatterns(this.nodePatternList, this.nodePatterns);
        this.updateListPatterns(this.constraintPatternList, this.constrPatterns);
    }

    private void addAllPatterns(Object object) {
        if (object == null) {
            return;
        }
        Object var2_2 = null;
        List list = null;
        List list2 = null;
        List list3 = null;
        Object var6_6 = null;
        if (Refinement.class.isInstance(object)) {
            Refinement refinement = (Refinement)object;
            this.nodePatterns.add(refinement.getPattern());
            list = refinement.getNodes();
            list2 = refinement.getIssues();
            list3 = refinement.getConstraints();
        } else if (UIRefinement.class.isInstance(object)) {
            UIRefinement uIRefinement = (UIRefinement)object;
            this.nodePatterns.add(uIRefinement.getPattern());
            list = uIRefinement.getNodes();
            list2 = uIRefinement.getIssues();
            list3 = uIRefinement.getConstraints();
        } else {
            Debug.noteln("GEP: Cannot get patterns from class ", object.getClass().getName());
            return;
        }
        if (list != null) {
            this.nodePatterns = this.getNodePatterns(list.iterator(), this.nodePatterns);
        }
        if (list2 != null) {
            this.issuePatterns = this.getIssuePatterns(list2.iterator(), this.issuePatterns);
        }
        if (list3 != null) {
            this.constrPatterns = this.getConstraintPatterns(list3.iterator(), this.constrPatterns);
        }
    }

    private void updateListPatterns(AbstractEditorPanel abstractEditorPanel, HashSet hashSet) {
        LinkedList linkedList = new LinkedList(hashSet);
        Collections.sort(linkedList, new UIUtil.ToStringComparator());
        abstractEditorPanel.setData(linkedList);
    }

    private void updateListPatterns(AbstractEditorPanel abstractEditorPanel, List list) {
        abstractEditorPanel.setData(list);
    }

    public HashSet getAllPatterns() {
        if (this.parent.getUIDomain() == null) {
            return null;
        }
        List list = this.parent.getUIDomain().getAllRefinements();
        Iterator iterator = list.iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            hashSet.addAll(this.getAllPatterns(iterator.next()));
        }
        return hashSet;
    }

    public HashSet getAllPatterns(Object object) {
        HashSet hashSet = new HashSet();
        if (object == null) {
            return hashSet;
        }
        Object var3_3 = null;
        List list = null;
        List list2 = null;
        Object var6_6 = null;
        if (Refinement.class.isInstance(object)) {
            Refinement refinement = (Refinement)object;
            list = refinement.getNodes();
            if (list != null) {
                hashSet = this.getNodePatterns(list.iterator(), hashSet);
            }
            if ((list2 = refinement.getIssues()) != null) {
                hashSet = this.getIssuePatterns(list2.iterator(), hashSet);
            }
            hashSet.add(refinement.getPattern());
        } else if (UIRefinement.class.isInstance(object)) {
            UIRefinement uIRefinement = (UIRefinement)object;
            list = uIRefinement.getNodes();
            if (list != null) {
                hashSet = this.getNodePatterns(list.iterator(), hashSet);
            }
            if ((list2 = uIRefinement.getIssues()) != null) {
                hashSet = this.getIssuePatterns(list2.iterator(), hashSet);
            }
            hashSet.add(uIRefinement.getPattern());
        } else {
            Debug.noteln("GEP: Cannot get patterns from class ", object.getClass().getName());
            return null;
        }
        return hashSet;
    }

    public HashSet getNodePatterns(Iterator iterator, HashSet hashSet) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                hashSet.add(((NodeSpec)iterator.next()).getPattern());
            }
        }
        return hashSet;
    }

    public HashSet getIssuePatterns(Iterator iterator, HashSet hashSet) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                hashSet.add(((TaskItem)iterator.next()).getPattern());
            }
        }
        return hashSet;
    }

    public List getConstraintPatterns(Iterator iterator, List list) {
        return list;
    }

    public boolean frameActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "newConstruct") {
            this.newConstruct();
        } else if (string != "editConstruct") {
            if (string == "modify") {
                this.saveConstruct();
            } else if (string == "check") {
                this.checkConstruct();
            } else {
                return false;
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("Grammar editor: Got action command", string);
    }

    public class GrammarFormPanel
    extends JPanel
    implements ConstructEditing {
        private AConstructFramePanel parent;
        private UIObject uiConstruct;

        public GrammarFormPanel(AConstructFramePanel aConstructFramePanel) {
            super(new GridLayout(3, 1));
            this.parent = aConstructFramePanel;
        }

        public UIDomain getUIDomain() {
            return this.parent.getUIDomain();
        }

        public void setConstruct(IXObject iXObject) {
            this.setUIConstruct(this.getUIDomain().getUIObject(iXObject));
        }

        public IXObject getConstruct() {
            if (this.uiConstruct == null) {
                return null;
            }
            return this.uiConstruct.getBaseObject();
        }

        public void setUIConstruct(UIObject uIObject) {
            this.setUIConstructOnly(uIObject);
        }

        public void setUIConstructOnly(UIObject uIObject) {
            UIObject uIObject2 = this.uiConstruct;
            this.uiConstruct = uIObject;
            this.parent.fireConstructChanged(uIObject2, uIObject, this);
        }

        public UIObject getUIConstruct() {
            return this.uiConstruct;
        }

        public void loadFromObject() {
        }

        public void saveToObject(EditableObject editableObject) {
        }
    }
}

