/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.domain.Named;
import ix.icore.domain.Refinement;
import ix.iface.domain.SyntaxException;
import ix.iface.ui.util.UIUtil;
import ix.iview.AConstructFramePanel;
import ix.iview.DomainEditorFrame;
import ix.iview.DomainFormModel;
import ix.iview.GlobalFormPanel;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.event.CurrentActionListener;
import ix.util.Debug;
import ix.util.TextAreaFrame;
import ix.util.lisp.ItemVar;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GlobalFramePanel
extends AConstructFramePanel
implements CurrentActionListener {
    public GlobalFramePanel() {
    }

    public GlobalFramePanel(DomainEditorFrame domainEditorFrame) {
        super(domainEditorFrame);
        DomainFormModel domainFormModel = new DomainFormModel();
        String[] stringArray = new String[]{"refinements", "objectClasses"};
        domainFormModel.setDisplayFields(stringArray);
        this.formPanel.setModel(domainFormModel);
        UIDomain uIDomain = this.parent.getUIDomain();
        this.setUIConstruct(uIDomain);
        uIDomain.addUIDomainListener((GlobalFormPanel)this.formPanel);
    }

    protected JPanel setupMainPanel() {
        this.formPanel = new GlobalFormPanel(this);
        return this.formPanel;
    }

    protected UIObject cloneConstruct(UIObject uIObject) {
        return null;
    }

    protected void setConstructFields() {
    }

    public List getAllConstructs() {
        return null;
    }

    public void newConstruct() {
        this.notImp("Creating a new domain");
    }

    public UIObject makeNewConstruct() {
        return new UIDomain(this.parent.editor());
    }

    public boolean checkConstruct() {
        try {
            if (this.parent.getUIDomain() != null) {
                this.parent.getUIDomain().checkAndReportConsistency();
            }
            return true;
        }
        catch (SyntaxException syntaxException) {
            JOptionPane.showMessageDialog(this, syntaxException.getMessage());
            return false;
        }
    }

    public void viewChanges() {
        UIDomain uIDomain = this.parent.getUIDomain();
        if (uIDomain == null) {
            JOptionPane.showMessageDialog(this, "No construct to check");
        } else {
            List list = uIDomain.collectChanges();
            if (list == null || list.size() == 0) {
                JOptionPane.showMessageDialog(this, "No changes found");
            } else {
                TextAreaFrame textAreaFrame = new TextAreaFrame("Changes for " + uIDomain.getName());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    textAreaFrame.appendLine((String)iterator.next());
                }
                textAreaFrame.setVisible(true);
            }
        }
    }

    public void viewChangesFromOriginal() {
        UIDomain uIDomain = this.parent.getUIDomain();
        if (uIDomain == null) {
            JOptionPane.showMessageDialog(this, "No construct to check");
        } else {
            List list = uIDomain.collectChangesFromOriginal();
            if (list == null || list.size() == 0) {
                JOptionPane.showMessageDialog(this, "No changes found");
            } else {
                TextAreaFrame textAreaFrame = new TextAreaFrame("Changes for " + uIDomain.getName());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    textAreaFrame.appendLine((String)iterator.next());
                }
                textAreaFrame.setVisible(true);
            }
        }
    }

    public void saveConstruct() {
        this.noteConstruct();
    }

    public void revertConstruct() {
        UIDomain uIDomain = this.parent.getUIDomain();
        uIDomain.loadFromDomain();
        this.setUIConstruct(uIDomain);
    }

    public void revertOConstruct() {
        UIDomain uIDomain = this.parent.getUIDomain();
        uIDomain.loadFromOriginal();
        this.setUIConstruct(uIDomain);
    }

    protected UIObject noteConstruct() {
        UIDomain uIDomain = this.parent.getUIDomain();
        this.formPanel.saveToObject(uIDomain);
        Debug.noteln(" new name:", uIDomain.getName());
        uIDomain.saveToDomain();
        this.setUIConstruct(uIDomain);
        return uIDomain;
    }

    public Named getNamedConstruct(String string) {
        if (this.parent.getUIDomain() == null) {
            return null;
        }
        if (this.parent.getUIDomain().getName().equals(string)) {
            return this.parent.getUIDomain();
        }
        return null;
    }

    public void clear() {
        this.parent.getUIDomain().clear();
        this.refresh();
    }

    public void refresh() {
        this.setUIConstruct(this.parent.getUIDomain());
    }

    public void userDeclareVariables() {
        Debug.noteln("GFP: Declaring variables in domain", this.parent.getUIDomain());
        this.parent.getUIDomain().declareAllVariables();
    }

    public void userFindVariables() {
        UIDomain uIDomain = this.parent.getUIDomain();
        Set set = uIDomain.findVariablesUsed();
        if (set == null || set.size() == 0) {
            JOptionPane.showMessageDialog(this, "No variables used");
        } else {
            Object[] objectArray = set.toArray();
            String[] stringArray = new String[]{"The refinements in the domain " + uIDomain.getName() + " use the variables listed below", "To find refinements that use a listed variable select it in the list and click ok."};
            Object object = JOptionPane.showInputDialog(this.parent, stringArray, "Variables Used", 1, null, objectArray, objectArray[0]);
            if (object != null && object != "") {
                Collection collection = uIDomain.findVariableUsers((ItemVar)object);
                if (collection == null || collection.size() == 0) {
                    JOptionPane.showMessageDialog(this, "Cannot find refinements using" + object);
                } else {
                    try {
                        Object[] objectArray2 = collection.toArray();
                        String[] stringArray2 = new String[]{"The refinements in the domain " + uIDomain.getName() + " that use variable " + object + " are listed below", "To go straight to editing a listed refinement,", " select it in the list and click ok."};
                        Object object2 = JOptionPane.showInputDialog(this.parent, stringArray2, "Refinements Using" + object, 1, null, objectArray2, objectArray2[0]);
                        if (object2 != null) {
                            Refinement refinement = (Refinement)object2;
                            this.parent.editor().setConstruct(refinement);
                        }
                    }
                    catch (Exception exception) {
                        Debug.noteException(exception);
                    }
                }
            }
        }
    }

    public void addCurrentActionListener(CurrentActionListener currentActionListener) {
        ((GlobalFormPanel)this.formPanel).addCurrentActionListener(currentActionListener);
    }

    public void actionChanged(Component component, UIRefinement uIRefinement, UIRefinement uIRefinement2) {
        if (this.equals(component)) {
            return;
        }
        ((GlobalFormPanel)this.formPanel).reactingActionChange(true);
        ((GlobalFormPanel)this.formPanel).setSelectedAction(uIRefinement2);
        ((GlobalFormPanel)this.formPanel).reactingActionChange(false);
    }

    public boolean frameActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("DomainFramePanel got frame action command", string);
        if (string == "newConstruct") {
            this.newConstruct();
        } else if (string == "editConstruct") {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string2 = jMenuItem.getText().trim();
            this.setUIConstruct((UIObject)this.getNamedConstruct(string2));
        } else if (string == "modify") {
            this.saveConstruct();
        } else if (string == "revert") {
            this.revertConstruct();
        } else if (string == "revertO") {
            this.revertOConstruct();
        } else if (string == "check") {
            this.checkConstruct();
        } else if (string == "declareVars") {
            this.userDeclareVariables();
        } else if (string == "findVars") {
            this.userFindVariables();
        } else {
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("Global Domain Panel got action command", string);
    }

    protected void notImp(String string) {
        UIUtil.notImplemented(this, string);
    }
}

