/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.Annotations;
import ix.icore.IXObject;
import ix.icore.domain.Named;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainEvent;
import ix.icore.domain.event.RefinementEvent;
import ix.iface.ui.IFormModel;
import ix.iface.ui.IFormPanel;
import ix.iface.ui.IXEditorPanel;
import ix.iface.ui.IXLabelRenderer;
import ix.iface.ui.ListEditorPanel;
import ix.iface.ui.table.AbstractIXTableModel;
import ix.iface.ui.table.IXTreeTable;
import ix.iview.AConstructFramePanel;
import ix.iview.ActionListRenderer;
import ix.iview.ConstructEditing;
import ix.iview.DomainEditor;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UINodeSpec;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.iview.event.CurrentActionListener;
import ix.iview.table.ActionTreeTableModel;
import ix.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GlobalFormPanel
extends IFormPanel
implements ConstructEditing,
UIDomainListener,
ListSelectionListener {
    private UIObject uiConstruct;
    private UIRefinement currentAction;
    private ActionTreeTableModel tableModel;
    public IXTreeTable table;
    private AConstructFramePanel parent;
    HashSet actionListeners = new HashSet();
    private boolean reactingActionChange = false;

    public GlobalFormPanel(AConstructFramePanel aConstructFramePanel) {
        this.parent = aConstructFramePanel;
    }

    public GlobalFormPanel(AConstructFramePanel aConstructFramePanel, IFormModel iFormModel) {
        super(iFormModel);
        this.parent = aConstructFramePanel;
    }

    protected void setRenderers() {
        ActionListRenderer actionListRenderer = new ActionListRenderer(false);
        this.fieldRenderers.put("refinements", actionListRenderer);
    }

    protected IXEditorPanel makeDisplayBit(String string) {
        if (string.equals("refinements")) {
            String[] stringArray = new String[]{"Add", "Edit", "Delete"};
            this.tableModel = new ActionTreeTableModel(false, this.getUIDomain());
            this.table = new IXTreeTable(this.tableModel);
            this.tableModel.setParentsBold(true);
            this.table.setPreferredScrollableViewportSize(new Dimension(200, 100));
            this.table.getSelectionModel().addListSelectionListener(this);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(this.table);
            return new ListEditorPanel((EventListener)this, this.model.getFieldName(string), jScrollPane, stringArray);
        }
        return super.makeDisplayBit(string);
    }

    public void saveFieldData(String string) {
        if (string.equals("annotations")) {
            Debug.noteln("Cannot save annotations yet");
        } else if (!string.equals("refinements") && !string.equals("objectClasses")) {
            super.saveFieldData(string);
        }
    }

    public Object getFieldData(String string) {
        if (string.equals("refinements") || string.equals("objectClasses")) {
            return null;
        }
        return super.getFieldData(string);
    }

    public void setFieldData(String string, Object object) {
        if (string.equals("refinements")) {
            this.updateTable();
        } else if (string.equals("objectClasses")) {
            this.updateList();
        } else {
            super.setFieldData(string, object);
        }
    }

    public void refinementAdded(RefinementEvent refinementEvent) {
    }

    public void refinementRemoved(RefinementEvent refinementEvent) {
    }

    public void constructAdded(DomainEvent domainEvent) {
    }

    public void constructAdded(UIDomainEvent uIDomainEvent) {
    }

    public void constructRemoved(UIDomainEvent uIDomainEvent) {
        this.updateList();
    }

    public void constructEdited(UIDomainEvent uIDomainEvent) {
    }

    public void domainCleared(UIDomainEvent uIDomainEvent) {
    }

    public void domainEdited(UIDomainEvent uIDomainEvent) {
        this.updateTable();
        this.updateList();
    }

    public void domainSet(UIDomainEvent uIDomainEvent) {
        this.getModel().setObject(uIDomainEvent.getDomain());
    }

    public void updateTable() {
        this.tableModel.reloadData();
        this.table.setSelectedObject(this.currentAction);
    }

    public void updateList() {
        super.setFieldData("objectClasses", this.getUIDomain().getAllObjectClasses());
    }

    public UIDomain getUIDomain() {
        return this.parent.getUIDomain();
    }

    public void setConstruct(IXObject iXObject) {
        this.setUIConstruct(this.getUIDomain().getUIObject(iXObject));
    }

    public IXObject getConstruct() {
        if (this.uiConstruct == null) {
            return null;
        }
        return this.uiConstruct.getBaseObject();
    }

    public void setUIConstruct(UIObject uIObject) {
        this.setUIConstructOnly(uIObject);
    }

    public void setUIConstructOnly(UIObject uIObject) {
        UIObject uIObject2 = this.uiConstruct;
        this.uiConstruct = uIObject;
        this.getModel().setObject(uIObject);
        this.parent.fireConstructChanged(uIObject2, uIObject, this);
    }

    public UIObject getUIConstruct() {
        return this.uiConstruct;
    }

    public void loadFromObject() {
        this.displayModelData();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component instanceof AbstractButton && component.getParent().getParent() instanceof IXEditorPanel) {
            AbstractButton abstractButton = (AbstractButton)component;
            Container container = component.getParent().getParent();
            String string = ((IXEditorPanel)((Object)container)).getName();
            if (string != null) {
                if (abstractButton.getText() == "Add") {
                    if (string.equals("ObjectClasses")) {
                        String string2 = "Please use the Objects panel to add object classes.";
                        JOptionPane.showMessageDialog(this.parent, string2);
                    } else if (string.equals("Refinements")) {
                        this.getEditor().setConstruct(new Refinement());
                    }
                } else if (abstractButton.getText() == "Delete") {
                    this.userDeleteItem((IXEditorPanel)((Object)container));
                } else if (abstractButton.getText() == "Edit") {
                    this.userEditItem((IXEditorPanel)((Object)container));
                }
            }
        }
        super.mouseClicked(mouseEvent);
    }

    private List getClearSelection(IXEditorPanel iXEditorPanel) {
        JComponent jComponent = iXEditorPanel.getItemComponent();
        if (jComponent instanceof IXTreeTable) {
            IXTreeTable iXTreeTable = (IXTreeTable)jComponent;
            int[] nArray = iXTreeTable.getSelectedRows();
            iXTreeTable.clearSelection();
            if (nArray.length == 0) {
                this.complainNoSelection(iXEditorPanel);
                return null;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            AbstractIXTableModel abstractIXTableModel = (AbstractIXTableModel)iXTreeTable.getModel();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(abstractIXTableModel.getRowObject(nArray[i]));
            }
            return arrayList;
        }
        if (jComponent instanceof JList) {
            List<Object> list = Arrays.asList(((JList)jComponent).getSelectedValues());
            ((JList)jComponent).clearSelection();
            if (list == null || list.isEmpty()) {
                this.complainNoSelection(iXEditorPanel);
                return null;
            }
            return list;
        }
        return null;
    }

    private void complainNoSelection(IXEditorPanel iXEditorPanel) {
        String string = "Please select an item from the list first.";
        JOptionPane.showMessageDialog(this.parent, string);
    }

    private void userDeleteItem(IXEditorPanel iXEditorPanel) {
        List list = this.getClearSelection(iXEditorPanel);
        if (list != null) {
            for (Object e : list) {
                try {
                    this.getUIDomain().removeConstruct((UIObject)e);
                }
                catch (ClassCastException classCastException) {
                    try {
                        this.getUIDomain().removeConstruct((Named)e);
                    }
                    catch (ClassCastException classCastException2) {
                        Debug.noteln("Domain Editor: Cannot delete things of class", e.getClass().getName());
                    }
                }
            }
        }
    }

    private DomainEditor getEditor() {
        return this.parent.parent.editor();
    }

    private void userEditItem(IXEditorPanel iXEditorPanel) {
        List list = this.getClearSelection(iXEditorPanel);
        if (list != null && !list.isEmpty()) {
            Object e = list.get(0);
            try {
                this.getEditor().setConstruct((IXObject)e);
            }
            catch (ClassCastException classCastException) {
                try {
                    this.getEditor().setUIConstruct((UIObject)e);
                }
                catch (ClassCastException classCastException2) {
                    try {
                        UINodeSpec uINodeSpec = (UINodeSpec)e;
                        UIRefinement uIRefinement = new UIRefinement(this.getUIDomain());
                        uIRefinement.setPattern(uINodeSpec.getPattern());
                        uIRefinement.setName("undefined");
                        this.getEditor().setUIConstruct(uIRefinement);
                    }
                    catch (ClassCastException classCastException3) {
                        Debug.noteln("Domain Editor: Cannot edit things of class", e.getClass().getName());
                    }
                }
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object;
        UIRefinement uIRefinement = this.currentAction;
        int n = this.table.getSelectedRow();
        if (n != -1 && n < this.table.getRowCount() && (object = this.tableModel.getRowObject(n)) instanceof UIRefinement) {
            UIRefinement uIRefinement2;
            this.currentAction = uIRefinement2 = (UIRefinement)object;
            this.fireCurrentActionChanged(uIRefinement, uIRefinement2);
        }
    }

    public void addCurrentActionListener(CurrentActionListener currentActionListener) {
        this.actionListeners.add(currentActionListener);
    }

    private void fireCurrentActionChanged(UIRefinement uIRefinement, UIRefinement uIRefinement2) {
        if (this.reactingActionChange) {
            return;
        }
        if (uIRefinement == null && uIRefinement2 == null || uIRefinement != null && uIRefinement.equals(uIRefinement2)) {
            return;
        }
        for (CurrentActionListener currentActionListener : this.actionListeners) {
            currentActionListener.actionChanged(this, uIRefinement, uIRefinement2);
        }
        if (uIRefinement2 == null || uIRefinement2.isEmpty()) {
            this.table.clearSelection();
        }
    }

    public void reactingActionChange(boolean bl) {
        this.reactingActionChange = bl;
    }

    public void setSelectedAction(UIRefinement uIRefinement) {
        this.table.clearSelection();
        this.table.setSelectedObject(uIRefinement);
    }

    private class DescriptionsRenderer
    extends IXLabelRenderer {
        public DescriptionsRenderer(boolean bl) {
            super(bl);
        }

        public void setInfo(Object object) {
            if (object == null) {
                this.setText("");
            } else if (Annotations.class.isInstance(object)) {
                // empty if block
            }
        }
    }
}

