/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.domain.Constraint;
import ix.icore.domain.Refinement;
import ix.iface.domain.LTF_Parser;
import ix.iface.domain.SyntaxException;
import ix.iface.ui.IXButPanel;
import ix.iface.ui.ListEditorPanel;
import ix.iview.ConstraintEditor;
import ix.iview.FullNodeRenderer;
import ix.iview.NodeNumberRenderer;
import ix.iview.domain.UIRefinement;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventListener;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConditionEffectEditor
extends ConstraintEditor
implements ListSelectionListener {
    protected ListEditorPanel actEd;
    protected JRadioButton condBut;
    protected JRadioButton effBut;
    private ButtonGroup group;
    protected JTextField statement;
    LTF_Parser constraintParser = new LTF_Parser();
    boolean isAdjusting = false;

    public ConditionEffectEditor(Frame frame) {
        super(frame, "Condition/Effect Editor", "Please specify a condition or an effect");
    }

    public ConditionEffectEditor(Frame frame, UIRefinement uIRefinement) {
        this(frame);
        this.setObject(uIRefinement);
    }

    protected Component makeRels() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.actEd = this.makeActPanel(new JComboBox());
        JLabel jLabel = new JLabel("Statement. syntax: pattern = value");
        this.statement = new JTextField();
        IVUtil.enableVars(this, this.statement);
        this.condBut = new JRadioButton("Condition", true);
        this.effBut = new JRadioButton("Effect", false);
        this.condBut.setActionCommand("Condition");
        this.effBut.setActionCommand("Effect");
        Object[] objectArray = new Object[]{this.condBut, this.effBut};
        IXButPanel iXButPanel = new IXButPanel(this, 0, objectArray);
        iXButPanel.setButtonGroup(true);
        this.group = iXButPanel.group;
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)iXButPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)this.statement, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 2, 1.0, 1.0, 17, 2, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)this.actEd, gridBagConstraints);
        return jPanel;
    }

    private ListEditorPanel makeActPanel(JList jList) {
        this.actEd = new ListEditorPanel((EventListener)this, "Attach to node", jList);
        jList.setAutoscrolls(true);
        jList.setSelectionMode(0);
        this.actEd.setRenderer(new NodeNumberRenderer(false));
        return this.actEd;
    }

    private ListEditorPanel makeActPanel(JComboBox jComboBox) {
        this.actEd = new ListEditorPanel((EventListener)this, "Attach to node", jComboBox);
        this.actEd.setRenderer(new FullNodeRenderer(false));
        return this.actEd;
    }

    public void moreInitFromObject() throws NullPointerException {
        boolean bl = this.effBut.isSelected();
        this.initFromObject();
        if (bl) {
            this.effBut.setSelected(true);
        }
        this.getFocusComponent().requestFocus();
    }

    protected void initFromObject() throws NullPointerException {
        this.statement.setText("");
        this.condBut.setSelected(true);
        UIRefinement uIRefinement = (UIRefinement)this.currentObject;
        if (uIRefinement == null) {
            return;
        }
        LinkedList<UIRefinement> linkedList = new LinkedList<UIRefinement>(uIRefinement.getNodes());
        linkedList.add(0, uIRefinement);
        this.makeActList(linkedList.toArray());
        this.getFocusComponent().requestFocus();
    }

    protected void setFromObject(Object object) {
        this.statement.setText("");
        if (object == null) {
            return;
        }
        if (!(object instanceof Constraint)) {
            String string = "Condition/Effect editor can only deal with constraints not objects of class " + object.getClass().getName();
            JOptionPane.showMessageDialog(this, string);
            return;
        }
        Constraint constraint = (Constraint)object;
        if (constraint.getType() != Refinement.S_WORLD_STATE) {
            String string = "Condition/Effect editor cannot deal with constraints Of type " + constraint.getType().toString();
            JOptionPane.showMessageDialog(this, string);
            return;
        }
        this.actEd.setSelectedIndex(0);
        this.condBut.setSelected(constraint.getRelation() != Refinement.S_EFFECT);
        this.effBut.setSelected(constraint.getRelation() == Refinement.S_EFFECT);
        this.statement.setText(IVUtil.printConstraintParameters(constraint));
        this.getFocusComponent().requestFocus();
    }

    protected JComponent getFocusComponent() {
        return this.statement;
    }

    private void makeActList(Object[] objectArray) {
        this.isAdjusting = true;
        this.actEd.setData(objectArray);
        this.isAdjusting = false;
        this.actEd.setSelectedIndex(0);
    }

    protected Object collectConstraint() {
        Object object = this.actEd.getSelectedObject();
        ButtonModel buttonModel = this.group.getSelection();
        String string = buttonModel.getActionCommand();
        Symbol symbol = string.equals("Effect") ? Refinement.S_EFFECT : Refinement.S_CONDITION;
        String string2 = this.statement.getText().trim();
        Constraint constraint = this.readCondition(symbol, string2);
        if (this.isEditing()) {
            try {
                Constraint constraint2 = (Constraint)((Constraint)this.original).clone();
                constraint2.setRelation(symbol);
                constraint2.setParameters(constraint.getParameters());
                return constraint2;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Debug.describeException(cloneNotSupportedException);
                return null;
            }
        }
        return constraint;
    }

    protected Constraint readCondition(Symbol symbol, String string) throws SyntaxException {
        return IVUtil.readCondition(Refinement.S_WORLD_STATE, symbol, string);
    }

    protected Constraint readCondition(String string) throws SyntaxException {
        return this.readCondition(Refinement.S_CONDITION, string);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getSource() != null && listSelectionEvent.getSource().equals(this.actEd.getItemComponent()) && !this.isAdjusting && ((JComponent)listSelectionEvent.getSource()).isShowing() && (n = this.actEd.getSelectedIndex()) != 0) {
            String string = "Sofar, conditions and effects can only be attached to refinements (i.e. self)";
            JOptionPane.showMessageDialog(this, string);
            this.actEd.setSelectedIndex(0);
        }
    }
}

