/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.IXObject;
import ix.icore.Issue;
import ix.icore.domain.Constraint;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.iface.ui.EditableObject;
import ix.iface.ui.IFormPanel;
import ix.iface.ui.IXEditorPanel;
import ix.iface.ui.IXLabelRenderer;
import ix.iface.ui.ThingEditorPanel;
import ix.iface.ui.util.UIUtil;
import ix.iview.AConstructFramePanel;
import ix.iview.ActionEditorPanel;
import ix.iview.ConstructEditing;
import ix.iview.MiniConstraintPanel;
import ix.iview.UndoEditing;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class ActionFormPanel
extends IFormPanel
implements ConstructEditing,
UndoEditing {
    AConstructFramePanel parent;
    private UIObject uiConstruct;

    ActionFormPanel(AConstructFramePanel aConstructFramePanel) {
        this.parent = aConstructFramePanel;
    }

    public void displayFieldData(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("orderings") && this.getModel().isFieldShowing("miniConstraints")) {
            this.displayFieldData("miniConstraints");
        } else {
            super.displayFieldData(string);
            if (string.equals("constraints")) {
                this.displayFieldData("orderings");
                this.displayFieldData("conditions");
            }
        }
    }

    protected void setRenderers() {
        IXLabelRenderer iXLabelRenderer = new IXLabelRenderer(false){

            public void setInfo(Object object) {
                if (object == null) {
                    this.setText("");
                } else {
                    this.setText(IVUtil.printOrdering((Ordering)object));
                }
            }
        };
        this.fieldRenderers.put("orderings", iXLabelRenderer);
        iXLabelRenderer = new IXLabelRenderer(false){

            public void setInfo(Object object) {
                if (object == null) {
                    this.setText("");
                } else {
                    this.setText(IVUtil.printCondition((Constraint)object));
                }
            }
        };
        this.fieldRenderers.put("conditions", iXLabelRenderer);
        iXLabelRenderer = new IXLabelRenderer(false){

            public void setInfo(Object object) {
                if (object == null) {
                    this.setText("");
                } else {
                    this.setText(IVUtil.printConstraint((Constraint)object));
                }
            }
        };
        this.fieldRenderers.put("constraints", iXLabelRenderer);
    }

    protected Object renderValue(String string, Object object) {
        if (object == null) {
            return null;
        }
        if (string.equals("pattern")) {
            return UIUtil.listToDisplay((LList)object);
        }
        if (string.equals("nodes") && this.isSimpleField(string)) {
            String string2 = "";
            for (NodeSpec nodeSpec : (List)object) {
                LList lList = nodeSpec.getPattern();
                string2 = string2 + Lisp.elementsToString(lList) + UIUtil.lineSeparator;
            }
            return string2;
        }
        if (string.equals("issues") && this.isSimpleField(string)) {
            String string3 = "";
            for (Issue issue : (List)object) {
                LList lList = issue.getPattern();
                string3 = string3 + Lisp.elementsToString(lList) + UIUtil.lineSeparator;
            }
            return string3;
        }
        return super.renderValue(string, object);
    }

    protected Object deRenderValue(String string, Object object) {
        if (string.equals("pattern")) {
            if (object == null) {
                return Lisp.NIL;
            }
            return Lisp.elementsFromString((String)object);
        }
        if (string.equals("nodes")) {
            if (object == null) {
                return Lisp.NIL;
            }
            if (object.getClass() == String.class) {
                return UIRefinement.parseNodes(this.getUIDomain(), (String)object);
            }
            UIRefinement uIRefinement = (UIRefinement)this.model.getObject();
            if (uIRefinement != null) {
                return uIRefinement.getNodes();
            }
            return Lisp.NIL;
        }
        if (string.equals("issues")) {
            if (object == null) {
                return Lisp.NIL;
            }
            if (object.getClass() == String.class) {
                return UIRefinement.parseIssues(this.getUIDomain(), (String)object);
            }
            UIRefinement uIRefinement = (UIRefinement)this.model.getObject();
            if (uIRefinement != null) {
                return uIRefinement.getIssues();
            }
            return Lisp.NIL;
        }
        if (string.equals("orderings") || string.equals("conditions") || string.equals("constraints")) {
            if (object == null) {
                return Lisp.NIL;
            }
            List<Object> list = Arrays.asList((Object[])object);
            LListCollector lListCollector = new LListCollector(list);
            return lListCollector;
        }
        return super.deRenderValue(string, object);
    }

    protected IXEditorPanel makeDisplayBit(final String string) {
        if (string.equals("miniConstraints")) {
            String[] stringArray = new String[]{};
            return new MiniConstraintPanel(this, "Orderings", stringArray);
        }
        if (string.equals("pattern")) {
            JTextField jTextField = new JTextField();
            jTextField.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    ActionFormPanel.this.saveFieldData(string);
                }
            });
            IVUtil.enableVars(this.parent, jTextField);
            return new ThingEditorPanel((EventListener)this, this.model.getFieldName(string), jTextField);
        }
        IXEditorPanel iXEditorPanel = super.makeDisplayBit(string);
        JComponent jComponent = iXEditorPanel.getItemComponent();
        if ((string.equals("nodes") || string.equals("issues")) && JTextComponent.class.isInstance(jComponent)) {
            IVUtil.enableVars(this.parent, (JTextComponent)jComponent);
        }
        return iXEditorPanel;
    }

    public boolean isSequenceSet() {
        Object object = this.getFieldData("miniConstraints");
        return "sequential".equals(object);
    }

    private String getNameString() {
        Object object = this.getFieldData("name");
        if (object == null) {
            return "";
        }
        return object.toString().trim();
    }

    private LList getPatternLList() {
        Object object = this.getFieldData("pattern");
        return Lisp.elementsFromString((String)object);
    }

    public void undoSetValue(String string, Object object) {
        Debug.noteln("AFP: got undo set for field " + string + " val", object);
        this.getModel().setValue(string, object);
    }

    public Object undoGetValue(String string) {
        Debug.noteln("AFP: got undo get for field", string);
        return this.getModel().getValue(string);
    }

    public UIDomain getUIDomain() {
        return this.parent.getUIDomain();
    }

    public IXObject getConstruct() {
        return this.uiConstruct.getBaseObject();
    }

    public void setConstruct(IXObject iXObject) {
        this.setUIConstruct(this.getUIDomain().getUIObject(iXObject));
    }

    public UIObject getUIConstruct() {
        return this.uiConstruct;
    }

    public void setUIConstruct(UIObject uIObject) {
        UIObject uIObject2 = this.uiConstruct;
        this.uiConstruct = uIObject;
        this.getModel().setObject(uIObject);
        this.parent.fireConstructChanged(uIObject2, uIObject, this);
    }

    public void setUIConstructOnly(UIObject uIObject) {
        UIObject uIObject2 = this.uiConstruct;
        this.uiConstruct = uIObject;
        this.getModel().setObject(uIObject);
        ((ActionEditorPanel)this.parent).updateTreeSelection();
        this.parent.fireConstructChanged(uIObject2, uIObject, this);
    }

    public void loadFromObject() {
        this.displayModelData();
    }

    public void saveToObject(EditableObject editableObject) {
        UIRefinement uIRefinement = (UIRefinement)editableObject;
        this.saveToUIR(uIRefinement);
    }

    public void saveToObject() {
        this.saveToObject(this.model.getObject());
    }

    private void saveToUIR(UIRefinement uIRefinement) {
        if (this.isSequenceSet()) {
            uIRefinement.setOrderings(uIRefinement.makeSequence());
        }
        super.saveToObject(uIRefinement);
    }
}

