/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.iface.ui.util.UIUtil;
import ix.iview.ObjectManager;
import ix.iview.domain.UIObject;
import ix.util.Debug;
import ix.util.StableHashMap;
import ix.util.lisp.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public abstract class AbstractSetEditor {
    public ObjectManager manager;
    private boolean overwrite = false;
    protected String label = "construct";
    protected static final int CANCEL = 0;
    protected static final int ADD = 1;
    protected static final int OVERWRITE = 2;
    protected static final int NEWNAME = 3;
    protected StableHashMap members = new StableHashMap();
    protected HashSet added = new HashSet();
    protected HashSet edited = new HashSet();
    protected HashSet removed = new HashSet();
    protected HashMap originals = new HashMap();

    public AbstractSetEditor(ObjectManager objectManager, LinkedList linkedList) {
        this.setManager(objectManager, linkedList);
    }

    public void setManager(ObjectManager objectManager, LinkedList linkedList) {
        this.manager = objectManager;
        objectManager.noteSetEditor(this);
        this.setObjects(linkedList);
    }

    public void setObjects(LinkedList linkedList) {
        this.clear();
        if (this.manager != null) {
            this.members.clear();
            if (linkedList == null) {
                return;
            }
            for (Object e : linkedList) {
                if (e == null) continue;
                Object object = e;
                try {
                    object = this.cloneConstruct(e);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                this.members.put(this.getName(object), object);
                this.originals.put(e, object);
            }
        }
    }

    public void clear() {
        this.resetEdits();
        this.originals.clear();
    }

    public void resetEdits() {
        this.added.clear();
        this.edited.clear();
        this.removed.clear();
    }

    public boolean isLoading() {
        return this.manager.isLoading();
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public abstract boolean isOwnObject(Object var1);

    public abstract boolean sameConstruct(Object var1, Object var2);

    public abstract Object makeOwnObject(Object var1);

    public abstract LinkedList makeOriginalList();

    public abstract String getName(Object var1);

    public abstract void setName(Object var1, String var2);

    public abstract void setLegalName(Object var1, String var2);

    public abstract Object getStringObject(String var1);

    public abstract boolean isEmpty(Object var1);

    public abstract boolean isUndefined(Object var1);

    public abstract Object cloneConstruct(Object var1) throws CloneNotSupportedException;

    public boolean isCurrentOwnObject(Object object) {
        if (this.removed.contains(object)) {
            return false;
        }
        return this.edited.contains(object) || this.added.contains(object);
    }

    public boolean hasOriginal(Object object) {
        return this.originals.values() != null && this.originals.values().contains(object);
    }

    public LinkedList getOriginals() {
        if (this.originals == null || this.originals.keySet() == null) {
            return null;
        }
        return new LinkedList(this.originals.keySet());
    }

    public Object getOriginal(Object object) {
        if (object != null && this.originals.values() != null && this.originals.values().contains(object)) {
            for (Object k : this.originals.keySet()) {
                if (!object.equals(this.originals.get(k))) continue;
                return k;
            }
        }
        return null;
    }

    public boolean isEmpty() {
        LinkedList linkedList = this.getAllConstructs();
        return linkedList == null || linkedList.isEmpty();
    }

    public void ensureConstruct(Object object) {
        if (this.added.contains(object)) {
            return;
        }
        if (this.edited.contains(object)) {
            return;
        }
        LinkedList linkedList = this.getOriginals();
        if (linkedList != null && linkedList.contains(object)) {
            return;
        }
        if (this.originals.values() != null && this.originals.values().contains(object)) {
            return;
        }
        if (!this.isEmpty(object) && !this.isUndefined(object)) {
            this.addConstruct(object);
        }
    }

    public boolean addConstruct(Object object) {
        int n = this.handleOverwrite(object);
        if (n == 3 || n == 2) {
            return this.addConstruct(object);
        }
        if (n == 0) {
            return false;
        }
        this.members.put(this.getName(object), object);
        if (this.removed.contains(object)) {
            this.removed.remove(object);
            this.fireConstructEdited(object);
        } else {
            Object object2 = this.getOriginal(object);
            if (this.removed.contains(object2)) {
                this.removed.remove(object2);
                this.fireConstructEdited(object);
            } else if (this.added.add(object)) {
                this.fireConstructAdded(object);
            } else {
                this.fireConstructEdited(object);
            }
        }
        return true;
    }

    private Object getNameClashObject(Object object) {
        return this.getNameClashObject(object, this.getName(object));
    }

    private Object getNameClashObject(Object object, String string) {
        Object object2 = this.getStringObject(string);
        if (!(object2 == null || object2.equals(object) || object2.equals(this.getOriginal(object)) || this.removed.contains(object2))) {
            return object2;
        }
        return null;
    }

    private int handleOverwrite(Object object) {
        return this.handleOverwrite(object, this.getName(object));
    }

    private int handleOverwrite(Object object, String string) {
        String string2 = string;
        if (string == null || string.equals("")) {
            String string3 = JOptionPane.showInputDialog("Please enter a name for the " + this.label);
            if (string3 == null) {
                return 0;
            }
            try {
                if (this.getName(object) == null && string == null || this.getName(object).equals(string)) {
                    this.setName(object, string3);
                }
                return this.handleOverwrite(object, string3);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                return 0;
            }
        }
        Object[] objectArray = new Object[]{"Replace", "Change Name", "Replace All", "Cancel"};
        Object[] objectArray2 = new Object[]{"Replace", "Change Name", "Cancel"};
        List<Object> list = null;
        Object object2 = this.getNameClashObject(object, string);
        if (object2 != null) {
            String[] stringArray;
            Debug.noteln("ASE: we do have an overwrite situation for", object);
            Debug.noteln(" old object is", object2);
            int n = 0;
            if (this.isLoading()) {
                list = Arrays.asList(objectArray);
                if (!this.overwrite) {
                    stringArray = new String[]{"There already is a " + this.label + " called " + string + ". Do you want to ", "Replace the existing " + this.label + "?", "Change the name of the new " + this.label + "?", "Replace ALL duplicate " + this.label + "s during this open/insert?", "Cancel the overwrite, i.e. use the existing " + this.label + ", forgetting the new one?"};
                    n = JOptionPane.showOptionDialog(null, stringArray, "WARNING: Name clash", -1, 2, null, objectArray, objectArray[0]);
                }
            } else {
                stringArray = new String[]{"There already is a " + this.label + " called " + string + ". Do you want to ", "Replace the existing " + this.label + "?", "Change the name of the new " + this.label + "?", "Cancel the overwrite, i.e. use the existing " + this.label + ", forgetting the new one?"};
                n = JOptionPane.showOptionDialog(null, stringArray, "WARNING: Name clash", -1, 2, null, objectArray2, objectArray2[0]);
                list = Arrays.asList(objectArray2);
            }
            if (n == -1 || "Cancel".equals(list.get(n))) {
                return 0;
            }
            if ("Replace All".equals(list.get(n)) || "Replace".equals(list.get(n))) {
                if ("Replace All".equals(list.get(n))) {
                    this.overwrite = true;
                }
                this.removeConstruct(object2);
                return 2;
            }
            stringArray = JOptionPane.showInputDialog("Please enter the new name");
            if (stringArray == null) {
                return 0;
            }
            try {
                this.setName(object, (String)stringArray);
                return 3;
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                return 0;
            }
        }
        return 1;
    }

    public boolean handleNameClash(UIObject uIObject, String string, Object object) {
        Debug.noteln("ASetEd: name clash on", string);
        Debug.noteln(" Between " + uIObject.toString() + " and", object);
        Object[] objectArray = new Object[]{"Change this name", "Change other name", "Cancel"};
        String[] stringArray = new String[]{"There already is a " + this.label + " called " + string + ". Do you want to ", "Change the name of this " + this.label + "?", "Change the name of the other " + this.label + "?", "Cancel the name change and stay with the old name " + uIObject.getName()};
        int n = JOptionPane.showOptionDialog(null, stringArray, "WARNING: Name clash", -1, 2, null, objectArray, objectArray[0]);
        if (n == -1 || n == 2) {
            return false;
        }
        String string2 = JOptionPane.showInputDialog("Please enter the new name");
        if (string2 == null) {
            return false;
        }
        if (n == 0) {
            uIObject.setName(string2);
        } else {
            String string3 = uIObject.getName();
            this.setLegalName(uIObject, string + "temporaryNameXX");
            UIObject uIObject2 = this.isOwnObject(object) ? (UIObject)object : (UIObject)this.getOwnObject(object);
            uIObject2.setName(string2);
            uIObject.setName(string);
            String string4 = uIObject2.getName();
            if (string4 == null && string == null) {
                return true;
            }
            if (string4 == null || !string4.equals(string2)) {
                this.setLegalName(uIObject, string3);
                this.setLegalName(uIObject2, string);
                return false;
            }
        }
        return true;
    }

    public boolean hasChangedFromOriginal(Object object) {
        Object object2 = this.getOriginal(object);
        return !this.sameConstruct(object, object2);
    }

    public void updateConstruct(Object object) {
        if (!this.isEmpty(object)) {
            int n = this.handleOverwrite(object);
            if (n == 3 || n == 2) {
                this.updateConstruct(object);
                return;
            }
            if (n == 0) {
                return;
            }
        }
        if (this.hasOriginal(object)) {
            if (!this.added.contains(object)) {
                this.edited.add(object);
            }
            if (!this.hasChangedFromOriginal(object)) {
                this.edited.remove(object);
            }
            this.fireConstructEdited(object);
        } else {
            this.addConstruct(object);
        }
    }

    public void removeConstruct(Object object) {
        this.removeConstructQuiet(object);
        if (!this.hasOriginal(object) && this.isEmpty(object)) {
            return;
        }
        this.fireConstructRemoved(object);
    }

    private void removeConstructQuiet(Object object) {
        Object object2;
        if (!this.isOwnObject(object)) {
            object2 = this.findOwnObject(object);
            if (object2 == null) {
                this.removed.add(object);
                return;
            }
        } else {
            object2 = object;
        }
        if (this.added.contains(object2)) {
            this.added.remove(object2);
        } else {
            if (!this.hasOriginal(object2) && this.isEmpty(object2)) {
                return;
            }
            this.edited.remove(object2);
            this.removed.add(object2);
        }
        if (this.originals.containsValue(object2)) {
            this.originals.remove(this.getOriginal(object2));
        }
    }

    public boolean hasChangedConstructs() {
        return !this.added.isEmpty() || !this.removed.isEmpty() || !this.edited.isEmpty();
    }

    public List collectConstructChanges() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.hasChangedConstructs()) {
            arrayList.add("Changes in " + this.label);
            if (!this.added.isEmpty()) {
                arrayList.add(" Added: " + UIUtil.show(this.added));
            }
            if (!this.removed.isEmpty()) {
                arrayList.add(" Removed: " + UIUtil.show(this.removed));
            }
            if (!this.edited.isEmpty()) {
                arrayList.add(" Edited: " + UIUtil.show(this.edited));
            }
        }
        return arrayList;
    }

    public Object newOwnObject(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        object2 = this.makeOwnObject(object);
        if (object2 != null) {
            this.addedObject(object2, object);
        }
        return object2;
    }

    public Object getOwnObject(Object object) {
        Object object2 = this.findOwnObject(object);
        if (object2 == null) {
            return this.newOwnObject(object);
        }
        return object2;
    }

    public Object findOwnObject(Object object) {
        if (object == null) {
            return null;
        }
        if (this.isOwnObject(object)) {
            return object;
        }
        String string = "";
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Symbol) {
            string = ((Symbol)object).toString();
        }
        if (string != null && !string.equals("")) {
            Object object2 = this.findOwnObject(string, this.added);
            if (object2 == null) {
                object2 = this.findOwnObject(string, this.edited);
            }
            if (object2 == null) {
                object2 = this.findOwnObject(string, this.originals.values());
            }
            return object2;
        }
        Object object3 = this.originals.get(object);
        if (object3 == null) {
            object3 = this.findOwnObject(this.getName(object));
        }
        if (object3 != null) {
            // empty if block
        }
        return object3;
    }

    private Object findOwnObject(String string, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                Object e = iterator.next();
                if (!this.getName(e).equals(string)) continue;
                return e;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public void addedObject(Object object, Object object2) {
        if (object2 == null) {
            this.addConstruct(object);
        } else {
            this.originals.put(object2, object);
        }
    }

    public LinkedList getAllConstructs() {
        LinkedList<Object> linkedList = new LinkedList<Object>(this.added);
        LinkedList linkedList2 = this.getOriginals();
        for (Object e : linkedList2) {
            Object object = this.findOwnObject(e);
            if (object != null) {
                if (this.removed.contains(object) || linkedList.contains(object)) continue;
                linkedList.add(0, object);
                continue;
            }
            if (this.removed.contains(e) || linkedList.contains(e)) continue;
            linkedList.add(e);
        }
        return linkedList;
    }

    public void fireConstructAdded(Object object) {
        this.manager.fireConstructAdded(this, object);
    }

    public void fireConstructEdited(Object object) {
        this.manager.fireConstructEdited(this, object);
    }

    public void fireConstructRemoved(Object object) {
        this.manager.fireConstructRemoved(this, object);
    }

    public String print() {
        LinkedList linkedList = this.getAllConstructs();
        return "[" + linkedList.size() + " " + this.label + "s]";
    }

    public String printSet() {
        LinkedList linkedList = this.getAllConstructs();
        String string = "[";
        for (Object e : linkedList) {
            string = string + this.getName(e) + ", ";
        }
        return string;
    }
}

