/*
 * Decompiled with CFR 0.152.
 */
package ix.itest;

import ix.ichat.ChatMessage;
import ix.icore.Activity;
import ix.icore.IXAgent;
import ix.icore.Issue;
import ix.icore.Priority;
import ix.icore.Report;
import ix.icore.ReportType;
import ix.icore.Sendable;
import ix.icore.TaskItem;
import ix.icore.Variable;
import ix.icore.YesNo;
import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.iface.domain.LTF_Parser;
import ix.iface.domain.SyntaxException;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.GridColumn;
import ix.iface.util.RadioButtonBox;
import ix.iface.util.VerticalPanel;
import ix.ispace.ContactManager;
import ix.ispace.GroupSender;
import ix.itest.DestinationChoice;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Name;
import ix.util.PatternParser;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class SendPanel
extends VerticalPanel
implements ActionListener {
    private static Symbol MESSAGE_COLOR = Symbol.intern("message-color");
    IXAgent agent;
    ContactManager contactManager;
    ActionListener actionListener = CatchingActionListener.listener(this);
    SendTextArea contentText = new SendTextArea(5, 40);
    RadioButtonBox typeSelector = this.makeTypeControl();
    RadioButtonBox prioritySelector = this.makePriorityControl();
    SendControlsPanel sendControls;
    JButton styleButton = new JButton("Style");
    JToggleButton.ToggleButtonModel reportCheckModel = new JToggleButton.ToggleButtonModel();
    DefaultComboBoxModel destinationChoiceModel = new DefaultComboBoxModel<String>(new String[]{"me", "a group ..."});

    public SendPanel(IXAgent iXAgent) {
        this.agent = iXAgent;
        this.contactManager = iXAgent.getContactManager();
        List list = this.contactManager.getSortedNameList();
        for (String string : list) {
            this.destinationChoiceModel.addElement(string);
        }
        this.sendControls = new SendControlsPanel();
        this.setBorder(BorderFactory.createTitledBorder("Compose Message"));
        this.add(new JScrollPane(this.contentText));
        this.addFixedHeight(this.makeControlPanel());
        this.contactManager.setAgentColor(iXAgent.getAgentSymbolName(), null);
        this.styleButton.setForeground(Color.black);
        this.styleButton.addActionListener(this.actionListener);
        this.typeSelector.setSelection("Chat Message");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("SendPanel action:", string);
        if (string.equals("Send")) {
            this.sendTo(this.sendControls.getSelected().getDestination());
        } else if (string.equals("Style")) {
            this.editMessageColor();
        } else {
            throw new ConsistencyException("Nothing to do for", string);
        }
    }

    public void editMessageColor() {
        String string = this.agent.getAgentSymbolName();
        Color color = JColorChooser.showDialog(this, "Color for " + string + " messages", this.contactManager.getAgentColor(string, Color.black));
        if (color == null) {
            return;
        }
        this.contactManager.setAgentColor(string, color);
        this.styleButton.setForeground(color);
    }

    public void initIssue(Issue issue) {
        this.typeSelector.setSelection("Issue");
        ((IssueControls)this.sendControls.mustBe("Issue")).initItem(issue);
    }

    public void initActivity(Activity activity) {
        this.typeSelector.setSelection("Activity");
        ((ActivityControls)this.sendControls.mustBe("Activity")).initItem(activity);
    }

    public void transformToActivity(Issue issue) {
        this.typeSelector.setSelection("Activity");
        ((ActivityControls)this.sendControls.mustBe("Activity")).transformToActivity(issue);
        this.initToMe();
    }

    public void initConstraint(PatternAssignment patternAssignment) {
        this.typeSelector.setSelection("Constraint");
        ((ConstraintControls)this.sendControls.mustBe("Constraint")).initConstraint(patternAssignment);
    }

    public void initConstraintForMe(PatternAssignment patternAssignment) {
        this.initConstraint(patternAssignment);
    }

    public void initToMe() {
        this.sendControls.getSelected().initToMe();
    }

    public void initReport(TaskItem taskItem, Name name, Name name2, ReportType reportType) {
        if (!this.contentText.getText().equals("")) {
            Object[] objectArray = new Object[]{"You have asked to send a report when there", "is unsent text in the display.  Do you want", "to clear the text and set up to send the report?"};
            switch (JOptionPane.showConfirmDialog(null, objectArray, "Confirm", 0)) {
                case 0: {
                    break;
                }
                case 1: {
                    return;
                }
            }
        }
        this.typeSelector.setSelection("Report");
        ((ReportControls)this.sendControls.mustBe("Report")).initReport(taskItem, name, name2, reportType);
    }

    protected void typeChangedTo(String string) {
        Debug.noteln("SendPanel type changed to", string);
    }

    protected void sendTo(String string) {
        Sendable sendable = (Sendable)this.objectFromControls();
        this.send(string, sendable);
        this.contentText.showSent();
    }

    protected void send(String string, Sendable sendable) {
        Color color;
        if (sendable.getSenderId() == null) {
            sendable.setSenderId(Name.valueOf(this.agent.getAgentSymbolName()));
        }
        if (sendable instanceof ChatMessage && (color = this.contactManager.getAgentColor(this.agent.getAgentSymbolName())) != null) {
            ((ChatMessage)sendable).setAnnotation(MESSAGE_COLOR, color);
        }
        Debug.noteln("Sending to", string);
        Debug.noteln("SendPanel contents as XML:", XML.objectToXMLString(sendable));
        this.sending(string, sendable);
        if (string.equalsIgnoreCase("me")) {
            this.agent.handleInput(new IPC.BasicInputMessage(sendable));
        } else if (string.equals("a group ...")) {
            this.sendToGroup(sendable);
        } else {
            IPC.sendObject(string, sendable);
        }
    }

    protected void sending(String string, Sendable sendable) {
    }

    public void sendCopy(String string, Sendable sendable) {
        Sendable sendable2 = (Sendable)Util.clone(sendable);
        this.send(string, sendable2);
    }

    protected void sendToGroup(Sendable sendable) {
        new GroupSender(this.agent, sendable);
    }

    protected Object objectFromControls() {
        String string = this.contentText.getText().trim();
        if (string.equals("")) {
            throw new IllegalArgumentException("Contents are empty");
        }
        return this.sendControls.getSelected().objectFromControls();
    }

    protected Priority priorityFromControls() {
        String string = this.prioritySelector.getSelection();
        Debug.expect(string.endsWith(" Priority"));
        String string2 = Strings.beforeFirst(" ", string);
        return Priority.valueOf(string2.toLowerCase());
    }

    protected JPanel makeControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.typeSelector);
        jPanel.add(this.prioritySelector);
        jPanel.add(Box.createHorizontalGlue());
        VerticalPanel verticalPanel = new VerticalPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.styleButton, "East");
        verticalPanel.add(this.sendControls);
        jPanel.add(verticalPanel);
        return jPanel;
    }

    protected RadioButtonBox makeTypeControl() {
        RadioButtonBox radioButtonBox = RadioButtonBox.createVerticalBox();
        JRadioButton jRadioButton = new JRadioButton("Issue");
        JRadioButton jRadioButton2 = new JRadioButton("Activity");
        JRadioButton jRadioButton3 = new JRadioButton("Constraint");
        JRadioButton jRadioButton4 = new JRadioButton("Annotation");
        JRadioButton jRadioButton5 = new JRadioButton("Report");
        JRadioButton jRadioButton6 = new JRadioButton("Chat Message");
        jRadioButton6.setSelected(true);
        jRadioButton4.setEnabled(false);
        radioButtonBox.add(jRadioButton);
        radioButtonBox.add(jRadioButton2);
        radioButtonBox.add(jRadioButton3);
        radioButtonBox.add(jRadioButton4);
        radioButtonBox.add(jRadioButton5);
        radioButtonBox.add(jRadioButton6);
        radioButtonBox.add(Box.createVerticalGlue());
        radioButtonBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                SendPanel.this.sendControls.showCard(string);
                SendPanel.this.typeChangedTo(string);
            }
        });
        return radioButtonBox;
    }

    protected RadioButtonBox makePriorityControl() {
        RadioButtonBox radioButtonBox = RadioButtonBox.createVerticalBox();
        radioButtonBox.add(new JRadioButton("Highest Priority"));
        radioButtonBox.add(new JRadioButton("High Priority"));
        radioButtonBox.add(new JRadioButton("Normal Priority", true));
        radioButtonBox.add(new JRadioButton("Low Priority"));
        radioButtonBox.add(new JRadioButton("Lowest Priority"));
        radioButtonBox.add(Box.createVerticalGlue());
        return radioButtonBox;
    }

    class ChatMessageControls
    extends SendControls {
        ChatMessageControls() {
            this.addRecipientAndSendButton();
        }

        Object objectFromControls() {
            return this.chatMessageFromControls();
        }

        protected ChatMessage chatMessageFromControls() {
            String string = SendPanel.this.contentText.getText();
            String string2 = (String)SendPanel.this.agent.getAgentIPCName();
            return new ChatMessage(string, string2);
        }
    }

    class ReportControls
    extends SendControls {
        JComboBox reportTypeChoice;
        JTextField refText;

        ReportControls() {
            this.reportTypeChoice = new JComboBox<Object>(ReportType.values().toArray());
            this.refText = new JTextField("");
            this.reportTypeChoice.setSelectedItem(ReportType.INFORMATION);
            this.refText.setEditable(false);
            this.left.add(this.makeLeftLabel("Report Type ="));
            this.right.add(this.reportTypeChoice);
            this.left.add(this.makeLeftLabel("Ref ="));
            this.right.add(this.refText);
            this.addRecipientAndSendButton();
        }

        void initReport(TaskItem taskItem, Name name, Name name2, ReportType reportType) {
            SendPanel.this.contentText.setText("");
            this.reportTypeChoice.setSelectedItem(reportType);
            if (name != null) {
                this.destinationChoice.setSelectedItem(name.toString());
            }
            this.refText.setText(name2 == null ? "" : name2.toString());
        }

        Object objectFromControls() {
            return this.reportFromControls();
        }

        protected Report reportFromControls() {
            String string = SendPanel.this.contentText.getText().trim();
            String string2 = this.refText.getText();
            ReportType reportType = (ReportType)this.reportTypeChoice.getSelectedItem();
            Report report = new Report(string);
            report.setSenderId(Name.valueOf((String)SendPanel.this.agent.getAgentIPCName()));
            report.setPriority(SendPanel.this.priorityFromControls());
            if (!string2.equals("")) {
                report.setRef(Name.valueOf(string2));
            }
            if (!reportType.equals("")) {
                report.setReportType(reportType);
            }
            return report;
        }
    }

    class AnnotationControls
    extends SendControls {
        AnnotationControls() {
            this.addRecipientAndSendButton();
        }

        Object objectFromControls() {
            throw new UnsupportedOperationException();
        }
    }

    class ConstraintControls
    extends SendControls {
        LTF_Parser constraintParser;

        ConstraintControls() {
            this.constraintParser = new LTF_Parser();
            this.addRecipientAndSendButton();
        }

        public void initConstraint(PatternAssignment patternAssignment) {
            SendPanel.this.contentText.setText(Lisp.elementsToString(patternAssignment.getPattern()) + " = " + Lisp.printToString(patternAssignment.getValue()));
        }

        Object objectFromControls() {
            return this.constraintFromControls();
        }

        protected Constraint constraintFromControls() {
            String string;
            LList lList;
            Constraint constraint;
            String string2 = SendPanel.this.contentText.getText().trim();
            String[] stringArray = Strings.breakAtFirst("=", string2);
            String string3 = stringArray[0].trim();
            String string4 = stringArray[1].trim();
            if (string4.equals("")) {
                string4 = "true";
            }
            if ((constraint = this.constraintParser.parseConstraint(lList = (LList)Lisp.readFromString(string = "(world-state effect (" + string3 + ") = " + string4 + ")"))) == null) {
                throw new SyntaxException("Invalid constraint: " + Strings.quote(string2));
            }
            constraint.setSenderId(Name.valueOf((String)SendPanel.this.agent.getAgentIPCName()));
            return constraint;
        }
    }

    class ActivityControls
    extends IssueActivityControls {
        Issue fromIssue;

        ActivityControls() {
            this.fromIssue = null;
        }

        protected void initItem(TaskItem taskItem) {
            super.initItem(taskItem);
            this.fromIssue = null;
        }

        void transformToActivity(Issue issue) {
            super.initItem(issue);
            this.fromIssue = issue;
        }

        Object objectFromControls() {
            return this.activityFromControls();
        }

        protected Activity activityFromControls() {
            Activity activity = (Activity)this.fillTaskItemFromControls(new Activity());
            if (this.fromIssue != null) {
                Name name = this.fromIssue.getSenderId();
                Debug.noteln("Transform sender-id", name);
                activity.setSenderId(name);
                Name name2 = this.fromIssue.getRef();
                Debug.noteln("Transform ref", name2);
                activity.setRef(name2);
            }
            return activity;
        }
    }

    class IssueControls
    extends IssueActivityControls {
        IssueControls() {
        }

        Object objectFromControls() {
            return this.issueFromControls();
        }

        protected Issue issueFromControls() {
            return (Issue)this.fillTaskItemFromControls(new Issue());
        }
    }

    abstract class IssueActivityControls
    extends SendControls {
        JCheckBox reportCheck;

        IssueActivityControls() {
            this.reportCheck = new JCheckBox("Report-back");
            this.reportCheck.setModel(SendPanel.this.reportCheckModel);
            this.left.add(new JLabel(""));
            this.right.add(this.reportCheck);
            this.addRecipientAndSendButton();
        }

        protected void initItem(TaskItem taskItem) {
            LList lList = (LList)Variable.removeVars(taskItem.getPattern());
            SendPanel.this.contentText.setText(PatternParser.unparse(lList));
            SendPanel.this.prioritySelector.setSelection(Strings.capitalize(taskItem.getPriority().toString()) + " Priority");
            this.reportCheck.setSelected(taskItem.getReportBack() == YesNo.YES);
        }

        protected TaskItem fillTaskItemFromControls(TaskItem taskItem) {
            String string = SendPanel.this.contentText.getText().trim();
            boolean bl = this.reportCheck.isSelected();
            taskItem.setPattern(PatternParser.parse(string));
            taskItem.setSenderId(Name.valueOf(SendPanel.this.agent.getAgentSymbolName()));
            taskItem.setPriority(SendPanel.this.priorityFromControls());
            if (bl) {
                taskItem.setReportBack(YesNo.YES);
            }
            return taskItem;
        }
    }

    abstract class SendControls
    extends JPanel {
        GridColumn left = new GridColumn();
        GridColumn right = new GridColumn();
        DestinationChoice destinationChoice;
        JButton sendButton;

        SendControls() {
            this.destinationChoice = new DestinationChoice(SendPanel.this.agent, SendPanel.this.destinationChoiceModel);
            this.sendButton = new JButton("Send", Util.resourceImageIcon("ip2-send.gif"));
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.left);
            this.add(this.right);
            this.sendButton.setHorizontalTextPosition(2);
            this.sendButton.addActionListener(SendPanel.this.actionListener);
        }

        String getDestination() {
            return this.destinationChoice.getSelectedString();
        }

        abstract Object objectFromControls();

        void initToMe() {
            this.destinationChoice.setSelectedItem("me");
        }

        void addRecipientAndSendButton() {
            this.left.add(this.makeLeftLabel("Recipient ="));
            this.right.add(this.destinationChoice);
            this.left.add(new JLabel(""));
            this.right.add(this.sendButton);
        }

        JLabel makeLeftLabel(String string) {
            JLabel jLabel = new JLabel(string);
            jLabel.setForeground(Color.black);
            jLabel.setHorizontalAlignment(11);
            return jLabel;
        }
    }

    class CardPanel
    extends JPanel {
        CardLayout cards = new CardLayout();
        Map nameToComp = new HashMap();
        Component selected = null;

        CardPanel() {
            this.setLayout(this.cards);
        }

        void addCard(String string, Component component) {
            this.nameToComp.put(string, component);
            this.add(this.wrapCard(component), string);
        }

        Component wrapCard(Component component) {
            return component;
        }

        Component getCard(String string) {
            Component component = (Component)this.nameToComp.get(string);
            Debug.expect(component != null, "No card named", string);
            return component;
        }

        void showCard(String string) {
            this.selected = this.getCard(string);
            this.cards.show(this, string);
        }

        Component getSelectedCard() {
            Debug.expect(this.selected != null, "No selected card");
            return this.selected;
        }
    }

    class SendControlsPanel
    extends CardPanel {
        SendControlsPanel() {
            this.addCard("Issue", new IssueControls());
            this.addCard("Activity", new ActivityControls());
            this.addCard("Constraint", new ConstraintControls());
            this.addCard("Annotation", new AnnotationControls());
            this.addCard("Report", new ReportControls());
            this.addCard("Chat Message", new ChatMessageControls());
        }

        SendControls getSelected() {
            return (SendControls)super.getSelectedCard();
        }

        SendControls mustBe(String string) {
            SendControls sendControls = this.getSelected();
            Debug.expectSame(sendControls, this.getCard(string));
            return sendControls;
        }

        Component wrapCard(Component component) {
            VerticalPanel verticalPanel = new VerticalPanel();
            verticalPanel.addFixedHeight(component);
            verticalPanel.add(new JPanel());
            return verticalPanel;
        }
    }

    class SendTextArea
    extends JTextArea {
        boolean inSentState;

        SendTextArea(int n, int n2) {
            super(n, n2);
            this.inSentState = false;
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (SendTextArea.this.inSentState) {
                        SendTextArea.this.clearSent();
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (SendTextArea.this.inSentState) {
                        SendTextArea.this.clearSent();
                        SendTextArea.this.setSelectionStart(0);
                        SendTextArea.this.setSelectionEnd(SendTextArea.this.getText().length());
                    }
                }
            });
        }

        public void setText(String string) {
            if (this.inSentState) {
                this.clearSent();
            }
            super.setText(string);
        }

        void showSent() {
            this.setForeground(MetalLookAndFeel.getControlDisabled());
            this.inSentState = true;
        }

        void clearSent() {
            this.setForeground(MetalLookAndFeel.getBlack());
            this.inSentState = false;
        }
    }
}

