/*
 * Decompiled with CFR 0.152.
 */
package ix.ispace;

import ix.icore.IXAgent;
import ix.iface.util.IFUtil;
import ix.iface.util.IconImage;
import ix.iface.util.KeyValueTable;
import ix.iface.util.SelectionPanel;
import ix.iface.util.ToolFrame;
import ix.iface.util.ValueComboBox;
import ix.ispace.AgentData;
import ix.ispace.AgentRelationship;
import ix.ispace.ContactManager;
import ix.ispace.ListOfCapability;
import ix.ispace.VerbCapability;
import ix.ispace.event.ContactEvent;
import ix.ispace.event.ContactListener;
import ix.util.Collect;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.Strings;
import ix.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ISpaceTool
implements ActionListener {
    IXAgent agent;
    ContactManager contactManager;
    JFrame frame;
    Container contentPane;
    JTabbedPane tabbedPane = new JTabbedPane();
    RelationPanel relationPanel;
    CapabilityPanel capabilityPanel;

    public ISpaceTool(IXAgent iXAgent) {
        this.agent = iXAgent;
        this.contactManager = iXAgent.getContactManager();
        this.setupFrame();
    }

    void setupFrame() {
        this.frame = new ToolFrame(this.agent.getAgentDisplayName() + " I-Space");
        this.frame.setIconImage(IconImage.getIconImage(this));
        this.frame.setJMenuBar(this.makeMenuBar());
        this.contentPane = this.frame.getContentPane();
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.relationPanel = new RelationPanel();
        this.contactManager.addContactListener(this.relationPanel);
        this.addTab("Relations", this.relationPanel);
        this.capabilityPanel = new CapabilityPanel();
        this.contactManager.addContactListener(this.capabilityPanel);
        this.addTab("Capabilities", this.capabilityPanel);
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void addMenu(JMenu jMenu) {
        this.frame.getJMenuBar().add(jMenu);
    }

    public void addTab(String string, Component component) {
        this.tabbedPane.add(string, component);
        this.frame.pack();
    }

    protected JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.add(IFUtil.makeMenuItem("Close", this));
        return jMenuBar;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("I-Space Tool action:", string);
        if (!string.equals("Close")) {
            throw new ConsistencyException("Nothing to do for " + string);
        }
        this.frame.setVisible(false);
    }

    class CapabilityTable
    extends KeyValueTable {
        CapabilityTable(Map map) {
            super(map, "Agent", "Verb Capabilities");
            this.keySortComparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((String)object).compareTo((String)object2);
                }
            };
        }

        protected String keyToString(Object object) {
            return (String)object;
        }

        protected String valueToString(Object object) {
            return Collect.elementsToString((List)object, new Function1(){

                public Object funcall(Object object) {
                    return ((VerbCapability)object).getVerb();
                }
            });
        }

        protected KeyValueTable.RowPopupMenu makePopupMenu() {
            return new CapabilityPopupMenu();
        }

        protected void doPopupAction(ActionEvent actionEvent, int n, Object object) {
            String string = actionEvent.getActionCommand();
            Debug.expectEquals("Edit Capabilities", string);
            String string2 = this.valueToString(this.getValue(object));
            String string3 = Util.showInputDialog(this.getJTable(), "Edit Capabilities of " + object, string2);
            if (string3 == null) {
                return;
            }
            List list = Strings.breakAt(",", string3);
            LinkedList<VerbCapability> linkedList = new LinkedList<VerbCapability>();
            for (String string4 : list) {
                linkedList.add(new VerbCapability(string4.trim()));
            }
            ISpaceTool.this.contactManager.setCapabilities((String)object, linkedList);
        }

        class CapabilityPopupMenu
        extends KeyValueTable.RowPopupMenu {
            CapabilityPopupMenu() {
                this.add(this.makeMenuItem("Edit Capabilities"));
            }
        }
    }

    class CapabilityPanel
    extends JPanel
    implements ContactListener {
        CapabilityTable capabilityTable;

        CapabilityPanel() {
            this.capabilityTable = new CapabilityTable(this.getCapabilityMap());
            this.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(this.capabilityTable.getJTable());
            this.add((Component)jScrollPane, "Center");
        }

        Map getCapabilityMap() {
            List list = ISpaceTool.this.contactManager.getAgentData();
            HashMap<String, ListOfCapability> hashMap = new HashMap<String, ListOfCapability>();
            for (AgentData agentData : list) {
                hashMap.put(agentData.getName(), agentData.getCapabilities());
            }
            return hashMap;
        }

        public void contactChange(ContactEvent contactEvent) {
            if (contactEvent.isNewContact() || contactEvent.isCapabilityChange()) {
                AgentData agentData = contactEvent.getNewData();
                this.capabilityTable.recordNewValue(agentData.getName(), agentData.getCapabilities());
            } else if (contactEvent.isDeletion()) {
                this.capabilityTable.deleteEntry(contactEvent.getOldData().getName());
            }
        }
    }

    static class RelationComboBox
    extends ValueComboBox {
        public RelationComboBox() {
            for (AgentRelationship agentRelationship : AgentRelationship.values()) {
                this.addItem(Strings.capitalize(agentRelationship.toString()));
            }
            this.addItem("Delete");
            this.setSelectedValue(AgentRelationship.CONTACT);
        }

        public Object getSelectedValue() {
            String string = (String)this.getSelectedItem();
            return string == "Delete" ? null : AgentRelationship.valueOf(string.toLowerCase());
        }

        public void setSelectedValue(Object object) {
            AgentRelationship agentRelationship = (AgentRelationship)object;
            this.setSelectedItem(Strings.capitalize(agentRelationship.toString()));
        }
    }

    class RelationPanel
    extends SelectionPanel
    implements ContactListener {
        RelationPanel() {
            super(ISpaceTool.this.frame, "Agent", "Relation");
            this.load();
        }

        protected ValueComboBox makeValueComboBox() {
            return new RelationComboBox();
        }

        protected Map getCurrentValueMap() {
            List list = ISpaceTool.this.contactManager.getAgentData();
            TreeMap<String, AgentRelationship> treeMap = new TreeMap<String, AgentRelationship>();
            for (AgentData agentData : list) {
                treeMap.put(agentData.getName(), agentData.getRelationship());
            }
            return treeMap;
        }

        protected void entryDeleted(String string) {
            ISpaceTool.this.contactManager.deleteAgent(string);
        }

        protected void valueChanged(String string, Object object) {
            ISpaceTool.this.contactManager.changeRelationship(string, (AgentRelationship)object);
        }

        protected void entryAdded(String string, Object object) {
            AgentRelationship agentRelationship = (AgentRelationship)object;
            Debug.noteln("Adding agent " + string + " as " + agentRelationship);
            if (ISpaceTool.this.contactManager.getAgentData(string) != null) {
                JOptionPane.showMessageDialog(ISpaceTool.this.frame, "Agent " + string + " already exists", "Error", 0);
                return;
            }
            ISpaceTool.this.contactManager.addAgent(string, agentRelationship);
        }

        public void contactChange(ContactEvent contactEvent) {
            if (contactEvent.isNewContact()) {
                String string = contactEvent.getNewData().getName();
                AgentRelationship agentRelationship = contactEvent.getNewData().getRelationship();
                this.addTableEntry(string, agentRelationship);
                return;
            }
            this.reload();
        }
    }
}

