/*
 * Decompiled with CFR 0.152.
 */
package ix.isim;

import ix.icore.Activity;
import ix.isim.ISimEngine;
import ix.isim.TimedEvent;
import ix.isim.util.LongPriorityQueue;
import ix.util.Duration;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

class EventsTableModel
extends AbstractTableModel {
    static final int NROFCOLS = 4;
    static final int STATUS = 0;
    static final int TIME = 1;
    static final int THREAD = 2;
    static final int EVENT = 3;
    static final String[] titles = new String[]{"Status", "Time", "Thread", "Event"};
    static final Class[] types = new Class[]{String.class, String.class, String.class, Activity.class};
    private static DateFormat df = DateFormat.getDateTimeInstance(3, 3);
    protected List events = new ArrayList();
    protected Map eventRows = new HashMap();
    private ISimEngine simulator;

    public EventsTableModel(ISimEngine iSimEngine) {
        this.simulator = iSimEngine;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int n) {
        return titles[n];
    }

    public Class getColumnClass(int n) {
        return types[n];
    }

    public int getRowCount() {
        return this.events.size();
    }

    public synchronized void eventUpdated(TimedEvent timedEvent) {
        Integer n = (Integer)this.eventRows.get(timedEvent);
        if (n != null) {
            this.fireTableRowsUpdated(n, n);
        } else {
            this.simulator.updateUI();
        }
        Thread.currentThread();
        Thread.yield();
    }

    public Object getValueAt(int n, int n2) {
        TimedEvent timedEvent = (TimedEvent)this.events.get(n);
        switch (n2) {
            case 0: {
                return TimedEvent.statusString[timedEvent.getStatus()];
            }
            case 1: {
                long l = this.simulator.getSimStartTime();
                if (l != 0L) {
                    return df.format(new Date(l + timedEvent.timeInMillis));
                }
                return new Duration(timedEvent.timeInMillis).toISOString();
            }
            case 2: {
                return timedEvent.getThread();
            }
            case 3: {
                return timedEvent.getActivity();
            }
        }
        throw new IllegalArgumentException("Column not in model.");
    }

    public synchronized void makeRowsFromQueue(List list, List list2, LongPriorityQueue longPriorityQueue) {
        ArrayList<TimedEvent> arrayList = new ArrayList<TimedEvent>();
        HashMap<TimedEvent, Integer> hashMap = new HashMap<TimedEvent, Integer>();
        int n = 0;
        for (TimedEvent timedEvent : list) {
            arrayList.add(timedEvent);
            hashMap.put(timedEvent, new Integer(n++));
        }
        for (TimedEvent timedEvent : list2) {
            arrayList.add(timedEvent);
            hashMap.put(timedEvent, new Integer(n++));
        }
        Iterator iterator = longPriorityQueue.elements();
        while (iterator.hasNext()) {
            TimedEvent timedEvent;
            timedEvent = (TimedEvent)iterator.next();
            arrayList.add(timedEvent);
            hashMap.put(timedEvent, new Integer(n++));
        }
        this.events = arrayList;
        this.eventRows = hashMap;
        this.fireTableDataChanged();
        Thread.currentThread();
        Thread.yield();
    }
}

