/*
 * Decompiled with CFR 0.152.
 */
package ix.iscript;

import ix.iscript.And;
import ix.iscript.Assignment;
import ix.iscript.Binding;
import ix.iscript.Call;
import ix.iscript.Expression;
import ix.iscript.If;
import ix.iscript.Lambda;
import ix.iscript.Let;
import ix.iscript.ListOfExpression;
import ix.iscript.Literal;
import ix.iscript.Or;
import ix.iscript.Sequence;
import ix.iscript.VarRef;
import ix.iscript.While;
import ix.util.ConsistencyException;
import ix.util.ListOfName;
import ix.util.Util;
import ix.util.lisp.Interpreter;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IScriptParser {
    public Interpreter.Expr parseExpression(String string) {
        Object object = XML.objectFromXML(string);
        Expression expression = (Expression)Util.mustBe(Expression.class, object);
        return this.parseExpression(expression);
    }

    public Interpreter.Expr parseExpression(Expression expression) {
        Interpreter.Expr expr = this.do_parseExpression(expression);
        expr.setDescription(expression);
        return expr;
    }

    Interpreter.Expr do_parseExpression(Expression expression) {
        if (expression instanceof Literal) {
            return this.parseLiteral((Literal)expression);
        }
        if (expression instanceof VarRef) {
            return this.parseVarRef((VarRef)expression);
        }
        if (expression instanceof Call) {
            return this.parseCall((Call)expression);
        }
        if (expression instanceof Assignment) {
            return this.parseAssignment((Assignment)expression);
        }
        if (expression instanceof If) {
            return this.parseIf((If)expression);
        }
        if (expression instanceof Sequence) {
            return this.parseSequence((Sequence)expression);
        }
        if (expression instanceof And) {
            return this.parseAnd((And)expression);
        }
        if (expression instanceof Or) {
            return this.parseOr((Or)expression);
        }
        if (expression instanceof Let) {
            return this.parseLet((Let)expression);
        }
        if (expression instanceof Lambda) {
            return this.parseLambda((Lambda)expression);
        }
        if (expression instanceof While) {
            return this.parseWhile((While)expression);
        }
        throw new ConsistencyException("Unknown I-Script expression type", expression);
    }

    List parseList(ListOfExpression listOfExpression) {
        LinkedList<Interpreter.Expr> linkedList = new LinkedList<Interpreter.Expr>();
        Iterator iterator = listOfExpression.iterator();
        while (iterator.hasNext()) {
            linkedList.add(this.parseExpression((Expression)iterator.next()));
        }
        return linkedList;
    }

    Interpreter.Literal parseLiteral(Literal literal) {
        return new Interpreter.Literal(literal.getValue());
    }

    Interpreter.VarRef parseVarRef(VarRef varRef) {
        return new Interpreter.VarRef(Symbol.intern(varRef.getName().toString()));
    }

    Interpreter.Call parseCall(Call call) {
        return new Interpreter.Call(this.parseExpression(call.getFunction()), this.parseList(call.getArguments()));
    }

    Interpreter.Assignment parseAssignment(Assignment assignment) {
        return new Interpreter.Assignment(Symbol.intern(assignment.getTo().toString()), this.parseExpression(assignment.getValue()));
    }

    Interpreter.If parseIf(If if_) {
        return new Interpreter.If(this.parseExpression(if_.getTest()), this.parseExpression(if_.getIfTrue()), this.parseExpression(if_.getIfFalse()));
    }

    Interpreter.Sequence parseSequence(Sequence sequence) {
        return new Interpreter.Sequence(this.parseList(sequence.getOf()));
    }

    Interpreter.And parseAnd(And and) {
        return new Interpreter.And(this.parseList(and.getOf()));
    }

    Interpreter.Or parseOr(Or or) {
        return new Interpreter.Or(this.parseList(or.getOf()));
    }

    Interpreter.Let parseLet(Let let) {
        LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
        LinkedList<Interpreter.Expr> linkedList2 = new LinkedList<Interpreter.Expr>();
        for (Binding binding : let.getBindings()) {
            linkedList.add(Symbol.intern(binding.getName().toString()));
            linkedList2.add(this.parseExpression(binding.getValue()));
        }
        return new Interpreter.Let(linkedList, linkedList2, this.parseExpression(let.getIn()));
    }

    Interpreter.Lambda parseLambda(Lambda lambda) {
        return new Interpreter.Lambda(this.makeSymbolList(lambda.getParameters()), this.parseExpression(lambda.getIn()));
    }

    private List makeSymbolList(ListOfName listOfName) {
        LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
        Iterator iterator = listOfName.iterator();
        while (iterator.hasNext()) {
            linkedList.add(Symbol.intern(iterator.next().toString()));
        }
        return linkedList;
    }

    Interpreter.While parseWhile(While while_) {
        return new Interpreter.While(this.parseExpression(while_.getTest()), this.parseExpression(while_.getRepeat()));
    }
}

