/*
 * Decompiled with CFR 0.152.
 */
package ix.iscript;

import ix.iscript.Expression;
import ix.iscript.IScriptParser;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Util;
import ix.util.lisp.Lisp;
import ix.util.lisp.LispInterpreter;
import ix.util.xml.XML;

public class IScriptInterpreter {
    IScriptParser parser = new IScriptParser();
    IScriptLispInterpreter lisp = new IScriptLispInterpreter();

    public static void main(String[] stringArray) {
        Parameters.processCommandLineArguments(stringArray);
        IScriptInterpreter iScriptInterpreter = new IScriptInterpreter();
        while (true) {
            System.out.println("I-Script:");
            try {
                Object object;
                Expression expression;
                Object object2;
                String string = Util.readLines();
                if (string.startsWith("<")) {
                    object2 = XML.objectFromXML(string);
                    expression = (Expression)Util.mustBe(Expression.class, object2);
                    object = iScriptInterpreter.topLevelEval(expression);
                    System.out.println(object);
                    continue;
                }
                object2 = Lisp.readFromString(string);
                expression = iScriptInterpreter.lisp.parseForm(object2).externalForm();
                object = iScriptInterpreter.topLevelEval(expression);
                System.out.println("In XML syntax:");
                System.out.println(expression.toString());
                System.out.println("Result:");
                System.out.println(object);
                System.out.println("");
                continue;
            }
            catch (Throwable throwable) {
                Debug.noteException(throwable);
                continue;
            }
            break;
        }
    }

    public Object topLevelEval(Expression expression) {
        return this.lisp.topLevelEval(this.parser.parseExpression(expression));
    }

    class IScriptLispInterpreter
    extends LispInterpreter {
        IScriptLispInterpreter() {
        }

        protected void defineSyntax() {
            super.defineSyntax();
        }
    }
}

