/*
 * Decompiled with CFR 0.152.
 */
package ix.iquery;

import ix.icore.Activity;
import ix.icore.Report;
import ix.icore.ReportType;
import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.iface.util.Reporting;
import ix.iquery.IQuery;
import ix.util.IPC;
import ix.util.Name;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.util.List;

public abstract class LookupHandler {
    protected IQuery queryAgent;
    protected Activity lookupActivity;

    public LookupHandler(IQuery iQuery, Activity activity) {
        this.queryAgent = iQuery;
        this.lookupActivity = activity;
    }

    protected void transcript(final String string) {
        Util.swingAndWait(new Runnable(){

            public void run() {
                LookupHandler.this.do_transcript(string);
            }
        });
    }

    private void do_transcript(String string) {
        this.queryAgent.do_transcript(string);
    }

    protected void sendReport(ReportType reportType, String string) {
        this.sendReport(this.lookupActivity, reportType, string);
    }

    protected void sendReport(Activity activity, ReportType reportType, String string) {
        this.sendAbout(activity, this.makeReport(activity, reportType, string));
    }

    protected Report makeReport(ReportType reportType, String string) {
        return this.makeReport(this.lookupActivity, reportType, string);
    }

    protected Report makeReport(Activity activity, ReportType reportType, String string) {
        Name name = Name.valueOf(this.queryAgent.getAgentIPCName());
        Report report = new Report(string);
        report.setReportType(reportType);
        report.setRef(activity.getRef());
        report.setSenderId(name);
        return report;
    }

    protected void sendReply(Object object) {
        this.sendAbout(this.lookupActivity, object);
    }

    protected void sendAbout(Activity activity, Object object) {
        this.sendTo(activity.getSenderId(), object);
    }

    protected void sendTo(final Object object, final Object object2) {
        Util.swingAndWait(new Runnable(){

            public void run() {
                LookupHandler.this.do_transcript("Sending " + Reporting.description(object2));
                String string = object.toString();
                IPC.sendObject(string, object2);
            }
        });
    }

    protected Constraint makeStateConstraint(LList lList, Object object) {
        return new Constraint("world-state", "effect", (List)Lisp.list(new PatternAssignment(lList, object)));
    }

    protected Constraint makeStateConstraint(LList lList) {
        return new Constraint("world-state", "effect", (List)Lisp.list(new PatternAssignment(lList)));
    }

    protected Constraint makeStateConstraint(String string, Object object) {
        return this.makeStateConstraint(Lisp.elementsFromString(string), object);
    }

    protected Constraint makeStateConstraint(String string) {
        return this.makeStateConstraint(Lisp.elementsFromString(string));
    }

    protected abstract void handleLookup();
}

