/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.process.PNode;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.iplan.ChecksimPlanEvaluation;
import ix.iplan.PlanEvalManager;
import ix.iplan.PlanEvaluation;
import ix.iplan.PlanEvaluator;
import ix.iplan.SimplePlanEvaluation;
import ix.iplan.SlipStats;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TechnicalPlanEvalManager
extends PlanEvalManager {
    protected List planEvaluators = new LinkedList();

    public void addPlanEvaluators() {
        this.addPlanEvaluator(new IssueCountEval());
        this.addPlanEvaluator(new NodeCountEval());
        this.addPlanEvaluator(new LongestPathLengthEval());
        this.addPlanEvaluator(new ObjectUseEval());
        this.addPlanEvaluator(new ObjectCountEval());
        this.addPlanEvaluator(new ChecksimEval());
    }

    public static class ChecksimEval
    extends PlanEvaluator {
        public ChecksimEval() {
            super("simulated execution");
        }

        public PlanEvaluation evaluatePlan(Ip2 ip2, String string) {
            return new ChecksimPlanEvaluation(ip2, string);
        }
    }

    public static class ObjectCountEval
    extends PlanEvaluator {
        public ObjectCountEval() {
            super("objects in state");
        }

        public PlanEvaluation evaluatePlan(Ip2 ip2, String string) {
            Ip2ModelManager ip2ModelManager = (Ip2ModelManager)ip2.getModelManager();
            Map map = ip2ModelManager.getWorldStateMap();
            HashSet<Object> hashSet = new HashSet<Object>();
            for (LList lList : map.keySet()) {
                if (lList.cdr().isEmpty()) continue;
                Object object = lList.get(1);
                hashSet.add(object);
            }
            return new SimplePlanEvaluation(hashSet.size());
        }
    }

    public static class ObjectUseEval
    extends PlanEvaluator {
        public ObjectUseEval() {
            super("objects used in plan");
        }

        public PlanEvaluation evaluatePlan(Ip2 ip2, String string) {
            Ip2ModelManager ip2ModelManager = (Ip2ModelManager)ip2.getModelManager();
            HashSet hashSet = new HashSet();
            for (PNode pNode : ip2ModelManager.getNodes()) {
                this.collectObjects(hashSet, ip2ModelManager.getNodeConditions(pNode));
                this.collectObjects(hashSet, ip2ModelManager.getNodeEffects(pNode));
            }
            return new SimplePlanEvaluation(hashSet.size());
        }

        void collectObjects(Set set, List list) {
            if (list == null) {
                return;
            }
            for (Object e : list) {
                Object object;
                PatternAssignment patternAssignment;
                if (e instanceof PatternAssignment) {
                    patternAssignment = (PatternAssignment)e;
                } else {
                    object = (Constraint)e;
                    if (((Constraint)object).getType() != Refinement.S_WORLD_STATE) continue;
                    patternAssignment = ((Constraint)object).getPatternAssignment();
                }
                if ((object = patternAssignment.getPattern().get(1)) == Lisp.NIL) continue;
                set.add(object);
            }
        }
    }

    public static class LongestPathLengthEval
    extends PlanEvaluator {
        public LongestPathLengthEval() {
            super("longest path length");
        }

        public PlanEvaluation evaluatePlan(Ip2 ip2, String string) {
            Ip2ModelManager ip2ModelManager = (Ip2ModelManager)ip2.getModelManager();
            List list = ip2ModelManager.getNodeEnds();
            int n = new SlipStats(null).calcLongestPathLength(list);
            return new SimplePlanEvaluation(n);
        }
    }

    public static class NodeCountEval
    extends PlanEvaluator {
        public NodeCountEval() {
            super("activities in plan");
        }

        public PlanEvaluation evaluatePlan(Ip2 ip2, String string) {
            int n = ip2.getModelManager().getNodes().size();
            return new SimplePlanEvaluation(n);
        }
    }

    public static class IssueCountEval
    extends PlanEvaluator {
        public IssueCountEval() {
            super("issues in plan");
        }

        public PlanEvaluation evaluatePlan(Ip2 ip2, String string) {
            int n = ip2.getController().getIssueAgenda().getItems().size();
            return new SimplePlanEvaluation(n);
        }
    }

    public static class TaskDescriptionEval
    extends PlanEvaluator {
        public TaskDescriptionEval() {
            super("Task");
        }

        public PlanEvaluation evaluatePlan(Ip2 ip2, String string) {
            return new SimplePlanEvaluation(".");
        }
    }
}

