/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.iplan.Slip;
import ix.iplan.SlipStats;
import ix.util.Debug;
import ix.util.Util;
import ix.util.context.Context;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.util.HashMap;
import java.util.Map;

public class SlipSingleStepper {
    Slip slip;
    Map commandTable = new HashMap();
    Trigger trigger;
    Trigger instantTrigger = new Trigger(){

        boolean isTriggered() {
            return true;
        }
    };
    String[] helpText = new String[]{"nodes", "alts", "contexts", "help"};

    public SlipSingleStepper(Slip slip) {
        this.define(new Command("nodes"){

            void run(LList lList) {
                SlipSingleStepper.this.slip.describeNodeEnds();
            }
        });
        this.define(new Command("alts"){

            void run(LList lList) {
                SlipSingleStepper.this.slip.describeAlternatives();
            }
        });
        this.define(new Command("contexts"){

            void run(LList lList) {
                Context.printContextTree();
            }
        });
        this.define(new Command("help"){

            void run(LList lList) {
                Util.printLines(SlipSingleStepper.this.helpText);
            }
        });
        this.slip = slip;
        this.trigger = this.instantTrigger;
    }

    public void step() {
        if (this.trigger.isTriggered()) {
            this.trigger = this.instantTrigger;
            this.singleStepBreakLoop();
        }
    }

    void singleStepBreakLoop() {
        SlipStats slipStats = (SlipStats)this.slip.getStatistics();
        String string = "Step " + (slipStats.numberStepsTaken + 1) + ":";
        String string2;
        LList lList;
        while (!(lList = Lisp.elementsFromString(string2 = Util.askLine(string))).isEmpty()) {
            this.evalCommand(lList);
        }
        return;
    }

    void evalCommand(LList lList) {
        String string = lList.car().toString();
        Command command = (Command)this.commandTable.get(string);
        if (command == null) {
            Debug.noteln("I don't know how to", string);
        } else {
            command.run(lList.cdr());
        }
    }

    void define(Command command) {
        this.commandTable.put(command.name, command);
    }

    abstract class Command {
        String name;

        Command(String string) {
            this.name = string;
        }

        abstract void run(LList var1);
    }

    abstract class Trigger {
        Trigger() {
        }

        abstract boolean isTriggered();
    }
}

