/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Status;
import ix.icore.domain.ListOfConstraint;
import ix.icore.process.PNode;
import ix.ip2.AgendaItem;
import ix.iplan.Alternative;
import ix.iplan.IPlanModelManager;
import ix.iplan.Slip;
import ix.iplan.SlipFindExecutable;
import ix.util.ConsistencyException;
import ix.util.match.MatchEnv;
import java.util.LinkedList;
import java.util.List;

class SlipSatisfyConds
implements Runnable {
    Slip slip;
    AgendaItem item;
    ListOfConstraint conds;

    SlipSatisfyConds(Slip slip) {
        this.slip = slip;
    }

    SlipSatisfyConds(Slip slip, PNode pNode, ListOfConstraint listOfConstraint) {
        this.slip = slip;
        this.item = (AgendaItem)pNode;
        this.conds = listOfConstraint;
    }

    public void run() {
        IPlanModelManager iPlanModelManager = this.slip.MM();
        List list = iPlanModelManager.evalFilters(this.conds, new MatchEnv());
        this.checkCondsSatisfied(list);
        if (list.size() == 1) {
            iPlanModelManager.satisfyConds(this.item, this.conds, (MatchEnv)list.get(0));
            this.adjustStatus(this.item);
            this.slip.setNextStep(new SlipFindExecutable(this.slip));
            return;
        }
        LinkedList linkedList = (LinkedList)list;
        MatchEnv matchEnv = (MatchEnv)linkedList.removeFirst();
        this.slip.postAlternative(new ResumeSatisfaction(this.item, this.conds, linkedList));
        iPlanModelManager.satisfyConds(this.item, this.conds, matchEnv);
        this.adjustStatus(this.item);
        this.slip.setNextStep(new SlipFindExecutable(this.slip));
    }

    void checkCondsSatisfied(List list) {
        if (list.isEmpty()) {
            throw new ConsistencyException("Cannot match filter conditions", this.conds);
        }
    }

    void adjustStatus(AgendaItem agendaItem) {
        this.slip.setStatus(agendaItem.getBegin(), Status.COMPLETE);
    }

    class ResumeSatisfaction
    extends Alternative {
        AgendaItem item;
        ListOfConstraint conds;
        LinkedList condEnvs;

        ResumeSatisfaction(AgendaItem agendaItem, ListOfConstraint listOfConstraint, LinkedList linkedList) {
            this.item = agendaItem;
            this.conds = listOfConstraint;
            this.condEnvs = linkedList;
        }

        public void run() {
            MatchEnv matchEnv = (MatchEnv)this.condEnvs.removeFirst();
            if (!this.condEnvs.isEmpty()) {
                SlipSatisfyConds.this.slip.postAlternative(new ResumeSatisfaction(this.item, this.conds, this.condEnvs));
            }
            SlipSatisfyConds.this.slip.MM().satisfyConds(this.item, this.conds, matchEnv);
            SlipSatisfyConds.this.adjustStatus(this.item);
            SlipSatisfyConds.this.slip.setNextStep(new SlipFindExecutable(SlipSatisfyConds.this.slip));
        }
    }
}

