/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.iface.util.HtmlStringWriter;
import ix.iface.util.IFUtil;
import ix.iface.util.IXHtmlEditorKit;
import ix.iface.util.IconImage;
import ix.iface.util.ToolFrame;
import ix.ip2.Ip2;
import ix.iplan.IPlanOptionManager;
import ix.iplan.OptionUI;
import ix.iplan.PlanEvaluation;
import ix.iplan.PlanEvaluator;
import ix.iplan.event.OptionEvent;
import ix.iplan.event.OptionListener;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Gensym;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class IPlanOptionTool {
    Ip2 ip2;
    IPlanOptionManager optMan;
    OptionToolFrame frame;
    OptionTree optionTree;
    OptionMatrix optionMatrix;

    public IPlanOptionTool(Ip2 ip2) {
        this.ip2 = ip2;
        this.optMan = ip2.getOptionManager();
        Debug.expect(this.optMan != null, "No option manager");
        this.optionTree = new OptionTree();
        this.optionMatrix = new OptionMatrix();
        this.frame = new OptionToolFrame();
        this.optMan.addOptionListener(this.optionTree);
        this.optMan.addOptionListener(this.optionMatrix);
        ip2.addResetHook(new ResetHook());
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    static class MatrixHtmlStringWriter
    extends HtmlStringWriter {
        public MatrixHtmlStringWriter() {
            this.setDefaultAttributes("tr", "align=center");
            this.setDefaultAttributes("th", "align=right bgcolor=\"#99ccff\"");
        }
    }

    class OptionMatrix
    extends JEditorPane
    implements OptionListener {
        HTMLEditorKit matrixEditorKit = new IXHtmlEditorKit();
        Map urlToEvaluationMap = new HashMap();
        Gensym.Generator nameGen = new Gensym.Generator();

        OptionMatrix() {
            this.setEditorKitForContentType("text/html", this.matrixEditorKit);
            this.setContentType("text/html");
            this.setText("");
            Debug.expectSame(this.matrixEditorKit, this.getEditorKit());
            this.setEditable(false);
            this.addHyperlinkListener(new LinkListener());
            this.addMouseListener(new LinkMouseListener());
            this.populateMatrix();
        }

        void reset() {
            this.setText("");
            this.urlToEvaluationMap.clear();
            this.populateMatrix();
        }

        void populateMatrix() {
            SortedMap sortedMap = IPlanOptionTool.this.optMan.getNameToOptionMap();
            MatrixHtmlStringWriter matrixHtmlStringWriter = new MatrixHtmlStringWriter();
            this.urlToEvaluationMap.clear();
            matrixHtmlStringWriter.tag("table", "border=1 cellspacing=0");
            matrixHtmlStringWriter.newLine();
            matrixHtmlStringWriter.tag("tr");
            matrixHtmlStringWriter.tagged("th", "Option:");
            for (Object object : sortedMap.keySet()) {
                matrixHtmlStringWriter.tagged("td", (String)object);
            }
            matrixHtmlStringWriter.end("tr");
            matrixHtmlStringWriter.newLine();
            for (Object object : IPlanOptionTool.this.optMan.getPlanEvaluators()) {
                if (!((PlanEvaluator)object).isVisible()) continue;
                matrixHtmlStringWriter.tag("tr");
                matrixHtmlStringWriter.tagged("td", "align=right", ((PlanEvaluator)object).getShortDescription());
                for (IPlanOptionManager.Opt opt : sortedMap.values()) {
                    PlanEvaluation planEvaluation = opt.getPlanEvaluation((PlanEvaluator)object);
                    if (planEvaluation == null) {
                        matrixHtmlStringWriter.tagged("td", ".");
                        continue;
                    }
                    Object object2 = planEvaluation.getValue();
                    if (planEvaluation.hasDetails()) {
                        matrixHtmlStringWriter.tagged("td", this.makeDetailsLink(planEvaluation));
                        continue;
                    }
                    matrixHtmlStringWriter.tagged("td", object2.toString());
                }
                matrixHtmlStringWriter.end("tr");
                matrixHtmlStringWriter.newLine();
            }
            matrixHtmlStringWriter.end("table");
            matrixHtmlStringWriter.newLine();
            this.setText(matrixHtmlStringWriter.toString());
        }

        String makeDetailsLink(PlanEvaluation planEvaluation) {
            return "<a href=\"" + this.makeDetailsURL(planEvaluation) + "\">" + planEvaluation.getValue() + "</a>";
        }

        String makeDetailsURL(PlanEvaluation planEvaluation) {
            String string = "http://" + this.nameGen.nextString("val");
            this.urlToEvaluationMap.put(string, planEvaluation);
            return string;
        }

        public void optionAdded(OptionEvent optionEvent) {
            this.populateMatrix();
        }

        public void optionSet(OptionEvent optionEvent) {
            this.populateMatrix();
        }

        public void optionRenamed(OptionEvent optionEvent, String string) {
            this.populateMatrix();
        }

        public void optionContentsChanged(OptionEvent optionEvent, EventObject eventObject) {
            this.populateMatrix();
        }

        public void optionDeleted(OptionEvent optionEvent) {
            this.populateMatrix();
        }

        class LinkMouseListener
        extends MouseAdapter {
            LinkMouseListener() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }
        }

        class LinkListener
        implements HyperlinkListener {
            LinkListener() {
            }

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                try {
                    this.do_hyperlinkUpdate(hyperlinkEvent);
                }
                catch (Throwable throwable) {
                    Debug.displayException(throwable);
                }
            }

            public void do_hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String string = hyperlinkEvent.getURL().toString();
                    Debug.noteln("Click on", string);
                    PlanEvaluation planEvaluation = (PlanEvaluation)OptionMatrix.this.urlToEvaluationMap.get(string);
                    Debug.expect(planEvaluation != null, "Can't find plan-evaluation for", string);
                    Object object = planEvaluation.getValue();
                    planEvaluation.detailsRequested();
                    if (planEvaluation.getValue() != object) {
                        OptionMatrix.this.populateMatrix();
                    }
                }
            }
        }
    }

    class TNode
    extends DefaultMutableTreeNode {
        TNode(String string) {
            super(string);
        }

        public TreePath getTreePath() {
            return new TreePath(this.getPath());
        }

        int insertionIndex(TNode tNode) {
            TNode tNode2;
            String string;
            String string2 = (String)tNode.getUserObject();
            int n = 0;
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements() && (string = (String)(tNode2 = (TNode)enumeration.nextElement()).getUserObject()).compareTo(string2) <= 0) {
                ++n;
            }
            return n;
        }
    }

    class OptionTree
    extends JTree
    implements TreeSelectionListener,
    OptionListener {
        DefaultTreeModel model;
        TNode root;
        boolean ignoreSelectionEvent;

        OptionTree() {
            super(new DefaultTreeModel(new TNode("root")));
            this.ignoreSelectionEvent = false;
            this.model = (DefaultTreeModel)this.getModel();
            this.root = (TNode)this.model.getRoot();
            this.setEditable(false);
            this.getSelectionModel().setSelectionMode(1);
            this.addTreeSelectionListener(this);
            this.setShowsRootHandles(true);
            this.setRootVisible(false);
            this.putClientProperty("JTree.lineStyle", "Angled");
            DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
            defaultTreeCellRenderer.setOpenIcon(null);
            defaultTreeCellRenderer.setClosedIcon(null);
            defaultTreeCellRenderer.setLeafIcon(null);
            this.setCellRenderer(defaultTreeCellRenderer);
            this.populateTree();
        }

        void reset() {
            this.root.removeAllChildren();
            this.model.setRoot(this.root);
        }

        TNode findTNode(String string) {
            Enumeration<TreeNode> enumeration = this.root.preorderEnumeration();
            while (enumeration.hasMoreElements()) {
                TNode tNode = (TNode)enumeration.nextElement();
                if (!tNode.getUserObject().equals(string)) continue;
                return tNode;
            }
            return null;
        }

        TNode requireTNode(String string) {
            TNode tNode = this.findTNode(string);
            if (tNode != null) {
                return tNode;
            }
            throw new IllegalArgumentException("Cannot find " + string);
        }

        void populateTree() {
            Object object2;
            TNode tNode = this.root;
            for (Object object2 : IPlanOptionTool.this.optMan.getNameToOptionMap().keySet()) {
                String string = this.parentOptionName((String)object2);
                TNode tNode2 = new TNode((String)object2);
                if (string == null) {
                    tNode = this.root;
                } else if (!tNode.getUserObject().equals(string) && (tNode = this.findTNode(string)) == null) {
                    tNode = this.root;
                }
                tNode.add(tNode2);
            }
            this.model.nodeStructureChanged(this.root);
            Object object3 = this.root.preorderEnumeration();
            while (object3.hasMoreElements()) {
                object2 = (TNode)object3.nextElement();
                this.expandPath(((TNode)object2).getTreePath());
            }
            object3 = this.requireTNode(IPlanOptionTool.this.optMan.getOption().getName());
            object2 = ((TNode)object3).getTreePath();
            this.setSelectionPath((TreePath)object2);
            this.scrollPathToVisible((TreePath)object2);
        }

        private String parentOptionName(String string) {
            IPlanOptionManager.Opt opt = IPlanOptionTool.this.optMan.getOption(string);
            try {
                String string2 = IPlanOptionTool.this.optMan.parentName(opt.getName());
                IPlanOptionManager.Opt opt2 = IPlanOptionTool.this.optMan.getOption(string2);
                return opt2.getName();
            }
            catch (Exception exception) {
                Debug.noteln("Couldn't find parent option name for " + string + " because: " + Debug.describeException(exception));
                return null;
            }
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (this.ignoreSelectionEvent) {
                return;
            }
            TNode tNode = (TNode)this.getLastSelectedPathComponent();
            if (tNode == null) {
                return;
            }
            Debug.noteln("Option tree selection", tNode.getTreePath());
            IPlanOptionTool.this.optMan.setOption((String)tNode.getUserObject());
        }

        public void optionAdded(OptionEvent optionEvent) {
            String string = optionEvent.getOptionName();
            TNode tNode = new TNode(string);
            TNode tNode2 = this.parentTNode(string);
            this.model.insertNodeInto(tNode, tNode2, tNode2.insertionIndex(tNode));
            this.scrollPathToVisible(tNode.getTreePath());
        }

        private TNode parentTNode(String string) {
            String string2 = this.parentOptionName(string);
            if (string2 == null) {
                return this.root;
            }
            TNode tNode = this.findTNode(string2);
            return tNode == null ? this.root : tNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void optionSet(OptionEvent optionEvent) {
            TNode tNode = this.requireTNode(optionEvent.getOptionName());
            try {
                this.ignoreSelectionEvent = true;
                this.setSelectionPath(tNode.getTreePath());
            }
            finally {
                this.ignoreSelectionEvent = false;
            }
        }

        public void optionRenamed(OptionEvent optionEvent, String string) {
            this.root.removeAllChildren();
            this.populateTree();
        }

        public void optionContentsChanged(OptionEvent optionEvent, EventObject eventObject) {
        }

        public void optionDeleted(OptionEvent optionEvent) {
            TNode tNode = this.requireTNode(optionEvent.getOptionName());
            this.model.removeNodeFromParent(tNode);
            if (tNode.getChildCount() == 0) {
                return;
            }
            TNode tNode2 = (TNode)tNode.getFirstChild();
            Enumeration<TreeNode> enumeration = tNode.children();
            while (enumeration.hasMoreElements()) {
                TNode tNode3 = (TNode)enumeration.nextElement();
                this.model.insertNodeInto(tNode3, this.root, this.root.insertionIndex(tNode));
            }
            this.scrollPathToVisible(tNode2.getTreePath());
        }
    }

    class OptionToolFrame
    extends ToolFrame
    implements ActionListener {
        OptionUI optionUI;
        Container contentPane;

        OptionToolFrame() {
            super(IPlanOptionTool.this.ip2.getAgentDisplayName() + " I-Plan Option Tool");
            this.optionUI = new OptionUI(IPlanOptionTool.this.optMan, this);
            this.optionUI.populateSelectOptionMenu();
            this.optionUI.noticeCurrentOptionName(new OptionEvent(IPlanOptionTool.this.optMan, IPlanOptionTool.this.optMan.getOption()));
            this.setIconImage(IconImage.getIconImage(this));
            this.setJMenuBar(this.makeMenuBar());
            this.contentPane = this.getContentPane();
            JScrollPane jScrollPane = new JScrollPane(IPlanOptionTool.this.optionTree);
            jScrollPane.setBorder(BorderFactory.createTitledBorder("Option Tree"));
            JScrollPane jScrollPane2 = new JScrollPane(IPlanOptionTool.this.optionMatrix);
            jScrollPane2.setBorder(BorderFactory.createTitledBorder("Options"));
            JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setResizeWeight(0.1);
            this.contentPane.add((Component)jSplitPane, "Center");
            this.pack();
            this.setSize(500, 300);
            this.validate();
            jSplitPane.setDividerLocation(0.33);
        }

        void reset() {
            IPlanOptionTool.this.optionTree.reset();
            IPlanOptionTool.this.optionMatrix.reset();
        }

        protected JMenuBar makeMenuBar() {
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            jMenuBar.add(jMenu);
            jMenu.add(IFUtil.makeMenuItem("Close", this));
            jMenuBar.add(this.optionUI.getOptionMenu());
            return jMenuBar;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("I-Plan Option Tool frame action:", string);
            if (!string.equals("Close")) {
                throw new ConsistencyException("Nothing to do for " + string);
            }
            IPlanOptionTool.this.frame.setVisible(false);
        }
    }

    protected class ResetHook
    implements Runnable {
        protected ResetHook() {
        }

        public void run() {
            Debug.noteln("Resetting", IPlanOptionTool.this);
            IPlanOptionTool.this.frame.reset();
        }
    }
}

