/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.domain.ListOfConstraint;
import ix.ip2.ActivityHandler;
import ix.ip2.AgendaItem;
import ix.ip2.BindingViewer;
import ix.ip2.HandlerAction;
import ix.iplan.IPlan;
import ix.iplan.IPlanModelManager;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.match.MatchEnv;
import ix.util.match.SimpleMatcher;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IPlanConditionHandler
extends ActivityHandler {
    protected IPlan iplan;
    protected IPlanModelManager modelManager;

    public IPlanConditionHandler(IPlan iPlan) {
        super("Satisfy conditions");
        this.iplan = iPlan;
        this.modelManager = (IPlanModelManager)iPlan.getModelManager();
    }

    public boolean appliesTo(AgendaItem agendaItem) {
        return agendaItem.isExpanded() && (agendaItem.getStatus() == Status.BLANK || agendaItem.getStatus() == Status.POSSIBLE);
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        agendaItem.addAction(new SatisfyAction(agendaItem));
    }

    public void reviseHandlerActions(AgendaItem agendaItem, Object object) {
        if (agendaItem.findAction(SatisfyAction.class) == null) {
            this.addHandlerActions(agendaItem);
        }
    }

    class SatisfyAction
    extends HandlerAction {
        AgendaItem item;
        MatchEnv env = SimpleMatcher.emptyEnv;
        ListOfConstraint filters;
        List filterEnvs = Collections.EMPTY_LIST;
        Set unboundVariables;

        SatisfyAction(AgendaItem agendaItem) {
            this.shortDescription = "Satisfy conditions";
            this.item = agendaItem;
            this.filters = IPlanConditionHandler.this.modelManager.getNodeConditions(agendaItem);
        }

        public boolean isReady() {
            return this.filters.isEmpty() || !this.filterEnvs.isEmpty();
        }

        public void computeStatus() {
            if (!this.filters.isEmpty()) {
                this.filterEnvs = IPlanConditionHandler.this.modelManager.evalFilters(this.filters, this.env);
            }
        }

        public void handle(AgendaItem agendaItem) {
            Debug.expect(agendaItem == this.item);
            ListOfConstraint listOfConstraint = this.filters;
            List list = IPlanConditionHandler.this.modelManager.reevaluateFilters(listOfConstraint);
            Debug.expect(!list.isEmpty(), "Cannot match filter conditions " + listOfConstraint);
            Set set = Variable.varsAnywhereIn(listOfConstraint);
            Set set2 = Variable.unboundVarsIn(set);
            Debug.noteln("Cond vars", set);
            Debug.noteln("Unbound", set2);
            if (set2.isEmpty()) {
                IPlanConditionHandler.this.modelManager.satisfyConds(agendaItem, listOfConstraint, new MatchEnv());
                this.adjustStatus(agendaItem);
                return;
            }
            this.unboundVariables = set2;
            Map map = this.getPossibleValues();
            BindingViewer bindingViewer = new BindingViewer(IPlanConditionHandler.this.iplan, set2, map){

                public void handleBindings(Map map) {
                    if (map != null) {
                        SatisfyAction.this.bind(map);
                        this.resetPossibleValues(SatisfyAction.this.getPossibleValues());
                    }
                }
            };
        }

        protected Map getPossibleValues() {
            return IPlanConditionHandler.this.modelManager.getVariableManager().getPossibleValues(this.unboundVariables);
        }

        protected void bind(Map map) {
            try {
                IPlanConditionHandler.this.modelManager.bindVariables(map);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Debug.displayException(illegalArgumentException);
            }
            Set set = Variable.unboundVarsIn(this.unboundVariables);
            Debug.noteln("Still unbound", set);
            if (set.isEmpty()) {
                IPlanConditionHandler.this.modelManager.satisfyConds(this.item, this.filters, new MatchEnv());
                this.adjustStatus(this.item);
            } else {
                this.item.setHandledBy(null);
            }
        }

        protected void adjustStatus(AgendaItem agendaItem) {
            agendaItem.setStatus(Collect.isEmpty(agendaItem.getChildren()) ? Status.COMPLETE : Status.EXECUTING);
        }
    }
}

