/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.domain.LinkedListOfConstraint;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.ip2.ComputeInterpreter;
import ix.ip2.Ip2ModelManager;
import ix.util.Debug;
import ix.util.DeepCopier;
import ix.util.FailureException;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.match.Bindings;
import ix.util.match.MatchChoice;
import ix.util.match.MatchChoiceManager;
import ix.util.match.MatchEnv;
import ix.util.match.Matcher;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VariableManager
extends MatchChoiceManager {
    protected final boolean MATCH_DEBUG = false;
    protected boolean noticeForced = true;
    protected Ip2ModelManager modelManager;
    protected ComputeInterpreter computeInterpreter;

    public VariableManager(Ip2ModelManager ip2ModelManager) {
        this.modelManager = ip2ModelManager;
        this.computeInterpreter = ip2ModelManager.makeComputeInterpreter();
    }

    ComputeInterpreter getComputeInterpreter() {
        return this.computeInterpreter;
    }

    public void showState() {
    }

    public List evalFilters(ListOfConstraint listOfConstraint, Map map, MatchEnv matchEnv) {
        return new FilterMatcher(map).evalFilters(listOfConstraint, matchEnv);
    }

    public ListOfConstraint testFilters(ListOfConstraint listOfConstraint, Map map, MatchEnv matchEnv) {
        return new FilterMatcher(map).testFilters(listOfConstraint, matchEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryBindings(Map map) {
        Debug.noteln("Var manager trying", map);
        try {
            this.noticeForced = false;
            MatchChoice matchChoice = new MatchChoice(Lisp.list(new Bindings(map)));
            this.add(matchChoice);
            try {
                this.recalculate();
                if (matchChoice.getLiveBranches().isEmpty()) {
                    Debug.noteln("tryBindings fails for", map);
                    super.showState();
                    throw new IllegalArgumentException("Cannot apply binding combination " + map);
                }
            }
            finally {
                this.remove(matchChoice);
                this.recalculate();
            }
        }
        finally {
            this.noticeForced = true;
        }
    }

    public void newBindings(Map map) {
        Debug.noteln("Var manager sees bindings", map);
        this.add(new MatchChoice(Lisp.list(new Bindings(map))));
        this.recalculate();
    }

    public List getConstraints() {
        LinkedList<Constraint> linkedList = new LinkedList<Constraint>();
        for (MatchChoice matchChoice : this.matchChoices) {
            if (Variable.unboundVarsIn(matchChoice.getVariables()).isEmpty()) continue;
            linkedList.add(matchChoice.toConstraint());
        }
        return linkedList;
    }

    protected MatchEnv noticeForcedBindings() {
        if (!this.noticeForced) {
            return null;
        }
        MatchEnv matchEnv = super.noticeForcedBindings();
        if (!matchEnv.isEmpty()) {
            this.modelManager.forcedBindings(matchEnv);
        }
        return matchEnv;
    }

    public boolean consistentBindings(MatchEnv matchEnv) {
        for (Map.Entry entry : matchEnv.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (!(k instanceof Variable) || this.consistentBinding((Variable)k, v)) continue;
            return false;
        }
        return true;
    }

    protected boolean consistentBinding(Variable variable, Object object) {
        if (!this.getVariables().contains(variable) || this.getPossibleValues(variable).contains(object)) {
            return true;
        }
        Debug.noteln("Can't bind " + variable + " to " + object + " because the only possible values are " + this.getPossibleValues(variable));
        Debug.noteln("Vars are", this.getVariables());
        this.showState();
        return false;
    }

    protected Object fullyInstantiate(Object object, final MatchEnv matchEnv) {
        DeepCopier deepCopier = new DeepCopier(){
            private final Symbol QUOTE = Symbol.intern("quote");

            public Object copy(Object object) {
                if (object instanceof Variable || object instanceof ItemVar) {
                    return this.deref(object);
                }
                return super.copy(object);
            }

            private Object deref(Object object) {
                if (object instanceof Variable) {
                    Variable variable = (Variable)object;
                    Object object2 = variable.getValue();
                    if (object2 == null) {
                        object2 = matchEnv.get(variable);
                    }
                    if (object2 == null) {
                        throw new FailureException();
                    }
                    return this.deref(object2);
                }
                if (object instanceof ItemVar) {
                    ItemVar itemVar = (ItemVar)object;
                    Object v = matchEnv.get(itemVar);
                    if (v == null) {
                        throw new FailureException();
                    }
                    return this.deref(v);
                }
                return object;
            }

            private LList quote(Object object) {
                return Lisp.list(this.QUOTE, object);
            }
        };
        return deepCopier.copy(object);
    }

    protected class FilterMatcher {
        protected Map stateMap;
        protected List resultEnvs;
        final Symbol TRUE = Symbol.intern("true");
        final Symbol FALSE = Symbol.intern("false");

        FilterMatcher(Map map) {
            this.stateMap = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List evalFilters(ListOfConstraint listOfConstraint, MatchEnv matchEnv) {
            Debug.expect(!listOfConstraint.isEmpty());
            Debug.expect(this.resultEnvs == null);
            this.resultEnvs = new LinkedList();
            try {
                LList lList = LList.newLList(listOfConstraint);
                this.filter((Constraint)lList.car(), lList.cdr(), matchEnv);
                List list = this.resultEnvs;
                return list;
            }
            finally {
                this.resultEnvs = null;
            }
        }

        ListOfConstraint testFilters(ListOfConstraint listOfConstraint, MatchEnv matchEnv) {
            LinkedListOfConstraint linkedListOfConstraint = new LinkedListOfConstraint();
            block0: for (Constraint constraint : listOfConstraint) {
                if (constraint.getType() != Refinement.S_WORLD_STATE) continue;
                PatternAssignment patternAssignment = constraint.getPatternAssignment();
                for (Map.Entry entry : this.stateMap.entrySet()) {
                    MatchEnv matchEnv2 = this.matchFilter(patternAssignment, entry, matchEnv);
                    if (matchEnv2 == null) continue;
                    linkedListOfConstraint.add(constraint);
                    continue block0;
                }
            }
            return linkedListOfConstraint;
        }

        protected void filter(Constraint constraint, LList lList, MatchEnv matchEnv) {
            if (constraint.getType() == Refinement.S_COMPUTE) {
                this.evalComputeFilter(constraint, lList, matchEnv);
            }
            PatternAssignment patternAssignment = constraint.getPatternAssignment();
            for (Map.Entry entry : this.stateMap.entrySet()) {
                MatchEnv matchEnv2 = this.matchFilter(patternAssignment, entry, matchEnv);
                if (matchEnv2 == null) continue;
                if (lList.isEmpty()) {
                    if (this.resultEnvs.contains(matchEnv2)) continue;
                    this.resultEnvs.add(matchEnv2);
                    continue;
                }
                this.filter((Constraint)lList.car(), lList.cdr(), matchEnv2);
            }
        }

        protected MatchEnv matchFilter(PatternAssignment patternAssignment, Map.Entry entry, MatchEnv matchEnv) {
            MatchEnv matchEnv2 = new MatchEnv((Map)matchEnv);
            matchEnv2 = Matcher.match(patternAssignment.getPattern(), entry.getKey(), matchEnv2);
            if (matchEnv2 == null) {
                return null;
            }
            matchEnv2 = Matcher.match(patternAssignment.getValue(), entry.getValue(), matchEnv2);
            if (matchEnv2 == null) {
                return null;
            }
            if (VariableManager.this.consistentBindings(matchEnv2)) {
                return matchEnv2;
            }
            Debug.noteln("Constraints rejected", entry);
            return null;
        }

        protected void evalComputeFilter(Constraint constraint, LList lList, MatchEnv matchEnv) {
            LList lList2;
            LList lList3 = constraint.getPattern();
            try {
                lList2 = (LList)VariableManager.this.fullyInstantiate(lList3, matchEnv);
            }
            catch (FailureException failureException) {
                return;
            }
            Debug.noteln("Evaluating compute", lList2);
            Object object = VariableManager.this.computeInterpreter.compute(lList2);
            Debug.noteln("Value of " + lList2 + " is " + object);
            if (constraint.getRelation() == Refinement.S_MULTIPLE_ANSWER) {
                if (!(object instanceof Collection)) {
                    Debug.warn("Multiple answer for " + constraint + " is not a collection; instead it is: " + object);
                    return;
                }
                Iterator iterator = ((Collection)object).iterator();
                while (iterator.hasNext()) {
                    this.matchComputeResult(constraint, iterator.next(), lList, matchEnv);
                }
            } else {
                this.matchComputeResult(constraint, object, lList, matchEnv);
            }
        }

        protected void matchComputeResult(Constraint constraint, Object object, LList lList, MatchEnv matchEnv) {
            Object object2 = constraint.getValue();
            MatchEnv matchEnv2 = new MatchEnv((Map)matchEnv);
            matchEnv2 = object2 == this.TRUE ? (VariableManager.this.computeInterpreter.isTrue(object) ? matchEnv2 : null) : (object2 == this.FALSE ? (!VariableManager.this.computeInterpreter.isTrue(object) ? matchEnv2 : null) : Matcher.match(object2, object, matchEnv2));
            if (matchEnv2 != null && VariableManager.this.consistentBindings(matchEnv2)) {
                if (lList.isEmpty()) {
                    if (!this.resultEnvs.contains(matchEnv2)) {
                        this.resultEnvs.add(matchEnv2);
                    }
                } else {
                    this.filter((Constraint)lList.car(), lList.cdr(), matchEnv2);
                }
            }
        }
    }
}

