/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.icore.process.event.ProcessStatusEvent;
import ix.iface.util.IFUtil;
import ix.iface.util.KeyValueTable;
import ix.iface.util.SortingKVTable;
import ix.ip2.Ip2;
import ix.ip2.PanelFrame;
import ix.ip2.PropertyViewTable;
import ix.ip2.StateViewer;
import ix.util.ConsistencyException;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;

public class StateViewTable
extends JPanel
implements StateViewer {
    protected Ip2 ip2;
    protected ViewTable viewTable;
    protected PropertyViewTable propertyViewer;

    public StateViewTable(Ip2 ip2) {
        this.ip2 = ip2;
        this.viewTable = new ViewTable(this);
        this.propertyViewer = new PropertyViewTable(this);
        this.setLayout(new BorderLayout());
        JTable jTable = this.viewTable.getJTable();
        this.add((Component)jTable.getTableHeader(), "North");
        this.add((Component)jTable, "Center");
    }

    public Component getView(PanelFrame panelFrame) {
        return this.viewTable.getJTable();
    }

    public void reset() {
        this.viewTable.reset();
        this.propertyViewer.reset();
    }

    public void statusUpdate(ProcessStatusEvent processStatusEvent) {
    }

    public void newBindings(ProcessStatusEvent processStatusEvent, Map map) {
    }

    public void stateChange(ProcessStatusEvent processStatusEvent, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            LList lList = (LList)entry.getKey();
            Object v = entry.getValue();
            this.viewTable.recordNewValue(lList, v);
            this.propertyViewer.recordNewValue(lList, v);
        }
    }

    public void stateDeletion(ProcessStatusEvent processStatusEvent, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            LList lList = (LList)entry.getKey();
            Object v = entry.getValue();
            this.viewTable.deleteEntry(lList, v);
            this.propertyViewer.deleteEntry(lList, v);
        }
    }

    static class ViewTable
    extends SortingKVTable {
        StateViewTable stateViewer;

        ViewTable(StateViewTable stateViewTable) {
            this(stateViewTable, "Pattern", "Value");
        }

        ViewTable(StateViewTable stateViewTable, String string, String string2) {
            super(string, string2);
            this.stateViewer = stateViewTable;
        }

        protected String keyToString(Object object) {
            return Lisp.elementsToString((LList)object);
        }

        protected KeyValueTable.RowPopupMenu makePopupMenu() {
            return new StatePopupMenu();
        }

        protected Set getRowObjects(int n) {
            Object e = this.keyList.get(n);
            return this.getRowObjects(e, this.getValue(e));
        }

        protected Set getRowObjects(Object object, Object object2) {
            LList lList = (LList)object;
            Set set = this.getMentionedObjects(lList.cdr());
            set.addAll(this.getMentionedObjects(object2));
            return set;
        }

        protected Set getMentionedObjects(Object object) {
            TreeSet treeSet = new TreeSet(new KeyValueTable.LexicographicComparator());
            List list = object instanceof LList ? (List)object : Lisp.list(object);
            for (Object e : list) {
                if (!(e instanceof Symbol) && !(e instanceof String) || !this.isObjectName(e)) continue;
                treeSet.add(e);
            }
            return treeSet;
        }

        protected boolean isObjectName(Object object) {
            for (LList lList : this.keyList) {
                if (lList.size() < 2 || lList.get(1) != object) continue;
                return true;
            }
            return false;
        }

        protected void doPopupAction(ActionEvent actionEvent, int n, Object object) {
            String string = actionEvent.getActionCommand();
            LList lList = (LList)object;
            Object object2 = this.getValue(lList);
            Ip2 ip2 = this.stateViewer.ip2;
            if (string.equals("Change")) {
                PatternAssignment patternAssignment = new PatternAssignment(lList, object2);
                ip2.frame.getSendPanelVisible().initConstraint(patternAssignment);
                ip2.frame.getSendPanelVisible().initToMe();
            } else if (string.equals("Delete")) {
                PatternAssignment patternAssignment = new PatternAssignment(lList, object2);
                Constraint constraint = new Constraint("world-state", "effect", (List)Lisp.list(patternAssignment));
                ip2.getModelManager().deleteConstraint(constraint);
            } else if (string.equals("Copy to Messenger")) {
                PatternAssignment patternAssignment = new PatternAssignment(lList, object2);
                ip2.frame.getSendPanelVisible().initConstraint(patternAssignment);
            } else {
                throw new ConsistencyException("Nothing to do for " + string);
            }
        }

        protected class StatePopupMenu
        extends KeyValueTable.RowPopupMenu {
            JMenu viewMenu = new JMenu("View Object Properties");

            StatePopupMenu() {
                this.add(this.makeMenuItem("Change"));
                this.add(this.makeMenuItem("Delete"));
                this.add(this.makeMenuItem("Copy to Messenger"));
                this.add(new SortingKVTable.SortMenu("Sort Patterns"));
            }

            public void setRow(int n) {
                super.setRow(n);
                this.remove(this.viewMenu);
                Set set = ViewTable.this.getRowObjects(n);
                if (!set.isEmpty()) {
                    this.addObjectMenuItems(this.viewMenu, set);
                    this.add(this.viewMenu);
                }
            }

            void addObjectMenuItems(JMenu jMenu, Set set) {
                jMenu.removeAll();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    jMenu.add(this.makeObjectMenuItem(iterator.next()));
                }
            }

            JMenuItem makeObjectMenuItem(final Object object) {
                String string = Lisp.printToString(object);
                return IFUtil.makeMenuItem(string, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ViewTable.this.stateViewer.propertyViewer.viewObject(object);
                    }
                });
            }
        }
    }
}

