/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.ip2.ComputeInterpreter;
import ix.ip2.Ip2ModelManager;
import ix.iscript.IScriptSource;
import ix.util.Debug;
import ix.util.lisp.Cons;
import ix.util.lisp.Interpreter;
import ix.util.lisp.LList;
import ix.util.lisp.LispInterpreter;
import ix.util.lisp.Symbol;

public class LispComputeInterpreter
extends LispInterpreter
implements ComputeInterpreter {
    public static final Symbol UNDEF = Symbol.intern(":undef");
    protected Ip2ModelManager modelManager;

    public LispComputeInterpreter(Ip2ModelManager ip2ModelManager) {
        this.modelManager = ip2ModelManager;
    }

    public Object compute(Object object) {
        if (object instanceof Cons) {
            Cons cons = (Cons)object;
            Object object2 = cons.car();
            Object object3 = this.topLevelEval(object2);
            if (!(object3 instanceof Interpreter.Function)) {
                throw new ClassCastException("The value of " + object2 + " was not a function.");
            }
            LList lList = cons.cdr();
            return this.topLevelApply((Interpreter.Function)object3, lList.toArray());
        }
        throw new LispInterpreter.SyntaxError("Illegal compute expression: " + object);
    }

    public void loadSupportCode(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof IScriptSource) {
            IScriptSource iScriptSource = (IScriptSource)object;
            Debug.noteln("Loading " + iScriptSource.getSyntax() + " source.");
            this.topLevelEval(iScriptSource.parseSource());
        } else if (object instanceof String) {
            Debug.noteln("Loading support code from", object);
            this.loadLisp((String)object);
        } else {
            throw new Interpreter.Error("Invalid support code", object);
        }
    }

    protected Object getWorldStateValue(LList lList) {
        return this.modelManager.getWorldStateValue(lList);
    }

    protected void defineBuiltins() {
        super.defineBuiltins();
        this.define(new Interpreter.JFunction("get-world-state-value", 1){

            public Object applyTo(Object[] objectArray) {
                LList lList = (LList)this.mustBe(LList.class, objectArray[0]);
                Object object = LispComputeInterpreter.this.getWorldStateValue(lList);
                return object == null ? UNDEF : object;
            }
        });
    }
}

